<?php
include "../../config/db.php";

// Build filters
$where = "1";

if (!empty($_GET['employee_id'])) {
    $emp = intval($_GET['employee_id']);
    $where .= " AND a.user_id = $emp";
}

if (!empty($_GET['from']) && !empty($_GET['to'])) {
    $from = $_GET['from'];
    $to   = $_GET['to'];
    $where .= " AND a.date BETWEEN '$from' AND '$to'";
}

// Query
$q = mysqli_query($con,"
    SELECT 
        a.date,
        u.uname,
        a.check_in,
        a.check_out,
        a.status,
        a.overtime_minutes
    FROM attendance a
    JOIN users u ON u.uid = a.user_id
    WHERE $where
    ORDER BY a.date DESC
");

// Headers for CSV
$filename = "attendance_report_" . date("Ymd_His") . ".csv";
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename='.$filename);
header('Pragma: no-cache');
header('Expires: 0');

// Open output stream
$output = fopen('php://output', 'w');

// Column headers
fputcsv($output, ['Date', 'Employee', 'Check In', 'Check Out', 'Status', 'OT (min)']);

// Data rows
while ($row = mysqli_fetch_assoc($q)) {
    fputcsv($output, [
        $row['date'],
        $row['uname'],
        $row['check_in'],
        $row['check_out'],
        $row['status'],
        $row['overtime_minutes']
    ]);
}

fclose($output);
exit;