<?php
include "../../config/db.php";

/* =========================
   FILTER
========================= */
$where = "1";
$rangeText = "All Records";

if (!empty($_GET['employee_id'])) {
    $emp = intval($_GET['employee_id']);
    $where .= " AND a.user_id = $emp";
}

if (!empty($_GET['from']) && !empty($_GET['to'])) {
    $from = $_GET['from'];
    $to   = $_GET['to'];
    $where .= " AND a.date BETWEEN '$from' AND '$to'";
    $rangeText = date("d M Y", strtotime($from)) . " to " .
                 date("d M Y", strtotime($to));
}

/* =========================
   DATA
========================= */
$q = mysqli_query($con,"
    SELECT a.*, u.uname
    FROM attendance a
    JOIN users u ON u.uid = a.user_id
    WHERE $where
    ORDER BY a.date DESC
");
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Attendance Report</title>

    <style>
    body {
        margin: 0;
        font-family: Arial, Helvetica, sans-serif;
        -webkit-print-color-adjust: exact;
        print-color-adjust: exact;
    }

    body::before {
        content: "";
        position: fixed;
        inset: 0;
        background-image: url('../../assets/img/print/temp-night.webp');
        background-repeat: no-repeat;
        background-size: 100% 100%;
        background-position: center;
        z-index: -1;
    }

    @page {
        size: A4;
        margin-top: 140px;
        /* HEADER SPACE */
        margin-bottom: 180px;
        /* FOOTER SPACE */
        margin-left: 40px;
        margin-right: 40px;
    }

    .wrapper {
        margin: 140px 40px;
    }

    .box {
        max-width: 900px;
        margin: auto;
    }

    h3 {
        text-align: center;
        margin: 0 0 4px 0;
    }

    .sub {
        text-align: center;
        font-size: 14px;
        margin-bottom: 18px;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        font-size: 13px;
        page-break-inside: auto;
    }

    thead {
        display: table-header-group;
        /* repeat header */
    }

    tr {
        page-break-inside: avoid;
        page-break-after: auto;
    }

    th,
    td {
        border: 1px solid #aaa;
        padding: 6px;
    }

    th {
        background: #f2f2f2;
    }

    .signature {
        position: fixed;
        bottom: 60px;
        right: 60px;
        text-align: center;
        display: none;
    }

    .signature img {
        width: 140px;
    }
    </style>
</head>

<body>
    <div class="wrapper">
        <div class="box">

            <h3>Attendance Report</h3>
            <div class="sub"><?= htmlspecialchars($rangeText) ?></div>

            <table>
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Employee</th>
                        <th>In</th>
                        <th>Out</th>
                        <th>Status</th>
                        <th>OT</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($r = mysqli_fetch_assoc($q)): ?>
                    <tr>
                        <td><?= date("d-m-Y", strtotime($r['date'])) ?></td>
                        <td><?= htmlspecialchars($r['uname']) ?></td>
                        <td><?= $r['check_in'] ?: '-' ?></td>
                        <td><?= $r['check_out'] ?: '-' ?></td>
                        <td><?= $r['status'] ?></td>
                        <td><?= $r['overtime_minutes'] ?></td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>

            <div class="signature">
                <img src="../../assets/img/print/syd-sig.webp">
                <div>_________________</div>
                <div>Authorised Signatory</div>
            </div>

        </div>
    </div>

    <script>
    window.onload = () => window.print();
    </script>
</body>


</html>