<?php
include "../../config/db.php";

$where = "1";
if (!empty($_GET['employee_id'])) {
    $emp = intval($_GET['employee_id']);
    $where .= " AND a.user_id = $emp";
}

if (!empty($_GET['from']) && !empty($_GET['to'])) {
    $from = $_GET['from'];
    $to   = $_GET['to'];
    $where .= " AND a.date BETWEEN '$from' AND '$to'";
}

$q = mysqli_query($con,"
    SELECT a.*, u.uname, u.emp_shift
    FROM attendance a
    JOIN users u ON u.uid = a.user_id
    WHERE $where
    ORDER BY a.date DESC
");
?>
<div class="d-flex justify-content-end gap-2 mb-2">
    <a href="ajax/attendance_export_excel.php?<?= http_build_query($_GET) ?>" class="btn btn-success btn-sm">
        <i class="fa fa-file-excel"></i> Excel
    </a>

    <a href="ajax/attendance_export_pdf.php?<?= http_build_query($_GET) ?>" target="_blank"
        class="btn btn-danger btn-sm">
        <i class="fa fa-file-pdf"></i> PDF
    </a>
</div>


<table class="table table-bordered table-sm">
    <thead class="table-light">
        <tr>
            <th>Date</th>
            <th>Employee</th>
            <th>In</th>
            <th>Out</th>
            <th>Status</th>
            <th>OT (min)</th>
            <th>Departure Time</th>
        </tr>
    </thead>
    <tbody>
        <?php while($r = mysqli_fetch_assoc($q)): ?>

        <?php
            $departure_time = '-';

            $shift_time = trim($r["emp_shift"]); // e.g. 10:00-19:00

            if (!empty($shift_time) && strpos($shift_time, '-') !== false) {

                $shift_parts = array_map('trim', explode('-', $shift_time));

                if (count($shift_parts) === 2 && !empty($r['check_out'])) {

                    $shift_end = $shift_parts[1];

                    $shiftEndTime = strtotime($r['date'] . ' ' . $shift_end);
                    $checkOutTime = strtotime($r['date'] . ' ' . $r['check_out']);

                    if ($shiftEndTime && $checkOutTime) {

                        if ($checkOutTime < $shiftEndTime) {
                            $diffMinutes = round(($shiftEndTime - $checkOutTime) / 60);
                            $departure_time = $diffMinutes . " min early";
                        } else {
                            $departure_time = "On Time";
                        }

                    }
                }
            }
        ?>

        <tr>
            <td><?= $r['date'] ?></td>
            <td><?= $r['uname'] ?></td>
            <td><?= $r['check_in'] ?></td>
            <td><?= $r['check_out'] ?></td>
            <td><?= $r['status'] ?></td>
            <td><?= $r['overtime_minutes'] ?></td>
            <td><?= $departure_time ?></td>
        </tr>

        <?php endwhile; ?>
    </tbody>

</table>