<?php
session_start();
include "../../config/db.php";

if (!isset($_SESSION['uref'])) exit;

$adminRef = $_SESSION['uref'];

$q = mysqli_query($con,"
    SELECT
        uref_code,
        uname,
        uphone,
        umail,
        emp_join_date,
        emp_status
    FROM users
    WHERE utype = 'employee'
      AND udisplay != 'disable'
      AND admin_ref = '$adminRef'
    ORDER BY uname ASC
");
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Employee List</title>

    <style>
    body {
        font-family: Arial, Helvetica, sans-serif;
        margin: 0px 30px;
        -webkit-print-color-adjust: exact;
    }

    body::before {
        content: "";
        position: fixed;
        inset: 0;
        /* background: url('../../assets/img/print/temp-night.webp') no-repeat center/100% 100%; */
        z-index: -1;
    }

    @page {
        size: A4;
        margin: 140px 40px 140px 40px;
    }

    h3 {
        text-align: center;
        margin-bottom: 10px;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        font-size: 13px;
    }

    thead {
        display: table-header-group;
    }

    tr {
        page-break-inside: avoid;
    }

    th,
    td {
        border: 1px solid #aaa;
        padding: 6px;
    }

    th {
        background: #f2f2f2;
    }

    .footer {
        position: fixed;
        bottom: 40px;
        right: 60px;
        text-align: center;
        display: none;
    }

    .footer img {
        width: 120px;
    }
    </style>
</head>

<body>

    <h3>Employee List</h3>

    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Phone</th>
                <th>Email</th>
                <th>Joining</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($r = mysqli_fetch_assoc($q)): ?>
            <tr>
                <td><?= $r['uref_code'] ?></td>
                <td><?= htmlspecialchars($r['uname']) ?></td>
                <td><?= $r['uphone'] ?></td>
                <td><?= $r['umail'] ?></td>
                <td><?= $r['emp_join_date'] ?></td>
                <td><?= $r['emp_status'] == 1 ? 'Active' : 'Inactive' ?></td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>

    <div class="footer">
        <img src="../../assets/img/print/syd-sig.webp">
        <div>Authorised Signatory</div>
    </div>

    <script>
    window.onload = () => window.print();
    </script>

</body>

</html>