<?php
session_start();
include "../../config/db.php";

$date = $_GET['date'];
$work_id = $_GET['work_id'];
$url= "employee-work.php?work_id=".$_GET["work_id"];

$schedules = mysqli_query($con, "SELECT * FROM work_schedule WHERE DATE(ws_date) = '$date' AND ws_for = '$work_id' ORDER BY ws_id DESC");

if (mysqli_num_rows($schedules) == 0) {
    echo "<p class='text-muted'>No work schedules for this date.</p>";
} else {
    $count = 1;
    while ($row = mysqli_fetch_assoc($schedules)) {
        $uniqueId = 'customAcc' . $count++;
        $fullDateTime = $row["ws_date"];
        $dateOnly = date("d-m-Y", strtotime($fullDateTime));
        $stime = date("h:i:s A", strtotime($row["ws_startTime"]));
        $etime = date("h:i:s A", strtotime($row["ws_endTime"]));

        // DateTime logic
        $currentDateTime = new DateTime();
        $sessionStartDateTime = new DateTime($fullDateTime . ' ' . $row["ws_startTime"]);
        $sessionEndDateTime = new DateTime($fullDateTime . ' ' . $row["ws_endTime"]);

        $wl_sql = mysqli_query($con, "SELECT * FROM work_list WHERE wl_ws_id = '{$row['ws_id']}'");
        $total = 0;
        $completed = 0;

        while ($wl_r = mysqli_fetch_assoc($wl_sql)) {
            $total++;
            if ($wl_r['wl_status'] == 1) $completed++;
        }

        if ($total == 0) {
            $workStatus = "Incomplete";
        } elseif ($completed == $total) {
            $workStatus = "Completed";
        } elseif ($completed > 0) {
            $workStatus = "Partially Completed";
        } else {
            $workStatus = "Incomplete";
        }

        if ($currentDateTime < $sessionStartDateTime) {
            $status = "Upcoming";
        } elseif ($currentDateTime >= $sessionStartDateTime && $currentDateTime <= $sessionEndDateTime) {
            $status = "Ongoing";
        } else {
            $status = $workStatus;
        }
        ?>

<div class="accordion mb-3">
    <div class="heading">
        <div class="row align-items-center">
            <div class="col-10">
                <h5 class="m-0">
                    <?= $dateOnly . ' (' . $stime . ' - ' . $etime . ')' ?>
                    <span class="badge badge-primary"><?= $status ?></span>
                    <?php if(!empty($row["ws_workPercent"])){ ?>
                    <span class="badge badge-primary">Work Percent: <?= $row["ws_workPercent"] ?>%</span>
                    <?php } ?>
                </h5>
            </div>
            <div class="col-2">
                <div class="d-flex justify-content-end">
                    <a href="<?= $url; ?>&edit_id=<?= $row["ws_id"]; ?>" class="btn btn-success btn-sm me-2"
                        title="Click to Edit">
                        <i class="fa fa-pencil-square" aria-hidden="true"></i>
                    </a>
                    <a href="<?= $url; ?>&del_id=<?= $row["ws_id"]; ?>" class="delete btn btn-danger btn-sm"
                        title="Click to Delete">
                        <i class="fa fa-trash" aria-hidden="true"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="contents d-block">
        <div class="card p-2 mb-2">
            <!--<button type="button" class="btn btn-primary btn-sm openRemarkModal" data-id="<?= $row['ws_id']; ?>">
                Submit Remark
            </button>-->
            <p><strong>Admin Remark:</strong><?= $row["ws_adminRemark"] ?></p>
            <p><strong>Work Remark:</strong><?= $row["ws_workRemark"] ?></p>
        </div>

        <?php
        $wl_sql = mysqli_query($con, "SELECT * FROM work_list WHERE wl_ws_id = '{$row['ws_id']}'");
        $a = 1;
        while ($wl_row = mysqli_fetch_assoc($wl_sql)) {
        ?>
        <div class="row justify-content-between mt-2">
            <div class="col-10">
                <h5>
                    <strong><?= $a . ') '; ?></strong> <?= $wl_row["wl_title"]; ?>
                    <?php if ($wl_row["wl_status"] == '1') { ?>
                    <span class="badge badge-success">Completed</span>
                    <?php } else { ?>
                    <span class="badge badge-warning">Pending</span>
                    <?php } ?>
                </h5>
            </div>
            <div class="col-2">
                <div class="d-flex justify-content-end">
                    <a href="<?= $url; ?>&edit_wl_id=<?= $wl_row["wl_id"]; ?>" class="m-2 btn btn-success btn-sm">
                        <i class="fa fa-pencil-square" aria-hidden="true"></i>
                    </a>
                    <a href="<?= $url; ?>&del_wl_id=<?= $wl_row["wl_id"]; ?>" class="delete m-2 btn btn-danger btn-sm">
                        <i class="fa fa-trash" aria-hidden="true"></i>
                    </a>
                </div>
            </div>
        </div>
        <div class="mb-2" id="imageDisplay"><?= $wl_row["wl_des"]; ?></div>
        <hr>
        <?php
            $a++;
        }
        ?>
    </div>
</div>
<?php 
    }
}
?>