<?php
session_start();
include "../../config/db.php";

if (!isset($_GET['id'])) {
    die("<p class='text-danger text-center'>Invalid Salary Slip</p>");
}

$id = intval($_GET['id']);

function getMonthName($m){
    return date("F", mktime(0,0,0,$m,1));
}

$sql = mysqli_query($con,"
    SELECT e.*, u.uname, u.umail, u.uphone, u.catType, u.utypeorg, u.uref_code
    FROM employee_salary e
    LEFT JOIN users u ON e.salary_for = u.uid
    WHERE e.emp_salary_id = '$id'
");

if(!$row = mysqli_fetch_assoc($sql)){
    die("<p class='text-danger text-center'>Salary record not found</p>");
}

$month = getMonthName($row['salary_month']);
$year  = $row['salary_year'];
?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Salary Report</title>

    <style>
    body {
        margin: 0;
        font-family: Arial, Helvetica, sans-serif;
        -webkit-print-color-adjust: exact;
        print-color-adjust: exact;
    }

    /* FULL PAGE BACKGROUND */
    .salary-wrapper {
        min-height: 100vh;
        background-image: url('../../HRM/assets/img/print/temp-night.webp');
        background-repeat: no-repeat;
        background-size: 100% 100%;
        background-position: center center;
        padding: 20px;
    }

    /* CONTENT BOX */
    .report-box {
        max-width: 900px;
        margin: 0 auto;
        /* background: rgba(255, 255, 255, 0.96);
        padding: 20px; */
        /* margin: 20px 0;   */
        position: relative;
        padding: 80px 0 20px 0;
    }

    /* SIGNATURE */
    .signature-img {
        position: relative;
        bottom: 2px;
        right: 0px;
        width: 150px;
        opacity: 0.95;
    }

    /* TYPOGRAPHY */
    h3,
    h4 {
        margin: 0 0 10px;
    }

    .section {
        margin-top: 5px;
    }

    .section-title {
        font-weight: bold;
        /* border-bottom: 1px solid #ccc; */
        padding-bottom: 5px;
        margin-bottom: 0px;
    }

    /* TABLE */
    .table {
        width: 100%;
        border-collapse: collapse;
        font-size: 14px;
    }

    .table th,
    .table td {
        border: 1px solid #ccc;
        padding: 6px;
        text-align: left;
    }

    .table th {
        background: #f2f2f2;
    }

    .footer {
        margin-top: 30px;
        font-size: 12px;
        color: #555;
        display: flex;
        justify-content: space-between;
    }

    /* PRINT */
    @media print {
        body {
            margin: 0;
            background: none;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }

        .salary-wrapper {
            background-image: url('../../HRM/assets/img/print/temp-night.webp') !important;
            background-repeat: no-repeat !important;
            background-size: 100% 100% !important;
            background-position: center center !important;
            min-height: 100vh !important;
        }

        .signature-img {
            position: fixed !important;
            bottom: 80px !important;
            right: 80px !important;
        }
    }

    @page {
        size: A4;
        margin: 0;
    }
    </style>
</head>

<body>

    <div class="salary-wrapper">

        <div class="report-box">
            <?php
                $find_sql = mysqli_query($con, "SELECT d_name FROM designation WHERE d_id = '$row[utypeorg]' ");
                $find_row = mysqli_fetch_assoc($find_sql);
                $branch = $find_row ? $find_row["d_name"] : '-';
                ?>
            <!-- HEADER -->
            <!--<h3><?php echo htmlspecialchars($row['catType'] ?: 'Company'); ?></h3>-->
            <p style="text-align:center; margin-top: 40px; text:bold;" class="">Pay Slip for
                <?php echo "$month $year"; ?></p>

            <!-- EMPLOYEE DETAILS -->
            <div class="section">
                <div class="section-title">Employee Details</div>
                <div style="display:flex;" class="">
                    <div style="width:50%">
                        <div class="">
                            <strong>Name :</strong> <?php echo htmlspecialchars($row['uname']); ?>
                            [<?php echo htmlspecialchars($row['uref_code']); ?>]
                        </div>
                        <div class="">
                            <strong>Designation :</strong> <?php echo $branch; ?>
                        </div>
                    </div>
                    <div style="width:50%">
                        <div class="">
                            <strong>Phone Number :</strong> <?php echo htmlspecialchars($row['uphone']); ?>
                        </div>
                        <div class="">
                            <strong>Salary Amount :</strong> ₹
                            <?php echo number_format($row['salary_basic'],2); ?>/Month
                        </div>
                    </div>
                </div>
            </div>

            <!-- SALARY CALCULATION -->
            <div class="section">
                <div class="section-title">Salary Calculations</div>

                <table class="table">
                    <tr>
                        <th>EARNINGS</th>
                        <th>AMOUNT</th>
                        <th>DEDUCTIONS</th>
                        <th>AMOUNT</th>
                    </tr>
                    <tr>
                        <td>Basic Salary</td>
                        <td>₹ <?php echo number_format($row['salary_basic'],2); ?></td>
                        <td row-span="2"><?php echo $row['deductions_title'] ?: 'Deductions'; ?></td>
                        <td row-span="2">₹ <?php echo number_format($row['deductions_amount'],2); ?></td>
                    </tr>
                    <tr>
                        <td>Insentives</td>
                        <td>
                            ₹ <?php
                                    $totalIncentive = floatval($row['salary_insentive']) + floatval($row['other_insentive_amount']);
                                    $totalBasicWithIncentive = floatval($row['salary_basic']) + $totalIncentive;
                                    echo number_format($totalIncentive, 2);
                                ?>
                        </td>
                        <td>-</td>
                        <td>-</td>
                    </tr>
                    <tr>
                        <th>Total Earnings</th>
                        <th>₹ <?php echo $totalBasicWithIncentive; ?></th>
                        <th>Total Deductions</th>
                        <th>₹ <?php echo number_format($row['deductions_amount'],2); ?></th>
                    </tr>
                </table>

                <table class="table" style="margin-top:10px;">
                    <tr>
                        <th>Net Salary</th>
                        <td>₹ <?php echo number_format($row['salary_total'],2); ?></td>
                    </tr>
                    <tr>
                        <th>Paid Amount</th>
                        <td>₹ <?php echo number_format($row['salary_total'],2); ?></td>
                    </tr>
                    <tr>
                        <th>Pending Salary</th>
                        <td>₹ 0.00</td>
                    </tr>
                </table>
            </div>

            <!-- ATTENDANCE SUMMARY -->
            <div class="section">
                <div class="section-title">Attendance Summary</div>
                <table class="table">
                    <tr>
                        <th>Present</th>
                        <th>Absent</th>
                        <th>Half Days</th>
                        <th>Paid Leaves</th>
                        <th>Unpaid Leaves</th>
                    </tr>
                    <tr>
                        <td>5.0</td>
                        <td>0.0</td>
                        <td>0.0</td>
                        <td>0.0</td>
                        <td>0.0</td>
                    </tr>
                    <tr>
                        <th>Double Present</th>
                        <th>Weekly Off</th>
                        <th>Holidays</th>
                        <th>Hours Worked</th>
                        <th>Overtime</th>
                    </tr>
                    <tr>
                        <td>0.0</td>
                        <td>0.0</td>
                        <td>0.0</td>
                        <td>00h 00m</td>
                        <td>00h 00m</td>
                    </tr>
                </table>
            </div>

            <!-- PAID AMOUNT -->
            <div class="section">
                <div class="section-title">Paid Amount Breakdown</div>
                <table class="table">
                    <tr>
                        <th>Payment Type</th>
                        <th>Date</th>
                        <th>Amount</th>
                        <th>Notes</th>
                    </tr>
                    <tr>
                        <td>Salary</td>
                        <td><?php echo date("d M Y", strtotime($row['salary_up_date'])); ?></td>
                        <td>₹ <?php echo number_format($row['salary_total'],2); ?></td>
                        <td></td>
                    </tr>
                </table>
            </div>

            <!-- FOOTER -->
            <div class="footer" style="display:none;">
                <div>Generated using HRM System</div>
                <div>Report date: <?php echo date("d-m-Y h:i:s"); ?></div>
            </div>

            <!-- SIGNATURE -->
            <div class="signature-img" style="text-align: end;width: 100%;bottom: 20px;">
                <img src="../../HRM/assets/img/print/syd-sig.webp" class="signature-img">
                <p style="margin:0;">_________________</p>
                <p style="">Authorised Signatory</p>
            </div>

        </div>
    </div>

</body>

</html>