<?php
include "../../config/db.php";

$user_id = $_POST['user_id'];
$month   = $_POST['month'];
$year    = $_POST['year'];

// Get employee details
$emp = $con->query("SELECT emp_join_date FROM users WHERE uid='$user_id'")->fetch_assoc();
$join_date = $emp['emp_join_date']; // yyyy-mm-dd

// CALCULATE SALARY START DATE
$join_day = date("d", strtotime($join_date));
$selected_month_date = "$year-$month-$join_day";

$salary_start = $selected_month_date;
$salary_end = date("Y-m-d", strtotime($salary_start . " +1 month -1 day"));

// GET CURRENT SALARY FROM employee_salary_assigned
$assigned = $con->query("
    SELECT * FROM employee_salary_assigned 
    WHERE user_id='$user_id' LIMIT 1
")->fetch_assoc();

$current_basic  = $assigned['basic_salary'];
$current_hra    = $assigned['hra'];
$current_da     = $assigned['da'];
$current_ta     = $assigned['ta'];
$current_others = $assigned['others'];
$assigned_updated = $assigned['updated_at'];

// CHECK IF SALARY HISTORY SHOULD APPLY
// If selected salary month < assigned updated_at, then use history
$use_history = (strtotime($salary_start) < strtotime($assigned_updated));

// FETCH SALARY HISTORY IF NEEDED
if ($use_history) {

    $history = $con->query("
        SELECT * FROM employee_salary_history 
        WHERE user_id='$user_id' AND DATE(changed_at) <= '$salary_start'
        ORDER BY changed_at DESC LIMIT 1
    ")->fetch_assoc();

    if ($history) {
        $basic_salary = $history['new_basic'];
        $salary_source = "History Before Update";
    } else {
        // fallback to assigned if no history
        $basic_salary = $current_basic;
        $salary_source = "Current Assigned (No History Found)";
    }

} else {
    // Selected month is after update → use assigned salary
    $basic_salary = $current_basic;
    $salary_source = "Current Assigned Salary";
}

// ATTENDANCE CALCULATION
$att = $con->query("
SELECT
    SUM(CASE WHEN status='Present' THEN 1 ELSE 0 END) AS present_days,
    SUM(CASE WHEN status='Absent' THEN 1 ELSE 0 END) AS absent_days,
    SUM(CASE WHEN status='Late' THEN 1 ELSE 0 END) AS late_days,
    SUM(overtime_minutes) AS overtime_minutes,
    SUM(CASE WHEN half_day='1' THEN 0.5 ELSE 1 END) AS paid_days
FROM attendance
WHERE user_id='$user_id'
AND DATE(date) BETWEEN '$salary_start' AND '$salary_end'
")->fetch_assoc();

$present = $att['present_days'] ?? 0;
$absent  = $att['absent_days'] ?? 0;
$late    = $att['late_days'] ?? 0;
$overtime = $att['overtime_minutes'] ?? 0;
$paid_days = $att['paid_days'] ?? 0;

// Generate summary HTML
?>

<div class="table-responsive">
    <table class="table table-bordered table-sm">

        <tr>
            <th width="35%">Joining Date</th>
            <td><?= date("d-m-Y", strtotime($join_date)) ?></td>
        </tr>

        <tr>
            <th>Salary Period</th>
            <td><?= date("d-m-Y", strtotime($salary_start)) ?> to <?= date("d-m-Y", strtotime($salary_end)) ?></td>
        </tr>

        <tr class="table-primary">
            <th colspan="2">Salary Used (Based on Date Criteria)</th>
        </tr>

        <tr>
            <th>Salary Source</th>
            <td><b><?= $salary_source ?></b></td>
        </tr>

        <tr>
            <th>Basic Salary</th>
            <td><?= number_format($basic_salary, 2) ?></td>
        </tr>

        <?php if (!$use_history) { ?>
        <!-- Show full assigned salary only when NOT using history -->
        <tr>
            <th>HRA</th>
            <td><?= number_format($current_hra, 2) ?></td>
        </tr>
        <tr>
            <th>DA</th>
            <td><?= number_format($current_da, 2) ?></td>
        </tr>
        <tr>
            <th>TA</th>
            <td><?= number_format($current_ta, 2) ?></td>
        </tr>
        <tr>
            <th>Others</th>
            <td><?= number_format($current_others, 2) ?></td>
        </tr>
        <?php } ?>

        <?php if ($use_history && !empty($history)) { ?>
        <!-- Show history block -->
        <tr class="table-warning">
            <th>Salary Updated On</th>
            <td><?= date("d-m-Y H:i", strtotime($history['changed_at'])) ?></td>
        </tr>

        <tr>
            <th>Old Basic</th>
            <td><?= number_format($history['old_basic'], 2) ?></td>
        </tr>
        <tr>
            <th>New Basic</th>
            <td><?= number_format($history['new_basic'], 2) ?></td>
        </tr>
        <tr>
            <th>Promotion Title</th>
            <td><?= $history['promotion_title'] ?></td>
        </tr>
        <tr>
            <th>Remark</th>
            <td><?= $history['remark'] ?></td>
        </tr>
        <?php } ?>

        <tr class="table-info">
            <th colspan="2">Attendance Summary</th>
        </tr>

        <tr>
            <th>Paid Days</th>
            <td><?= $paid_days ?></td>
        </tr>
        <tr>
            <th>Late Days</th>
            <td><?= $late ?></td>
        </tr>
        <tr>
            <th>Overtime Minutes</th>
            <td><?= $overtime ?></td>
        </tr>

    </table>
</div>