<?php
session_start();
header('Content-Type: application/json');

include "../../config/db.php";

/* =========================
   AUTH CHECK
========================= */
if (!isset($_SESSION['uid'])) {
    echo json_encode([
        "error" => "NO_SESSION"
    ]);
    exit;
}

if ($_SESSION['utype'] !== 'basic_lvl_admin') {
    echo json_encode([
        "error" => "NOT_AUTHORIZED"
    ]);
    exit;
}

/* =========================
   INPUT FILTERS
========================= */
$where = "1";

if (!empty($_GET['employee_id'])) {
    $emp_id = (int) $_GET['employee_id'];
    $where .= " AND emp_id = {$emp_id}";
}

if (!empty($_GET['from'])) {
    $from = mysqli_real_escape_string($con, $_GET['from']);
    $where .= " AND DATE(created_at) >= '{$from}'";
}

if (!empty($_GET['to'])) {
    $to = mysqli_real_escape_string($con, $_GET['to']);
    $where .= " AND DATE(created_at) <= '{$to}'";
}

/* =========================
   FETCH LOCATION POINTS
========================= */
$sql = " SELECT t.emp_id, u.uname, t.latitude, t.longitude, t.speed, t.accuracy, t.created_at FROM emp_location_track t JOIN users u ON u.uid = t.emp_id WHERE {$where} ORDER BY t.emp_id, t.created_at ASC LIMIT 5000 ";

$q = mysqli_query($con, $sql);

if (!$q) {
    echo json_encode([
        "error" => "DB_ERROR",
        "message" => mysqli_error($con)
    ]);
    exit;
}

/* =========================
   PREPARE RESPONSE
========================= */
$points = [];

while ($row = mysqli_fetch_assoc($q)) {
    $points[] = [
        "emp_id"     => (int) $row['emp_id'],
        "emp_name"   => $row['uname'],
        "latitude"   => (float) $row['latitude'],
        "longitude"  => (float) $row['longitude'],
        "speed"      => (float) $row['speed'],
        "accuracy"   => isset($row['accuracy']) ? (float)$row['accuracy'] : null,
        "created_at" => $row['created_at']
    ];
}

/* =========================
   FINAL OUTPUT
========================= */
echo json_encode([
    "status" => "OK",
    "count"  => count($points),
    "points" => $points
]);