<?php
include "../../config/db.php";

$where = "1";
if (!empty($_GET['employee_id'])) {
    $emp = intval($_GET['employee_id']);
    $where .= " AND s.salary_for = '$emp'";
}

$q = mysqli_query($con,"
    SELECT s.*, u.uname
    FROM employee_salary s
    JOIN users u ON u.uid = s.salary_for
    WHERE $where
    ORDER BY s.salary_year DESC, s.salary_month DESC
");
?>

<table class="table table-bordered table-sm align-middle">
    <thead class="table-light">
        <tr>
            <th>Employee</th>
            <th>Month</th>
            <th>Basic</th>
            <th>Total</th>
            <th>Mode</th>
            <th class="text-center">Action</th>
        </tr>
    </thead>
    <tbody>
        <?php while($r = mysqli_fetch_assoc($q)): ?>
        <tr>
            <td><?= htmlspecialchars($r['uname']) ?></td>
            <td><?= htmlspecialchars($r['salary_month']." / ".$r['salary_year']) ?></td>
            <td><?= htmlspecialchars($r['salary_basic']) ?></td>
            <td><strong><?= htmlspecialchars($r['salary_total']) ?></strong></td>
            <td><?= htmlspecialchars($r['salary_mode']) ?></td>
            <td class="text-center">
                <button type="button" class="btn btn-primary btn-sm print-btn" data-id="<?= $r['emp_salary_id'] ?>"
                    data-empname="<?= htmlspecialchars($r['uname']) ?>">
                    <i class="fa fa-print"></i> Print Slip
                </button>
            </td>
        </tr>
        <?php endwhile; ?>
    </tbody>
</table>

<!-- =========================
     SALARY PRINT MODAL
========================= -->
<div class="modal fade" id="printModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content" id="printArea">
            <div class="modal-header">
                <h5 class="modal-title">Salary Slip</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body" id="printContent">
                <div class="text-center text-muted my-4">Loading…</div>
            </div>

            <div class="modal-footer d-print-none">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="fa fa-times"></i> Close
                </button>
                <button type="button" class="btn btn-primary" id="printBtn">
                    <i class="fa fa-print"></i> Print
                </button>
            </div>
        </div>
    </div>
</div>