<?php
session_start();
include "../../config/db.php";
date_default_timezone_set('Asia/Kolkata'); // adjust if needed

if (isset($_POST['ws_id'], $_POST['ws_adminRemark'], $_POST['ws_workPercent'])) {
    $ws_id = mysqli_real_escape_string($con, $_POST['ws_id']);
    $newRemark = trim(mysqli_real_escape_string($con, $_POST['ws_adminRemark']));
    $percent = mysqli_real_escape_string($con, $_POST['ws_workPercent']);

    // Current timestamp and user info
    $currentDateTime = date('Y-m-d H:i:s');
    $adminId = isset($_SESSION['uid']) ? $_SESSION['uid'] : '0';

    // Fetch the existing remark
    $query = mysqli_query($con, "SELECT ws_adminRemark FROM work_schedule WHERE ws_id = '$ws_id'");
    $row = mysqli_fetch_assoc($query);
    $oldRemark = $row ? trim($row['ws_adminRemark']) : '';

    // Format new remark entry
    // $remarkEntry = "[$currentDateTime] Admin (ID: $adminId): $newRemark";
    $remarkEntry = "[$currentDateTime] Admin: $newRemark";

    // Combine with old remark (if exists)
    $finalRemark = $oldRemark ? $oldRemark . "\n" . $remarkEntry : $remarkEntry;

    // ✅ Update record
    $update = mysqli_query($con, "
        UPDATE work_schedule 
        SET ws_adminRemark = '" . mysqli_real_escape_string($con, $finalRemark) . "', 
            ws_workPercent = '$percent' 
        WHERE ws_id = '$ws_id'
    ");

    // 🟢 Return JSON for debugging if you want to inspect from JS console
    if ($update) {
        echo "success";
    } else {
        echo "error: " . mysqli_error($con);
    }
}
?>