<?php
session_start();
include "../../config/db.php";

$where = "1";
if (!empty($_GET['employee_id'])) {
    $where .= " AND ws.ws_for = '{$_GET['employee_id']}'";
}

$userQ = mysqli_query($con,"SELECT uname FROM users WHERE uid='{$_GET['employee_id']}'");
$user  = mysqli_fetch_assoc($userQ);

$fromText = $toText = '';

if (!empty($_GET['from']) && !empty($_GET['to'])) {
    $from = $_GET['from'];
    $to   = $_GET['to'];
    $fromText = date("d M Y", strtotime($from));
    $toText   = date("d M Y", strtotime($to));
    $where .= " AND ws.ws_date BETWEEN '$from' AND '$to'";
}

$q = mysqli_query($con,"
    SELECT
        ws.ws_date,
        ws.ws_status,
        wl.wl_title,
        wl.wl_des,
        wl.wl_status,
        wl.wl_statusUpdateDT
    FROM work_schedule ws
    LEFT JOIN work_list wl
        ON ws.ws_id = wl.wl_ws_id
    WHERE $where
      AND wl.wl_recycle = '1'
    ORDER BY ws.ws_date ASC, wl.wl_uploadDT ASC
");
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Work Report</title>

    <style>
    body {
        margin: 0;
        font-family: Arial, Helvetica, sans-serif;
        -webkit-print-color-adjust: exact;
        print-color-adjust: exact;
    }

    .report-wrapper {
        min-height: 94.55vh;
        background-image: url('../../assets/img/print/temp-night.webp') !important;
        background-repeat: no-repeat !important;
        background-size: 100% 100% !important;
        background-position: center !important;
        padding: 30px !important;
    }

    .report-box {
        max-width: 900px !important;
        margin: 0 auto !important;
        padding: 80px 0 20px 0 !important;
    }

    h3 {
        text-align: center;
        margin-bottom: 5px;
    }

    .sub-title {
        text-align: center;
        margin-bottom: 20px;
        font-size: 14px;
    }

    .table {
        width: 100%;
        border-collapse: collapse;
        font-size: 13px;
    }

    .table th,
    .table td {
        border: 1px solid #aaa;
        padding: 6px;
        vertical-align: top;
    }

    .table th {
        background: #f2f2f2;
    }

    .signature {
        position: fixed;
        bottom: 80px;
        right: 80px;
        text-align: center;
        display: none;
    }

    .signature img {
        width: 150px;
    }

    @page {
        size: A4;
        margin: 0;
    }
    </style>
</head>

<body>

    <div class="report-wrapper">
        <div class="report-box">

            <h3>Work Report</h3>
            <div class="sub-title">
                <?= htmlspecialchars($user['uname']) ?><br>
                <?= $fromText && $toText ? "$fromText to $toText" : "All Records" ?>
            </div>

            <table class="table">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Employee</th>
                        <th>Work Title</th>
                        <th>Description</th>
                        <th>Work Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($r = mysqli_fetch_assoc($q)): ?>
                    <tr>
                        <td><?= date("d-m-Y", strtotime($r['ws_date'])) ?></td>
                        <td><?= htmlspecialchars($user['uname']) ?></td>
                        <td><?= $r['wl_title'] ?></td>
                        <td><?= $r['wl_des'] ?></td>
                        <td><?= $r['wl_status'] == 1 ? 'Completed' : 'Pending' ?></td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>

            <!-- SIGNATURE -->
            <div class="signature">
                <img src="../../assets/img/print/syd-sig.webp">
                <div>_________________</div>
                <div>Authorised Signatory</div>
            </div>

        </div>
    </div>

    <script>
    window.onload = function() {
        window.print();
    };
    </script>

</body>

</html>