<?php
include('./include/header.php');
include('../config/functions.php');

// ✅ Add fallback if clean() is not defined
if (!function_exists('clean')) {
    function clean($data) {
        return htmlspecialchars(trim($data), ENT_QUOTES, 'UTF-8');
    }
}

$message = "";
$success = false;

// ✅ Handle attendance form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $date = clean($_POST['date']);
    $user_id = intval($_POST['user_id']);
    $status = clean($_POST['status']);
    $check_in = !empty($_POST['check_in']) ? clean($_POST['check_in']) : null;
    $check_out = !empty($_POST['check_out']) ? clean($_POST['check_out']) : null;
    $remarks = clean($_POST['remarks']);

    // ✅ Validate basic data
    if (!$user_id || empty($date) || empty($status)) {
        $message = "Please fill in all required fields.";
    } else {
        // ✅ Check if attendance already marked
        $stmt = $con->prepare("SELECT att_id FROM attendance WHERE user_id = ? AND date = ?");
        $stmt->bind_param("is", $user_id, $date);
        $stmt->execute();
        $res = $stmt->get_result();

        if ($res->num_rows > 0) {
            $message = "Attendance for this employee is already marked for the selected date.";
        } else {
            $stmt = $con->prepare("INSERT INTO attendance (user_id, date, status, check_in, check_out, remarks) VALUES (?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("isssss", $user_id, $date, $status, $check_in, $check_out, $remarks);

            if ($stmt->execute()) {
                $success = true;
                $message = "✅ Attendance marked successfully!";
            } else {
                $message = "❌ Failed to mark attendance. Please try again.";
            }
        }
    }
}
?>

<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>

    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>

        <div class="container-fluid p-4" id="body-content">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="fw-bold mb-0">
                    <i class="fa fa-plus-circle me-2 text-primary"></i>Mark Attendance
                </h5>
                <a href="./attendance.php" class="btn btn-sm btn-secondary">
                    <i class="fa fa-arrow-left me-1"></i> Back
                </a>
            </div>

            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <?php if ($message): ?>
                    <div class="alert alert-<?= $success ? 'success' : 'danger' ?> small text-center py-2 mb-3">
                        <?= htmlspecialchars($message) ?>
                    </div>
                    <?php endif; ?>

                    <form method="POST" autocomplete="off" class="row g-3">
                        <div class="col-md-4">
                            <label class="form-label fw-semibold">Select Employee</label>
                            <select name="user_id" class="form-select" required>
                                <option value="">-- Select Employee --</option>
                                <?php
                                $sql = mysqli_query($con, "SELECT uid, uname, utypeorg FROM users WHERE utype='employee' AND emp_status='0' ORDER BY uname ASC");
                                while ($row = mysqli_fetch_assoc($sql)) {
                                    $find_sql = mysqli_query($con, "SELECT d_name FROM designation WHERE d_id = '{$row['utypeorg']}'");
                                    $find_row = mysqli_fetch_assoc($find_sql);
                                    $designation = $find_row ? $find_row["d_name"] : "-";
                                    echo "<option value='{$row['uid']}'>{$row['uname']} ({$designation})</option>";
                                }
                                ?>
                            </select>
                        </div>

                        <div class="col-md-4">
                            <label class="form-label fw-semibold">Date</label>
                            <input type="date" name="date" value="<?= date('Y-m-d'); ?>" class="form-control" required>
                        </div>

                        <div class="col-md-4">
                            <label class="form-label fw-semibold">Status</label>
                            <select name="status" class="form-select" required>
                                <option value="Present">Present</option>
                                <option value="Late">Late</option>
                                <option value="Absent">Absent</option>
                                <option value="On Leave">On Leave</option>
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label class="form-label fw-semibold">Check-In</label>
                            <input type="time" name="check_in" class="form-control">
                        </div>

                        <div class="col-md-3">
                            <label class="form-label fw-semibold">Check-Out</label>
                            <input type="time" name="check_out" class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label class="form-label fw-semibold">Remarks</label>
                            <input type="text" name="remarks" class="form-control" placeholder="Optional remarks">
                        </div>

                        <div class="col-12 text-end">
                            <button type="submit" class="btn btn-primary px-4">
                                <i class="fa fa-check me-1"></i> Mark Attendance
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <?php include('./include/footer.php'); ?>
    </div>
</div>

<?php include('./include/js.php'); ?>