<?php
include "./include/header.php";

if (!defined('ATTENDANCE_SECRET')) {
    define('ATTENDANCE_SECRET', '9b43a6139c55a7c402d9e75af1c5df83e798a20cdf80428e7394074aa590f1ef');
}
?>
<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>
    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>

        <div class="container-fluid p-4" id="body-content">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="fw-bold mb-0">
                    <i class="fa fa-fingerprint me-2 text-primary"></i>Attendance Management
                </h5>
                <button class="btn btn-sm btn-success d-none" data-bs-toggle="modal" data-bs-target="#qrModal">
                    <i class="fa fa-qrcode me-1"></i> Generate QR
                </button>
            </div>

            <?php
            // HANDLE ATTENDANCE SUBMISSION
            if ($_SERVER['REQUEST_METHOD'] === 'POST') {

                $user_id = intval($_POST['user_id']);
                $date = date('Y-m-d');
                $now = date('Y-m-d H:i:s');
                $nowTime = date('H:i:s');

                // FETCH EMP SHIFT
                $userQ = mysqli_query($con, "SELECT emp_shift FROM users WHERE uid = '$user_id'");
                $userData = mysqli_fetch_assoc($userQ);

                list($shift_start, $shift_end) = explode('-', $userData['emp_shift']);

                // Convert shift limits
                $shiftStartTime = date("H:i:s", strtotime($shift_start));
                $shiftEndTime   = date("H:i:s", strtotime($shift_end));

                // Add grace times
                $halfDayLimit   = date("H:i:s", strtotime($shiftStartTime . " +15 minutes"));
                $checkoutLimit  = date("H:i:s", strtotime($shiftEndTime . " +20 minutes"));
                $overtimeLimit  = date("H:i:s", strtotime($shiftEndTime . " +30 minutes"));

                // CHECK-IN
                if (isset($_POST['check_in'])) {

                    if ($nowTime <= $shiftStartTime) {
                        $status = "Present";
                        $half_day = 0;
                    } elseif ($nowTime > $halfDayLimit) {
                        $status = "Half Day";
                        $half_day = 1;
                    } else {
                        $status = "Late";
                        $half_day = 0;
                    }

                    $shift_time = $userData['emp_shift'];

                    $stmt = $con->prepare("
                        INSERT INTO attendance 
                        (user_id, date, check_in, status, half_day, shift_time, created_at) 
                        VALUES (?, ?, ?, ?, ?, ?, NOW())
                    ");
                    $stmt->bind_param("isssi", $user_id, $date, $now, $status, $half_day, $shift_time);
                    $stmt->execute();

                }

                // CHECK-OUT
                elseif (isset($_POST['check_out'])) {

                    $remarks = trim($_POST['remarks']);
                    $overtime_minutes = 0;

                    if ($nowTime > $overtimeLimit) {

                        // calculate overtime
                        $endTimeFull = date("Y-m-d H:i:s", strtotime($date . " " . $shiftEndTime));
                        $overtime_minutes = round((strtotime($now) - strtotime($endTimeFull)) / 60);
                    }

                    $stmt = $con->prepare("
                        UPDATE attendance 
                        SET check_out=?, remarks=?, overtime_minutes=? 
                        WHERE user_id=? AND date=?
                    ");

                    $stmt->bind_param("ssiis", $now, $remarks, $overtime_minutes, $user_id, $date);
                    $stmt->execute();
                }
            }
            ?>


            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <form method="get" class="row g-2 mb-3">
                        <div class="col-md-3">
                            <input type="date" name="date" value="<?= $_GET['date'] ?? date('Y-m-d'); ?>"
                                class="form-control form-control-sm">
                        </div>

                        <div class="col-md-3">
                            <select name="department" class="form-select form-select-sm">
                                <option value="">All Departments</option>
                                <?php
                                $deptRes = mysqli_query($con, "SELECT d_id, d_name FROM designation ORDER BY d_name ASC");
                                while ($dept = mysqli_fetch_assoc($deptRes)) {
                                    $sel = ($_GET['department'] ?? '') == $dept['d_id'] ? 'selected' : '';
                                    echo "<option value='{$dept['d_id']}' $sel>{$dept['d_name']}</option>";
                                }
                                ?>
                            </select>
                        </div>

                        <div class="col-md-2">
                            <button type="submit" class="btn btn-success btn-sm w-100">
                                <i class="fa fa-filter me-1"></i> Filter
                            </button>
                        </div>
                    </form>

                    <div class="table-responsive">
                        <table class="table table-hover align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>Employee</th>
                                    <th>Status</th>
                                    <th>Check-In</th>
                                    <th>Check-Out</th>
                                    <th>Overtime</th>
                                    <th>Remarks</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $date = $_GET['date'] ?? date('Y-m-d');
                                $dept = $_GET['department'] ?? '';

                                // AUTO UPDATE / INSERT ATTENDANCE IF EMPLOYEE IS ON APPROVED LEAVE
                                $leaveQ = mysqli_query($con, "SELECT * FROM leaves WHERE status='Approved' AND '$date' BETWEEN start_date AND end_date");

                                while($lv = mysqli_fetch_assoc($leaveQ)) {

                                    $uid = $lv['user_id'];

                                    // check if attendance already exists
                                    $attExists = mysqli_query($con,"SELECT att_id FROM attendance WHERE user_id='$uid' AND date='$date'");

                                    if(mysqli_num_rows($attExists) > 0){
                                        // update existing
                                        mysqli_query($con,"UPDATE attendance SET status='On Leave', check_in=NULL, check_out=NULL, half_day=0 WHERE user_id='$uid' AND date='$date'");
                                    } else {
                                        // insert new automatic entry
                                        mysqli_query($con,"INSERT INTO attendance (user_id,date,status,half_day,created_at) VALUES ('$uid','$date','On Leave',0,NOW())");
                                    }
                                }


                                $query = "SELECT * FROM users WHERE admin_ref = '{$_SESSION["uref"]}' AND utype = 'employee' AND emp_status = '1' AND udisplay !='disable'";
                                if (!empty($dept)) $query .= " AND utypeorg='$dept'";
                                $query .= " ORDER BY uname ASC";

                                $employees = mysqli_query($con, $query);
                                $i = 1;

                                if (mysqli_num_rows($employees) > 0) {
                                    while ($emp = mysqli_fetch_assoc($employees)) {
                                        $att_q = mysqli_query($con, "SELECT * FROM attendance WHERE user_id='{$emp['uid']}' AND date='$date'");
                                        $att = mysqli_fetch_assoc($att_q);

                                        $desg = '-';
                                        $find_sql = mysqli_query($con, "SELECT d_name FROM designation WHERE d_id='{$emp['utypeorg']}'");
                                        if ($find_row = mysqli_fetch_assoc($find_sql)) $desg = $find_row['d_name'];

                                        $status = $att['status'] ?? 'Not Marked';
                                        $badge = match($status) {
                                            'Present' => 'success',
                                            'Late' => 'warning',
                                            'Half Day' => 'warning',
                                            'Absent' => 'danger',
                                            'On Leave' => 'info',
                                            default => 'secondary'
                                        };

                                        // Overtime calculation
                                        list($shift_start, $shift_end) = explode('-', $emp['emp_shift']);

                                        // Convert shift limits
                                        $shiftStartTime = date("H:i:s", strtotime($shift_start));
                                        $workingEnd = $shiftEndTime   = date("H:i:s", strtotime($shift_end));
                                        $overtime = "-";
                                        if (!empty($att['check_out'])) {
                                            $endTime = strtotime($workingEnd);
                                            $checkout = strtotime($att['check_out']);
                                            $allowedCheckout = $endTime + (20 * 60);
                                            if ($checkout <= $allowedCheckout) {
                                                $overtime = "No OT";
                                            } else {
                                                $otSeconds = $checkout - $endTime;
                                                $overtime = gmdate("H:i:s", $otSeconds);
                                            }
                                        }

                                        echo "<tr>
                                            <td>{$i}</td>
                                            <td>
                                                <div class='fw-semibold'>{$emp['uname']}</div>
                                                <div class='text-muted small'>{$desg}</div>
                                            </td>
                                            <td><span class='badge bg-{$badge}'>{$status}</span></td>
                                            <td>" . ($att['check_in'] ?? '-') . "</td>
                                            <td>" . ($att['check_out'] ?? '-') . "</td>
                                            <td>{$overtime}</td>
                                            <td>" . ($att['remarks'] ?? '-') . "</td>
                                            <td><button class='btn btn-sm btn-outline-primary' data-bs-toggle='modal' data-bs-target='#attModal{$emp['uid']}'>
                                                <i class='fa fa-edit me-1'></i>Mark
                                            </button></td>
                                        </tr>";

                                        // MODAL FOR EACH EMPLOYEE
                                        echo "
                                        <div class='modal fade' id='attModal{$emp['uid']}' tabindex='-1'>
                                            <div class='modal-dialog'>
                                                <div class='modal-content border-0 shadow'>
                                                    <div class='modal-header bg-primary text-white'>
                                                        <h6 class='modal-title'>
                                                            <i class='fa fa-clock me-1'></i> Mark Attendance - {$emp['uname']}
                                                        </h6>
                                                        <button type='button' class='btn-close btn-close-white' data-bs-dismiss='modal'></button>
                                                    </div>
                                                    <div class='modal-body'>
                                                        <form method='post'>
                                                            <input type='hidden' name='user_id' value='{$emp['uid']}'>
                                                            <div class='mb-3'>
                                                                <label class='form-label fw-bold'>Date</label>
                                                                <input type='text' class='form-control' value='" . date('Y-m-d') . "' readonly>
                                                            </div>";

                                        if (!$att) {
                                            echo "
                                            <div class='mb-3'>
                                                <label class='form-label fw-bold'>Check-In Time</label>
                                                <input type='text' class='form-control' value='" . date('H:i:s') . "' readonly>
                                            </div>
                                            <button type='submit' name='check_in' class='btn btn-success w-100'>
                                                <i class='fa fa-sign-in-alt me-1'></i> Submit Check-In
                                            </button>";
                                        } else {
                                            echo "
                                            <div class='mb-3'>
                                                <label class='form-label fw-bold'>Check-Out Time</label>
                                                <input type='text' class='form-control' value='" . date('H:i:s') . "' readonly>
                                            </div>
                                            <div class='mb-3'>
                                                <label class='form-label fw-bold'>Remarks</label>
                                                <textarea name='remarks' class='form-control' rows='2'></textarea>
                                            </div>
                                            <button type='submit' name='check_out' class='btn btn-primary w-100'>
                                                <i class='fa fa-sign-out-alt me-1'></i> Submit Check-Out
                                            </button>";
                                        }

                                        echo "
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>";
                                        $i++;
                                    }
                                } else {
                                    echo "<tr><td colspan='7' class='text-center text-muted'>No employees found.</td></tr>";
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- QR MODAL -->
        <div class="modal fade" id="qrModal" tabindex="-1" aria-labelledby="qrModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content border-0 shadow-lg">
                    <div class="modal-header bg-success text-white">
                        <h5 class="modal-title" id="qrModalLabel"><i class="fa fa-qrcode me-2"></i>Today's Attendance QR
                        </h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body text-center">
                        <?php
                        $today = date('Y-m-d');
                        // token uses secret from config
                        $token = hash('sha256', $today . ATTENDANCE_SECRET);
                        // Use your employee scanner entry point (attendance-scan.php). This page will redirect employees to their portal and attach token/session.
                        $attendanceLink = "http://kallol.digix.in/employee/attendance-scan.php?token={$token}";
                        ?>
                        <p class="text-muted small mb-2">Employees can scan this QR code to mark attendance.</p>
                        <div id="qrcode"></div>
                        <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
                        <script>
                        new QRCode(document.getElementById("qrcode"), {
                            text: "<?= htmlspecialchars($attendanceLink) ?>",
                            width: 200,
                            height: 200
                        });
                        </script>
                        <p class="mt-3 small text-muted">Generated for <?= date('d M Y'); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <?php include('./include/footer.php'); ?>
    </div>
</div>
<?php include('./include/js.php'); ?>