<?php include('./include/header.php'); ?>
<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>
    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>

        <div class="container-fluid p-4" id="body-content">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="fw-bold mb-0"><i class="fa fa-fingerprint me-2 text-primary"></i>Attendance Management</h5>
                <a href="./attendance-mark.php" class="btn btn-sm btn-primary">
                    <i class="fa fa-plus me-1"></i> Mark Attendance
                </a>
            </div>

            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <form method="get" class="row g-2 mb-3">
                        <div class="col-md-3">
                            <input type="date" name="date" value="<?= $_GET['date'] ?? date('Y-m-d'); ?>"
                                class="form-control form-control-sm">
                        </div>
                        <div class="col-md-3">
                            <select name="department" class="form-select form-select-sm">
                                <option value="">All Departments</option>
                                <option>Sales</option>
                                <option>HR</option>
                                <option>Finance</option>
                                <option>Marketing</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <button type="submit" class="btn btn-success btn-sm w-100"><i class="fa fa-filter me-1"></i>
                                Filter</button>
                        </div>
                    </form>

                    <div class="table-responsive">
                        <table class="table table-hover align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>Employee</th>
                                    <th>Department</th>
                                    <th>Status</th>
                                    <th>Check-In</th>
                                    <th>Check-Out</th>
                                    <th>Remarks</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $date = $_GET['date'] ?? date('Y-m-d');
                                $dept = $_GET['department'] ?? '';

                                $query = "SELECT a.*, u.uname, u.utypeorg 
                                          FROM attendance a 
                                          JOIN users u ON a.user_id = u.uid 
                                          WHERE u.utype='employee' AND a.date = ?";
                                $types = "s";
                                $params = [$date];
                                
                                if (!empty($dept)) {
                                    $query .= " AND u.utypeorg = ?";
                                    $types .= "s";
                                    $params[] = $dept;
                                }
                                $query .= " ORDER BY u.uname ASC";

                                $stmt = $con->prepare($query);
                                $stmt->bind_param($types, ...$params);
                                $stmt->execute();
                                $result = $stmt->get_result();
                                $i = 1;

                                if ($result->num_rows > 0) {
                                    while ($row = $result->fetch_assoc()) {
                                        $find_sql = mysqli_query($con, "SELECT d_name FROM designation WHERE d_id = '{$row['utypeorg']}'");
                                        $find_row = mysqli_fetch_assoc($find_sql);
                                        $designation = $find_row ? $find_row["d_name"] : "-";
                                        
                                        $badgeClass = match($row['status']) {
                                            'Present' => 'success',
                                            'Late' => 'warning',
                                            'Absent' => 'danger',
                                            default => 'secondary'
                                        };
                                        echo "<tr>
                                            <td>{$i}</td>
                                            <td>{$row['uname']}</td>
                                            <td>{$designation}</td>
                                            <td><span class='badge bg-{$badgeClass}'>{$row['status']}</span></td>
                                            <td>{$row['check_in']}</td>
                                            <td>{$row['check_out']}</td>
                                            <td>{$row['remarks']}</td>
                                        </tr>";
                                        $i++;
                                    }
                                } else {
                                    echo "<tr><td colspan='7' class='text-center text-muted'>No attendance records found.</td></tr>";
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <?php include('./include/footer.php'); ?>
    </div>
</div>
<?php include('./include/js.php'); ?>