<?php include('./include/header.php'); ?>

<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>

    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>

        <div class="container-fluid p-4" id="body-content">

            <?php
            if (isset($_GET["edit_id"])) {
                $edit_run = mysqli_query($con, "SELECT d_name FROM designation WHERE d_id = '{$_GET['edit_id']}'");
                $edit_row = mysqli_fetch_assoc($edit_run);
            ?>
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="mb-0">
                    <i class="fa fa-sitemap me-2 text-primary"></i> Edit Department
                </h5>
            </div>

            <div class="card shadow-sm border-0 mb-4">
                <div class="card-body">
                    <form class="user" method="post" enctype="multipart/form-data">
                        <div class="row">
                            <div class="col-sm-12 mb-3">
                                <input type="text" class="form-control form-control-sm" id="d_name"
                                    placeholder="Name of designation *" name="d_name"
                                    value="<?php echo htmlspecialchars($edit_row['d_name']); ?>" required>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-success btn-sm my-2" name="edit_cat">
                            <i class="fas fa-pencil-alt"></i> Update Designation
                        </button>
                        <a href="departments.php" class="btn btn-warning btn-sm m-2">
                            <i class="fas fa-ban"></i> Cancel
                        </a>
                    </form>
                </div>
            </div>

            <?php } else { ?>

            <!-- Toggle button (top-right) -->
            <div class="d-block d-lg-flex justify-content-between align-items-center mb-3">
                <h5 class="mb-2 mb-lg-0">
                    <i class="fa fa-sitemap me-2 text-primary"></i> Department Management
                </h5>

                <!-- THIS button will show/hide the whole add-card -->
                <button class="btn btn-success btn-sm" type="button" data-bs-toggle="collapse"
                    data-bs-target="#addDesignationCard" aria-expanded="false" aria-controls="addDesignationCard">
                    <i class="fa fa-plus me-1"></i> Add Department
                </button>
            </div>

            <!-- The collapse wrapper that contains the whole card -->
            <div class="collapse" id="addDesignationCard">
                <div class="card shadow-sm border-0 mb-4">
                    <div class="card-body">
                        <form class="user" method="post" enctype="multipart/form-data">
                            <!-- Inner area that can also collapse if you want more fine-grained control -->
                            <div class="collapse show" id="addDesignationInner">
                                <div class="row">
                                    <div class="col-sm-12 mb-3">
                                        <input type="text" class="form-control form-control-sm" id="d_name"
                                            placeholder="Enter designation name *" name="d_name" required>
                                    </div>
                                </div>

                                <button type="submit" class="btn btn-primary btn-sm my-2" name="new_designation">
                                    <i class="fas fa-plus"></i> Add New Designation
                                </button>

                                <!-- Cancel should NOT submit the form; use type="button" and toggle collapse -->
                                <button type="button" class="btn btn-warning btn-sm m-2" data-bs-toggle="collapse"
                                    data-bs-target="#addDesignationCard" aria-controls="addDesignationCard">
                                    <i class="fas fa-ban"></i> Cancel
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="card shadow-sm border-0 mb-5">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h4 class="badge bg-secondary mb-0">Department List</h4>
                        <small class="text-muted">
                            <i class="fa fa-layer-group me-1"></i> Total:
                            <?php
                                $count_sql = mysqli_query($con, "SELECT COUNT(*) AS total FROM designation WHERE d_by='{$_SESSION['uid']}'");
                                $count_row = mysqli_fetch_assoc($count_sql);
                                echo $count_row['total'];
                            ?>
                        </small>
                    </div>

                    <?php
                    $sql = "SELECT * FROM designation WHERE d_by = '{$_SESSION['uid']}' ORDER BY d_id ASC";
                    $run = mysqli_query($con, $sql);
                    $c = 1;

                    if (mysqli_num_rows($run) > 0) {
                        echo '<ul class="list-group list-group-flush">';
                        while ($rows = mysqli_fetch_assoc($run)) {
                            $d_name = htmlspecialchars($rows['d_name']);
                            $d_id = $rows['d_id'];

                            echo '
                            <li class="list-group-item d-flex justify-content-between align-items-center px-3 py-2 border-0 border-bottom mb-2">
                                <div class="d-flex align-items-center">
                                    <span class="badge bg-info me-2 rounded-pill">#' . $c . '</span>
                                    <span class="fw-semibold text-dark">' . $d_name . '</span>
                                </div>
                                <div class="d-flex align-items-center">';
                            
                            if ($rows['d_name'] != 'Designation') {
                                echo "
                                    <a href='departments.php?edit_id={$d_id}' 
                                        class='btn btn-sm btn-outline-success rounded-circle me-2' title='Edit'>
                                        <i class='fas fa-pencil-alt'></i>
                                    </a>
                                    <a href='departments.php?del_id={$d_id}' 
                                        class='btn btn-sm btn-outline-danger rounded-circle' title='Delete'>
                                        <i class='fas fa-trash'></i>
                                    </a>
                                ";
                            }

                            echo '
                                </div>
                            </li>';
                            $c++;
                        }
                        echo '</ul>';
                    } else {
                        echo '<div class="alert alert-info text-center mb-0">No designations found.</div>';
                    }
                    ?>
                </div>
            </div>

            <?php } ?>
        </div>

        <?php include('./include/footer.php'); ?>
    </div>
</div>



<?php
    if(isset($_POST['new_designation'])){
        $d_name = mysqli_real_escape_string($con, strip_tags($_POST['d_name']));

        $sql = "SELECT * FROM `designation` WHERE `d_by`='$_SESSION[uid]' AND `d_name`='$d_name'";
        $run = mysqli_query($con, $sql);
        // $rows = mysqli_fetch_assoc($run);
        $num = mysqli_num_rows($run);

        if($num <= 0){
            $ins_sql = "INSERT INTO designation (d_name, d_by) VALUES ('$d_name', '$_SESSION[uid]')";

            if(mysqli_query($con, $ins_sql)){
                ?>
<script>
window.location = 'departments.php';
</script>
<?php
            }
            else{
                ?>
<script>
alert('OOPS !!!!');
setTimeout(() => {
    window.location = 'departments.php';
}, 1200);
</script>
<?php
            }
        }else{
            ?>
<script>
alert('This state already exist.');
setTimeout(() => {
    window.location = 'departments.php';
}, 1200);
</script>
<?php
        }
    }
    if ( isset($_GET["del_id"]) ) {

        $del_sql = "DELETE FROM designation WHERE d_id = '$_GET[del_id]'";

        if ( mysqli_query($con, $del_sql) ) {
            ?>
<script>
window.location = "departments.php";
</script>
<?php
        } else {
            ?>
<script>
alert('OOPS !!!!');
setTimeout(() => {
    window.location = 'departments.php';
}, 500);
</script>
<?php
        }
        
    }
    if(isset($_POST['edit_cat'])){
        $d_name = mysqli_real_escape_string($con, strip_tags($_POST['d_name']));
        $up_sql = "UPDATE designation SET d_name = '$d_name' WHERE d_id = '$_GET[edit_id]'";

        if(mysqli_query($con, $up_sql)){
            ?>
<script>
window.location = 'departments.php';
</script>
<?php
        }
        else{
            ?>
<script>
alert('OOPS !!!!');
setTimeout(() => {
    window.location = 'departments.php?edit_id=<?php echo $_GET["edit_id"]; ?>';
}, 500);
</script>
<?php
        }
    }
?>


<?php include('./include/js.php'); ?>