<?php include('./include/header.php'); ?>
<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>
    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>

        <div class="container-fluid p-4" id="body-content">
            <?php 
            if (!function_exists('getMonthName')) {
                function getMonthName($num) {
                    $months = [1=>"January",2=>"February",3=>"March",4=>"April",5=>"May",6=>"June",
                        7=>"July",8=>"August",9=>"September",10=>"October",11=>"November",12=>"December"];
                    return $months[intval($num)] ?? "Unknown";
                }
            }

            if (isset($_GET["employee_id"])) {
                $url = "employee-salary.php?employee_id=" . $_GET["employee_id"];
                $find_sql = mysqli_query($con, "SELECT * FROM users WHERE uid = '$_GET[employee_id]'");
                $find_row = mysqli_fetch_assoc($find_sql);
                $months = [
                    1=>"January",2=>"February",3=>"March",4=>"April",5=>"May",6=>"June",
                    7=>"July",8=>"August",9=>"September",10=>"October",11=>"November",12=>"December"
                ];

                // --- EDIT ---
                if (isset($_GET["edit_id"])) {
                    $sql = mysqli_query($con, "SELECT * FROM employee_salary WHERE emp_salary_id = '$_GET[edit_id]'");
                    if ($row = mysqli_fetch_assoc($sql)) {
                        $monthNumber = $row["salary_month"];
                        $monthName = getMonthName($monthNumber);
            ?>
            <!-- EDIT SALARY FORM -->
            <div class="card shadow-sm p-3 mb-4">
                <h3 class="text-center">Edit Salary: <?php echo htmlspecialchars($find_row["uname"]); ?></h3>
                <form method="post" enctype="multipart/form-data">
                    <div class="row">
                        <div class="col-md-6 mb-1">
                            <label>Select Month:</label>
                            <select name="salary_month" class="form-control">
                                <option value="<?php echo $row["salary_month"]; ?>"><?php echo $monthName; ?></option>
                                <?php foreach ($months as $num=>$name) echo "<option value='{$num}'>{$name}</option>"; ?>
                            </select>
                        </div>
                        <div class="col-md-6 mb-1">
                            <label>Select Year:</label>
                            <select name="salary_year" class="form-control" id="year2">
                                <option value="<?php echo $row["salary_year"]; ?>"><?php echo $row["salary_year"]; ?>
                                </option>
                            </select>
                        </div>
                        <div class="col-md-6 mb-1">
                            <label>Basic Salary</label>
                            <input type="text" class="form-control form-control-sm" name="slary_basic"
                                value="<?php echo $row["salary_basic"]; ?>" required>
                        </div>
                        <div class="col-md-6 mb-1">
                            <label>Incentive Salary</label>
                            <input type="text" class="form-control form-control-sm" name="salary_insentive"
                                value="<?php echo $row["salary_insentive"]; ?>" required>
                        </div>
                        <div class="col-md-6 mb-1">
                            <label>Other Incentive Title</label>
                            <input type="text" class="form-control form-control-sm" name="other_insentive_title"
                                value="<?php echo $row["other_insentive_title"]; ?>" required>
                        </div>
                        <div class="col-md-6 mb-1">
                            <label>Other Incentive Amount</label>
                            <input type="text" class="form-control form-control-sm" name="other_insentive_amount"
                                value="<?php echo $row["other_insentive_amount"]; ?>" required>
                        </div>
                        <div class="col-md-6 mb-1">
                            <label>Deduction Title</label>
                            <input type="text" class="form-control form-control-sm" name="deductions_title"
                                value="<?php echo $row["deductions_title"]; ?>" required>
                        </div>
                        <div class="col-md-6 mb-1">
                            <label>Deduction Amount</label>
                            <input type="text" class="form-control form-control-sm" name="deductions_amount"
                                value="<?php echo $row["deductions_amount"]; ?>" required>
                        </div>
                        <div class="col-md-6 mb-1">
                            <label>Salary Mode</label>
                            <select name="salary_mode" class="form-select form-control">
                                <option value="<?php echo $row["salary_mode"]; ?>" selected>
                                    <?php echo $row["salary_mode"]; ?></option>
                                <option value="Cash">Cash</option>
                                <option value="G-pay">G-pay</option>
                                <option value="PhonePay">PhonePay</option>
                                <option value="Paytm">Paytm</option>
                                <option value="Bank">Bank</option>
                            </select>
                        </div>
                        <div class="col-md-6 mb-1">
                            <label>Salary Transfer ID</label>
                            <input type="text" class="form-control form-control-sm" name="salary_transfar_id"
                                value="<?php echo $row["salary_transfar_id"]; ?>">
                        </div>
                        <div class="col-sm-12 mb-1">
                            <label>Enter Salary Details:</label>
                            <textarea class="form-control ckeditor" name="content"
                                style="min-height:100px;"><?php echo $row["salary_des"]; ?></textarea>
                        </div>
                        <div class="mt-3">
                            <button type="submit" class="btn btn-primary my-2 btn-sm" name="edit_salary">
                                <i class="fa fa-edit"></i> Update Salary
                            </button>
                            <a href="<?php echo $url; ?>" class="btn btn-warning m-2 btn-sm">
                                <i class="fa fa-ban"></i> Cancel
                            </a>
                        </div>
                    </div>
                </form>
            </div>
            <?php 
                    } 
                } else { 
            ?>
            <!-- ADD SALARY -->
            <div class="card shadow-sm p-3 mb-4">
                <h5>Salary for <?php echo htmlspecialchars($find_row["uname"]); ?></h5>
                <form method="post" enctype="multipart/form-data">
                    <h6 class="badge bg-secondary mb-2" data-bs-toggle="collapse" data-bs-target="#salaryForm"
                        style="cursor:pointer;">
                        <i class="fa-solid fa-hand-pointer"></i> Add Salary Details
                    </h6>

                    <div class="collapse" id="salaryForm">
                        <div class="row g-3">
                            <div class="col-md-4">
                                <label>Select Month</label>
                                <select name="salary_month" class="form-select" required>
                                    <?php foreach ($months as $num=>$name) echo "<option value='{$num}'>{$name}</option>"; ?>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label>Select Year</label>
                                <select name="salary_year" id="year" class="form-select" required></select>
                            </div>
                            <div class="col-md-4">
                                <label>Basic Salary</label>
                                <input type="text" class="form-control" name="slary_basic" required>
                            </div>
                            <div class="col-md-4">
                                <label>Incentive Salary</label>
                                <input type="text" class="form-control" name="salary_insentive" required>
                            </div>
                            <div class="col-md-6">
                                <label>Other Incentive Title</label>
                                <input type="text" class="form-control" name="other_insentive_title" required>
                            </div>
                            <div class="col-md-6">
                                <label>Other Incentive Amount</label>
                                <input type="text" class="form-control" name="other_insentive_amount" required>
                            </div>
                            <div class="col-md-6">
                                <label>Deduction Title</label>
                                <input type="text" class="form-control" name="deductions_title" required>
                            </div>
                            <div class="col-md-6">
                                <label>Deduction Amount</label>
                                <input type="text" class="form-control" name="deductions_amount" required>
                            </div>
                            <div class="col-md-6">
                                <label>Salary Mode</label>
                                <select name="salary_mode" class="form-select" required>
                                    <option value="">Select Payment Mode</option>
                                    <option value="Cash">Cash</option>
                                    <option value="G-pay">G-Pay</option>
                                    <option value="PhonePay">PhonePe</option>
                                    <option value="Paytm">Paytm</option>
                                    <option value="Bank">Bank</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label>Salary Transfer ID</label>
                                <input type="text" class="form-control" name="salary_transfar_id">
                            </div>
                            <div class="col-12">
                                <label>Salary Details</label>
                                <textarea class="form-control ckeditor" name="content"
                                    style="min-height:100px;"></textarea>
                            </div>
                        </div>

                        <div class="mt-4">
                            <button type="submit" name="add_salary" class="btn btn-primary btn-sm">
                                <i class="fa fa-plus"></i> Add Salary
                            </button>
                            <button type="button" class="btn btn-warning btn-sm" id="cancelSalaryForm">
                                <i class="fa fa-ban"></i> Cancel
                            </button>
                        </div>
                    </div>
                </form>
                <div>
                    <a href="employees.php" class="btn btn-warning btn-sm my-2"><i class="fa fa-ban"></i> Cancel</a>
                </div>
            </div>

            <!-- SALARY TABLE -->
            <div class="card shadow-sm p-3 mb-4">
                <div class="table-responsive">
                    <table id="salaryTable" class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Year/Month</th>
                                <th>Basic</th>
                                <th>Incentive</th>
                                <th>Other Incentive</th>
                                <th>Deductions</th>
                                <th>Total</th>
                                <th>Mode</th>
                                <th>Payment Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $y_sql = mysqli_query($con, "SELECT DISTINCT salary_year FROM employee_salary WHERE salary_for = '$_GET[employee_id]' ORDER BY emp_salary_id DESC");
                            $a = 1;
                            while ($y_row = mysqli_fetch_assoc($y_sql)) {
                                $sql = mysqli_query($con, "SELECT * FROM employee_salary WHERE salary_for = '$_GET[employee_id]' AND salary_year = '$y_row[salary_year]' ORDER BY emp_salary_id DESC");
                                while ($row = mysqli_fetch_assoc($sql)) {
                                    $monthName = getMonthName($row["salary_month"]);
                            ?>
                            <tr>
                                <td><?php echo $a++; ?></td>
                                <td><?php echo $y_row["salary_year"]; ?> - <?php echo $monthName; ?></td>
                                <td><?php echo $row["salary_basic"]; ?></td>
                                <td><?php echo $row["salary_insentive"]; ?></td>
                                <td><?php echo $row["other_insentive_title"]." : ".$row["other_insentive_amount"]; ?>
                                </td>
                                <td><?php echo $row["deductions_title"]." : ".$row["deductions_amount"]; ?></td>
                                <td><?php echo $row["salary_total"]; ?></td>
                                <td><?php echo $row["salary_mode"]; ?></td>
                                <td><?php echo $row["salary_up_date"]; ?></td>
                                <td>
                                    <a href="<?php echo $url;?>&edit_id=<?php echo $row["emp_salary_id"];?>"
                                        class="btn btn-success btn-sm" title="Click to Edit">
                                        <i class="fa fa-pencil-square" aria-hidden="true" style="font-size:17px;"></i>
                                    </a>
                                    <a href="<?php echo $url;?>&del_id=<?php echo $row["emp_salary_id"];?>"
                                        class="delete btn btn-danger btn-sm" title="Click to Delete">
                                        <i class="fa fa-trash" aria-hidden="true" style="font-size:19px;"></i>
                                    </a>
                                    <button class="btn btn-primary btn-sm print-btn"
                                        data-id="<?php echo $row["emp_salary_id"]; ?>">Print Slip</button>
                                </td>
                            </tr>
                            <?php } } ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php } } ?>
        </div>

        <?php include('./include/footer.php'); ?>
    </div>
</div>

<!--  SALARY PRINT MODAL  -->
<div class="modal fade" id="printModal" tabindex="-1" aria-labelledby="printModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content" id="printArea">
            <div class="modal-header">
                <h5 class="modal-title" id="printModalLabel">Salary Slip</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="printContent">
                <div class="text-center text-muted my-4">Loading...</div>
            </div>
            <div class="modal-footer d-print-none">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><i class="fa fa-times"></i>
                    Close</button>
                <button type="button" class="btn btn-primary" id="printBtn"><i class="fa fa-print"></i> Print</button>
            </div>
        </div>
    </div>
</div>

<!-- SCRIPT ORDER -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css">
<script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.8/js/dataTables.bootstrap5.min.js"></script>
<script src="../assets/vendor/ckeditor.js"></script>

<script>
CKEDITOR.replace('content', {
    height: 300,
    filebrowserUploadUrl: "./ajax/ckEditorFileUpload.php"
});
document.addEventListener("DOMContentLoaded", function() {
    if ($.fn.DataTable && $('#salaryTable').length) {
        $('#salaryTable').DataTable({
            responsive: true,
            pageLength: 10
        });
    }

    const yearSelect = document.getElementById("year");
    if (yearSelect) {
        const currentYear = new Date().getFullYear();
        for (let y = currentYear; y >= currentYear - 10; y--) {
            const opt = document.createElement("option");
            opt.value = y;
            opt.textContent = y;
            yearSelect.appendChild(opt);
        }
    }

    // Handle Print Slip Button
    $(document).on('click', '.print-btn', function() {
        const salaryId = $(this).data('id');
        $('#printContent').html('<div class="text-center text-muted my-4">Loading...</div>');
        const modal = new bootstrap.Modal(document.getElementById('printModal'));
        modal.show();

        $.get('./ajax/get-salary-slip.php', {
            id: salaryId
        }, function(data) {
            $('#printContent').html(data);
        }).fail(function() {
            $('#printContent').html(
                '<p class="text-danger text-center">Unable to load slip.</p>');
        });
    });

    // Print Button Action
    $('#printBtn').on('click', function() {
        const printContents = document.getElementById('printArea').innerHTML;
        const originalContents = document.body.innerHTML;
        document.body.innerHTML = printContents;
        window.print();
        document.body.innerHTML = originalContents;
        location.reload();
    });
});
document.getElementById('cancelSalaryForm').addEventListener('click', function() {
    const collapseElement = document.getElementById('salaryForm');
    const bsCollapse = bootstrap.Collapse.getOrCreateInstance(collapseElement);
    bsCollapse.hide(); // Explicitly close the collapse
});
</script>

<style>
@media print {
    body * {
        visibility: hidden;
    }

    #printArea,
    #printArea * {
        visibility: visible;
    }

    #printArea {
        position: absolute;
        left: 0;
        top: 0;
        width: 100%;
    }
}
</style>

<?php include('./include/js.php'); ?>




<?php
date_default_timezone_set('Asia/Kolkata');
$currentTime = date('M j, Y g:i a');

if(isset($_POST['add_salary'])){
$salary_month = mysqli_real_escape_string($con,strip_tags($_POST['salary_month']));
$salary_year = mysqli_real_escape_string($con,strip_tags($_POST['salary_year']));
// $salary_amount = mysqli_real_escape_string($con,strip_tags($_POST['slary_amount']));
$salary_basic = mysqli_real_escape_string($con,strip_tags($_POST['slary_basic']));
$salary_insentive = mysqli_real_escape_string($con,strip_tags($_POST['salary_insentive']));
$other_insentive_title = mysqli_real_escape_string($con,strip_tags($_POST['other_insentive_title']));
$other_insentive_amount = mysqli_real_escape_string($con,strip_tags($_POST['other_insentive_amount']));
$deductions_title = mysqli_real_escape_string($con,strip_tags($_POST['deductions_title']));
$deductions_amount = mysqli_real_escape_string($con,strip_tags($_POST['deductions_amount']));
$salary_mode = mysqli_real_escape_string($con,strip_tags($_POST['salary_mode']));
$salary_transfar_id = mysqli_real_escape_string($con,strip_tags($_POST['salary_transfar_id']));
$salary_transfar_id = mysqli_real_escape_string($con,
strip_tags($_POST['salary_transfar_id']));
$salary_des = $_POST['content'];

$salary_total = $salary_insentive + $salary_basic + $other_insentive_amount - $deductions_amount ;


$ins_sql =
"INSERT INTO `employee_salary` (salary_for, salary_month, salary_year, salary_basic, salary_insentive, salary_total, salary_des, salary_mode, salary_transfar_id, salary_up_date, deductions_amount, deductions_title, other_insentive_amount, other_insentive_title) VALUES ('$_GET[employee_id]', '$salary_month', '$salary_year', '$salary_basic', '$salary_insentive', '$salary_total', '$salary_des', '$salary_mode', '$salary_transfar_id', '$currentTime', '$deductions_amount', '$deductions_title', '$other_insentive_amount', '$other_insentive_title' )";

if(mysqli_query($con, $ins_sql)){
?>
<script>
window.location = '<?php echo $url;?>';
</script>
<?php
} else {
?>
<script>
alert('OOPS !!!!');
setTimeout(() => {
    window.location = '<?php echo $url;?>';
}, 1200);
</script>
<?php
}
}
?>

<?php
if(isset($_POST['edit_salary'])){
$salary_month = mysqli_real_escape_string($con,strip_tags($_POST['salary_month']));
$salary_year = mysqli_real_escape_string($con,strip_tags($_POST['salary_year']));
// $salary_amount = mysqli_real_escape_string($con,strip_tags($_POST['slary_amount']));
$salary_basic = mysqli_real_escape_string($con,strip_tags($_POST['slary_basic']));
$salary_insentive = mysqli_real_escape_string($con,strip_tags($_POST['salary_insentive']));
$other_insentive_title = mysqli_real_escape_string($con,strip_tags($_POST['other_insentive_title']));
$other_insentive_amount = mysqli_real_escape_string($con,strip_tags($_POST['other_insentive_amount']));
$deductions_title = mysqli_real_escape_string($con,strip_tags($_POST['deductions_title']));
$deductions_amount = mysqli_real_escape_string($con,strip_tags($_POST['deductions_amount']));
$salary_mode = mysqli_real_escape_string($con,strip_tags($_POST['salary_mode']));
$salary_transfar_id = mysqli_real_escape_string($con,strip_tags($_POST['salary_transfar_id']));
// $salary_total = mysqli_real_escape_string($con,strip_tags($_POST['salary_total']));
$salary_transfar_id = mysqli_real_escape_string($con,strip_tags($_POST['salary_transfar_id']));
$salary_des = $_POST['content'];

$salary_total = $salary_insentive + $salary_basic + $other_insentive_amount - $deductions_amount ;

if(isset($_GET['employee_id'])){
$update_sql = "UPDATE `employee_salary`
SET
`salary_month` = '$salary_month',
`salary_year` = '$salary_year',
`other_insentive_title` = '$other_insentive_title',
`other_insentive_amount` = '$other_insentive_amount',
`deductions_title` = '$deductions_title',
`deductions_amount` = '$deductions_amount',
`salary_basic` = '$salary_basic',
`salary_insentive` = '$salary_insentive',
`salary_total` = '$salary_total',
`salary_des` = '$salary_des',
`salary_mode` = '$salary_mode',
`salary_transfar_id` = '$salary_transfar_id',
`salary_edit_date` = '$currentTime'
WHERE
`emp_salary_id` = $_GET[edit_id]";

if(mysqli_query($con, $update_sql)){
?>
<script>
window.location = '<?php echo $url;?>';
</script>
<?php
} else {
?>
<script>
alert('Update failed! Please try again.');
window.location = '<?php echo $url;?>';
</script>
<?php
}
}
}
?>

<?php
if ( isset($_GET["del_id"]) ) {
$delete_id = $_GET["del_id"];

$delete_sql = "DELETE FROM employee_salary WHERE emp_salary_id = '$delete_id'";

if (mysqli_query($con, $delete_sql)) {
?>
<script>
window.location = "<?php echo $url;?>";
</script>
<?php
} else {
?>
<script>
alert('OOPS !!!!');
setTimeout(() => {
    window.location = '<?php echo $url;?>';
}, 1200);
</script>
<?php
}

}
?>

<?php
function getMonthName($monthNumber) {
$months = [
1 => "January",
2 => "February",
3 => "March",
4 => "April",
5 => "May",
6 => "June",
7 => "July",
8 => "August",
9 => "September",
10 => "October",
11 => "November",
12 => "December"
];

if (array_key_exists($monthNumber, $months)) {
return $months[$monthNumber];
} else {
return "Invalid Month";
}
}
?>



<?php

// Script For convering numbers in to words 


function getIndianCurrency(float $number)
{
    $decimal = round($number - ($no = floor($number)), 2) * 100;
    $hundred = null;
    $digits_length = strlen($no);
    $i = 0;
    $str = array();
    $words = array(0 => '', 1 => 'One', 2 => 'Two',
        3 => 'Three', 4 => 'Four', 5 => 'Five', 6 => 'Six',
        7 => 'Seven', 8 => 'Eight', 9 => 'Nine',
        10 => 'Ten', 11 => 'Eleven', 12 => 'Twelve',
        13 => 'Thirteen', 14 => 'Fourteen', 15 => 'Fifteen',
        16 => 'Sixteen', 17 => 'Seventeen', 18 => 'Eighteen',
        19 => 'Nineteen', 20 => 'Twenty', 30 => 'Thirty',
        40 => 'Forty', 50 => 'Fifty', 60 => 'Sixty',
        70 => 'Seventy', 80 => 'Eighty', 90 => 'Ninety');
    $digits = array('', 'Hundred','Thousand','Lakh', 'Crore');
    while( $i < $digits_length ) {
        $divider = ($i == 2) ? 10 : 100;
        $number = floor($no % $divider);
        $no = floor($no / $divider);
        $i += $divider == 10 ? 1 : 2;
        if ($number) {
            $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
            $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
            $str [] = ($number < 21) ? $words[$number].' '. $digits[$counter]. $plural.' '.$hundred:$words[floor($number / 10) * 10].' '.$words[$number % 10]. ' '.$digits[$counter].$plural.' '.$hundred;
        } else $str[] = null;
    }
    $Rupees = implode('', array_reverse($str));
    $paise = ($decimal > 0) ? "." . ($words[$decimal / 10] . " " . $words[$decimal % 10]) . ' Paise' : '';
    return ($Rupees ? $Rupees . 'Rupees ' : '') . $paise;
}
?>