<?php include('./include/header.php'); ?>
<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>
    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>
        <style>
        #map {
            height: 500px;
            border-radius: 8px;
        }

        .info-box {
            padding: 10px;
            border: 1px solid #eee;
            border-radius: 6px;
            margin-bottom: 10px;
        }
        </style>

        <?php
            $uid = $_SESSION['uid'];
            $user = $con->query("SELECT * FROM users WHERE uid = '$uid'")->fetch_assoc();

            if (!isset($_GET['employee_id'])) { echo "employee_id required"; exit; }
            $emp_id = (int)$_GET['employee_id'];
            $employee_sql = mysqli_query($con, "SELECT * from users WHERE uid = '{$_GET["employee_id"]}' ");
            $employee_row = mysqli_fetch_assoc($employee_sql);
            $employee_name = $employee_row["uname"];
            ?>

        <div class="container-fluid p-4" id="body-content">
            <h4>Track Employee #<?= $employee_name; ?></h4>

            <div class="row mb-2">
                <div class="col-md-3">
                    <input type="date" id="date_from" class="form-control form-control-sm" value="<?= date('Y-m-d') ?>">
                </div>
                <div class="col-md-3">
                    <input type="date" id="date_to" class="form-control form-control-sm" value="<?= date('Y-m-d') ?>">
                </div>
                <div class="col-md-6">
                    <button id="loadBtn" class="btn btn-primary btn-sm">Load</button>
                    <button id="liveBtn" class="btn btn-success d-none">Live</button>
                    <button id="stopLiveBtn" class="btn btn-danger d-none">Stop Live</button>
                </div>
            </div>

            <div class="info-box">
                Distance: <strong><span id="totalDistance">0</span> m</strong> |
                Avg Speed: <strong><span id="avgSpeed">0</span> m/s</strong> |
                Stops: <strong><span id="stopCount">0</span></strong>
            </div>

            <div id="map" class="mb-5"></div>
        </div>

        <script>
        const empId = <?= $emp_id ?>;

        let map = L.map('map').setView(
            [<?= $user['latitude'];?>, <?= $user['longitude'];?>],
            13
        );

        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '© OpenStreetMap'
        }).addTo(map);

        /* ================= MAP LAYERS ================= */

        let routeLine = L.polyline([], {
            color: 'blue'
        }).addTo(map);
        let movingMarker = L.circleMarker([0, 0], {
            radius: 6,
            color: 'green',
            fillOpacity: 1
        }).addTo(map);

        let stopMarkers = [];

        /* ================= HELPERS ================= */

        function haversine(lat1, lon1, lat2, lon2) {
            const R = 6371000;
            const dLat = (lat2 - lat1) * Math.PI / 180;
            const dLon = (lon2 - lon1) * Math.PI / 180;
            const a =
                Math.sin(dLat / 2) ** 2 +
                Math.cos(lat1 * Math.PI / 180) *
                Math.cos(lat2 * Math.PI / 180) *
                Math.sin(dLon / 2) ** 2;
            return R * 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
        }

        /* ================= LOAD & PROCESS ================= */

        async function loadData() {

            const from = date_from.value;
            const to = date_to.value;

            const res = await fetch(
                `get_track.php?employee_id=${empId}&from=${from}&to=${to}`
            );
            const data = await res.json();

            if (!data.length) {
                alert("No tracking data");
                return;
            }

            routeLine.setLatLngs([]);
            stopMarkers.forEach(m => map.removeLayer(m));
            stopMarkers = [];

            let totalDist = 0;
            let speedSum = 0;

            let stopStart = null;
            let stopLatLng = null;

            data.forEach((p, i) => {

                const latlng = [+p.latitude, +p.longitude];
                routeLine.addLatLng(latlng);

                if (i > 0) {
                    const prev = data[i - 1];
                    const d = haversine(
                        prev.latitude, prev.longitude,
                        p.latitude, p.longitude
                    );

                    totalDist += d;

                    /* STOP DETECTION (≤ 20m) */
                    if (d <= 10) {
                        if (!stopStart) {
                            stopStart = prev.ts;
                            stopLatLng = latlng;
                        }
                    } else {
                        if (stopStart) {
                            createStopMarker(stopLatLng, stopStart, prev.ts);
                            stopStart = null;
                        }
                    }
                }

                speedSum += parseFloat(p.speed);
            });

            /* Close last stop */
            if (stopStart) {
                createStopMarker(
                    stopLatLng,
                    stopStart,
                    data[data.length - 1].ts
                );
            }

            map.fitBounds(routeLine.getBounds());

            totalDistance.innerText = totalDist.toFixed(0);
            avgSpeed.innerText = (speedSum / data.length).toFixed(2);
            stopCount.innerText = stopMarkers.length;

            autoplayRoute(data);
        }

        /* ================= STOP MARKER ================= */

        function createStopMarker(latlng, start, end) {

            const duration = Math.max(0, end - start);

            const marker = L.circle(latlng, {
                radius: 10,
                color: 'red',
                fillOpacity: 0.4
            }).addTo(map);

            marker.bindPopup(`
                <b>STOP</b><br>
                Duration: ${(duration/60).toFixed(1)} min
            `);

            stopMarkers.push(marker);
        }

        /* ================= AUTO PLAY ================= */

        function autoplayRoute(data) {

            let i = 0;

            const play = setInterval(() => {

                if (i >= data.length) {
                    clearInterval(play);
                    return;
                }

                const p = data[i];
                const latlng = [+p.latitude, +p.longitude];
                movingMarker.setLatLng(latlng);

                i++;
            }, 700); // playback speed
        }

        /* ================= EVENTS ================= */

        loadBtn.onclick = loadData;
        </script>


        <?php include('./include/footer.php'); ?>
    </div>
</div>
<?php include('./include/js.php'); ?>