<?php include('./include/header.php'); ?>
<style>
#imageDisplay {
    max-width: 100%;
    overflow: hidden;
}

#imageDisplay img {
    width: 100%;
    height: auto;
}

.accordion {
    background: linear-gradient(to bottom right, #FFF, #f7f7f7);
    background: #0097a7;
    margin: 0 auto;
    border-radius: 3px;
    box-shadow: 0 10px 15px -20px rgba(0, 0, 0, 0.3), 0 30px 45px -30px rgba(0, 0, 0, 0.3), 0 80px 55px -30px rgba(0, 0, 0, 0.1);
}

.heading {
    color: #FFF;
    font-size: 14px;
    border-bottom: 1px solid #e7e7e7;
    letter-spacing: 0.8px;
    padding: 5px;
    cursor: pointer;
}

.heading:nth-last-child(2) {
    border-bottom: 0;
}

.heading:hover {
    background: #00838f;
    border-radius: 0;
}

.heading:first-child:hover {
    border-radius: 3px 3px 0 0;
}

.heading:nth-last-child(2):hover {
    border-radius: 0 0 3px 3px;
}

.heading::before {
    margin-right: 5px;
    content: '';
    vertical-align: middle;
    display: inline-block;
    border-top: 7px solid #f5f5f5;
    border-left: 7px solid transparent;
    border-right: 7px solid transparent;
    float: right;
    transform: rotate(0);
    transition: all 0.5s;
    margin-top: 13px;
}

.active.heading::before {
    transform: rotate(-180deg);
}

.not-active.heading::before {
    transform: rotate(0deg);
}

.contents {
    display: none;
    background: #FFFAFA;
    padding: 15px;
    color: #7f8fa4;
    font-size: 13px;
    line-height: 1.5;
}

h1 {
    font-size: 40px;
    color: #000;
    font-weight: normal;
    text-align: center;
    margin: 50px 0;
}

.custom-modal {
    display: none;
    position: fixed;
    z-index: 9999;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    overflow: auto;
    background-color: rgba(0, 0, 0, 0.5);
}

/* Modal Content Box */
.custom-modal-content {
    background-color: #fff;
    margin: 10% auto;
    padding: 20px;
    width: 90%;
    max-width: 500px;
    border-radius: 8px;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
}

/* Header */
.custom-modal-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

/* Close Button */
.custom-modal-close {
    font-size: 24px;
    font-weight: bold;
    cursor: pointer;
}

/* Footer */
.custom-modal-footer {
    display: flex;
    justify-content: flex-end;
    gap: 10px;
    margin-top: 20px;
}

/* Admin remark box */
.remark-box {
    background: #f5f5f5;
    padding: 10px;
    border-radius: 4px;
}

/* Basic Button Styling */
.btn-success {
    background-color: #28a745;
    color: white;
}

.btn-secondary {
    background-color: #6c757d;
    color: white;
}

.btn-primary {
    background-color: #007bff;
    color: white;
}

.active {
    display: block;
}
</style>
<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>
    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>

        <div class="container-fluid p-4" id="body-content">
            <div id="notification"
                style="display: none; position: fixed; top: 20px; right: 20px; background: #28a745; color: white; padding: 10px 20px; border-radius: 5px; box-shadow: 0 0 10px rgba(0,0,0,0.2); z-index: 9999;">
            </div>

            <?php if(isset($_GET["employee_id"])){
                $url= "employee-work.php?employee_id=".$_GET["employee_id"];
                $find_sql = mysqli_query($con, "SELECT * FROM users WHERE uid = '$_GET[employee_id]'");
                $find_row = mysqli_fetch_assoc($find_sql);
                ?>
            <?php
                if(isset($_GET["edit_id"])){
                    $sql = mysqli_query($con, "SELECT * FROM work_schedule WHERE ws_id = '$_GET[edit_id]'");
                    if($row = mysqli_fetch_assoc($sql)) {
                    ?>
            <div class="card shadow-sm p-3 mb-4">
                <h3 class="text-center">Edit Work Schedule For <?php echo
                    $find_row["uname"];?></h3>
                <form class="user" method="post" enctype="multipart/form-data">
                    <div style>
                        <div class="form-group row">
                            <div class="col-md-6 mb-1 mb-sm-0">
                                <label for="doc_name">Edit Schedule Date:</label>
                                <input type="date" class="form-control form-control-sm mb-2" name="ws_date"
                                    value="<?php echo $row["ws_date"];?>" required>
                            </div>
                            <div class="col-md-3 mb-1 mb-sm-0">
                                <label for="doc_name">Edit Schedule Start Time:</label>
                                <input type="time" class="form-control form-control-sm mb-2" name="ws_stime"
                                    value="<?php echo $row["ws_startTime"];?>" required>
                            </div>
                            <div class="col-md-3 mb-1 mb-sm-0">
                                <label for="doc_name">Edit Schedule End Time:</label>
                                <input type="time" class="form-control form-control-sm mb-2" name="ws_etime"
                                    value="<?php echo $row["ws_endTime"];?>" required>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary btn-sm my-2 me-2" name="edit_schedule">
                            <i class="fa fa-edit"></i> Edit Schedule
                        </button>
                        <a href="<?php echo $url;?>" class="btn btn-warning btn-sm" aria-expanded="false"> <i
                                class="fa fa-ban"></i>
                            Cancel </a>
                    </div>
                </form>
            </div>
            <?php
                }}elseif(isset($_GET["edit_wl_id"])){
                    $sql = mysqli_query($con, "SELECT * FROM work_list WHERE wl_id = '$_GET[edit_wl_id]'");
                    if($row = mysqli_fetch_assoc($sql)) {
                        $wsSql = mysqli_query($con, "SELECT * FROM work_schedule WHERE ws_id = '$row[wl_ws_id]'");
                        if($ws_row = mysqli_fetch_assoc($wsSql)){
                            $ws_date = $ws_row["ws_date"];
                            $ws_stime = $ws_row["ws_startTime"];
                            $ws_etime = $ws_row["ws_endTime"];
                        }
                    ?>
            <div class="card shadow-sm p-3 mb-4">
                <h3 class="text-center">Edit Work Details For <?php echo
                    $find_row["uname"];?></h3>
                <h5 class="text-center">Schediled At:
                    <strong><?php echo $ws_date . '( ' . $ws_stime . ' - ' . $ws_etime . ' )';?></strong>
                </h5>
                <form class="user" method="post" enctype="multipart/form-data">
                    <div class="form-group row">
                        <div class="col-md-12 mb-1 mb-sm-0">
                            <label>Enter Title:</label>
                            <input type="text" class="form-control form-control-sm mb-2" name="title"
                                value="<?php echo $row['wl_title'];?>">
                        </div>
                        <div class="col-sm-12 mb-1 mb-sm-0">
                            <label>Enter Details:</label>
                            <textarea class="form-control form-control-sm mb-2 ckeditor" id="content" name="details"
                                style="min-height:100px;"><?php echo $row['wl_des'];?></textarea>
                        </div>
                    </div>
                    <div>
                        <button type="submit" class="btn btn-primary btn-sm my-2 me-2" name="edit_wl_schedule">
                            <i class="fa fa-edit"></i> Edit Schedule
                        </button>
                        <a href="<?php echo $url;?>" class="btn btn-warning btn-sm" aria-expanded="false"> <i
                                class="fa fa-ban"></i>
                            Cancel </a>
                    </div>
                </form>
            </div>
            <?php
                }}else{
                ?>
            <div class="card shadow-sm p-3 mb-4">
                <h5 class="">Work List For <?php echo
                    $find_row["uname"];?></h5>
                <form class="user" method="post" enctype="multipart/form-data">
                    <h4 class="mb-2 badge bg-secondary collapsed" data-bs-toggle="collapse" data-bs-target="#target"
                        style="cursor:pointer;" aria-expanded="false">
                        Assign New Work
                    </h4>
                    <p class="small">
                        <i class="fa fa-hand-point-up"></i> Tap Here to add new work
                    </p>

                    <div class="collapse card p-3" id="target">
                        <div class="card p-3 mb-2">
                            <div class="row">
                                <div class="col-md-6 mb-2">
                                    <label for="workDate">Select Date</label>
                                    <input type="date" class="form-control from-control-sm" name="workDate">
                                </div>
                                <div class="col-md-3 mb-2">
                                    <label for="startTime">Select Start Time</label>
                                    <input type="time" class="form-control from-control-sm" name="startTime">
                                </div>
                                <div class="col-md-3 mb-2">
                                    <label for="endTime">Select End Time</label>
                                    <input type="time" class="form-control from-control-sm" name="endTime">
                                </div>
                            </div>
                        </div>

                        <!-- Task container -->
                        <div id="taskContainer">
                            <!-- First task block -->
                            <div class="card p-3 task-item mb-2" data-index="0">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <span class="badge badge-success">Task 1</span>
                                    <button type="button" class="btn btn-danger btn-sm delete-task"
                                        style="display:none;">Delete</button>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 mb-1 mb-sm-0">
                                        <label>Enter Title:</label>
                                        <input type="text" class="form-control form-control-sm mb-2"
                                            placeholder="Enter Title *" name="task[0][title]" required>
                                    </div>
                                    <div class="col-sm-12 mb-1 mb-sm-0">
                                        <label>Enter Details:</label>
                                        <textarea class="form-control form-control-sm mb-2 ckeditor"
                                            placeholder="Enter work details" name="task[0][details]"
                                            style="min-height:100px;"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="mt-2 d-flex justify-content-end">
                            <div class="btn btn-sm btn-primary add-task-btn"><i class="fa fa-plus"></i> Add New Task
                                Fields
                            </div>
                        </div>

                        <div class="">
                            <button type="submit" class="btn btn-primary btn-sm my-2" name="new_work">
                                <i class="fa fa-bell"></i> Add New Work
                            </button>
                            <a href="#target" data-bs-toggle="collapse" class="btn btn-warning btn-sm m-2 collapsed"
                                aria-expanded="false">
                                <i class="fa fa-ban"></i> Cancel
                            </a>
                        </div>
                    </div>
                </form>
                <div class="">
                    <a href="employees.php" class="btn btn-warning btn-sm my-2" aria-expanded="false"> <i
                            class="fa fa-ban"></i>
                        Cancel </a>
                </div>
            </div>
            <?php
            // Collect all work_schedules
            $schedules = [];
            $pendingSchedules = [];

            $sql = mysqli_query($con, "SELECT * FROM work_schedule WHERE ws_for = '$_GET[employee_id]' ORDER BY ws_date DESC");
            if(mysqli_num_rows($sql)>0){
            ?>
            <div class="card shadow-sm p-3 mb-4">
                <div class="row">
                    <div class="col-md-12">
                        <?php
                            while ($row = mysqli_fetch_assoc($sql)) {
                                $ws_id = $row['ws_id'];
                                $date = date('Y-m-d', strtotime($row['ws_date']));
                                $wl_sql = mysqli_query($con, "SELECT * FROM work_list WHERE wl_ws_id = '$ws_id'");
                                
                                $hasPending = false;
                                while ($wl = mysqli_fetch_assoc($wl_sql)) {
                                    if ($wl['wl_status'] != 1) {
                                        $hasPending = true;
                                        break;
                                    }
                                }

                                if ($hasPending) {
                                    $pendingSchedules[] = $row;
                                }

                                $schedules[$date][] = $row;
                            }

                            // Helper to chunk dates into weekly tabs
                            $dates = array_keys($schedules);
                            rsort($dates);
                            $dates = array_slice($dates, 0, 7);
                            $weeks = array_chunk($dates, 7);
                            ?>

                        <!-- Tabs Nav -->
                        <ul class="nav nav-tabs" id="scheduleTabs" role="tablist">
                            <!-- Pending Tab -->
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="pending-tab" data-bs-toggle="tab"
                                    data-bs-target="#pending" type="button" role="tab">Pending</button>
                            </li>

                            <!-- Date Tabs -->
                            <?php foreach ($weeks as $week): ?>
                            <?php foreach ($week as $date): ?>
                            <?php
                                $tabId = 'date_' . date("Ymd", strtotime($date));
                                $label = date("d M", strtotime($date));
                            ?>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="tab-<?= $tabId ?>" data-bs-toggle="tab"
                                    data-bs-target="#<?= $tabId ?>" type="button" role="tab">
                                    <?= $label ?>
                                </button>
                            </li>
                            <?php endforeach; ?>
                            <?php endforeach; ?>

                            <!-- Calendar Tab -->
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="calendar-tab" data-bs-toggle="tab"
                                    data-bs-target="#calendar" type="button" role="tab">Calendar</button>
                            </li>
                        </ul>

                        <!-- TAB CONTENT -->
                        <div class="tab-content mt-3" id="scheduleTabContent">
                            <!-- PENDING TAB -->
                            <div class="tab-pane fade show active" id="pending" role="tabpanel"
                                aria-labelledby="pending-tab">
                                <?php
                                $sql = mysqli_query($con, "SELECT * FROM work_schedule WHERE ws_for = '{$_GET['employee_id']}' ORDER BY ws_date DESC");
                                while ($row = mysqli_fetch_assoc($sql)) {
                                    $wl_sql = mysqli_query($con, "SELECT * FROM work_list WHERE wl_ws_id = '{$row['ws_id']}'");
                                    $total = $completed = 0;
                                    while ($wl = mysqli_fetch_assoc($wl_sql)) {
                                        $total++;
                                        if ($wl['wl_status'] == 1) $completed++;
                                    }

                                    // Pending condition
                                    if ($total == 0 || $completed < $total) {
                                        include 'work_schedule_card.php';
                                    }
                                }
                                ?>
                            </div>

                            <!-- DATE TABS -->
                            <?php foreach ($weeks as $week): ?>
                            <?php foreach ($week as $date): ?>
                            <?php $tabId = 'date_' . date("Ymd", strtotime($date)); ?>
                            <div class="tab-pane fade" id="<?= $tabId ?>" role="tabpanel"
                                aria-labelledby="tab-<?= $tabId ?>">
                                <h5 class="text-primary mt-3"><?= date("l, d M Y", strtotime($date)); ?></h5>
                                <?php
                                $selectedDate = $date;
                                $sql = mysqli_query($con, "SELECT * FROM work_schedule WHERE DATE(ws_date) = '$selectedDate' AND ws_for = '{$_GET['employee_id']}' ORDER BY ws_id DESC");
                                while ($row = mysqli_fetch_assoc($sql)) {
                                    include 'work_schedule_card.php';
                                }
                                ?>
                            </div>
                            <?php endforeach; ?>
                            <?php endforeach; ?>

                            <!-- CALENDAR TAB -->
                            <div class="tab-pane fade" id="calendar" role="tabpanel" aria-labelledby="calendar-tab">
                                <input type="date" id="scheduleDatePicker" class="form-control w-25 mb-3">
                                <div id="dateScheduleContainer"></div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
            <?php }
            }
            ?>
            <?php }?>

            <!-- Remark Modal (Bootstrap 5) -->
            <div class="modal fade" id="remarkModal" tabindex="-1" aria-labelledby="remarkModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">

                        <div class="modal-header">
                            <h5 class="modal-title" id="remarkModalLabel">Submit Remark</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <div class="modal-body">
                            <p class="m-0"><strong>Employee Remark:</strong></p>
                            <p id="remarkText" class="border rounded p-2 bg-light">Loading...</p>

                            <form id="remarkForm">
                                <div class="mb-3">
                                    <label for="ws_adminRemark" class="form-label">Admin Remark:</label>
                                    <textarea class="form-control" id="ws_adminRemark" rows="4" required></textarea>
                                </div>
                                <div class="mb-3">
                                    <label for="ws_workPercent" class="form-label">Enter Work Percentage:</label>
                                    <input type="text" class="form-control" id="ws_workPercent" placeholder="e.g. 75%">
                                </div>
                                <input type="hidden" id="remark_ws_id">
                            </form>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-success" id="submitRemarkBtn">Submit</button>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <?php include('./include/footer.php'); ?>
    </div>
</div>

<script src="../assets/vendor/ckeditor.js"></script>

<script>
CKEDITOR.replace('content', {
    height: 300,
    filebrowserUploadUrl: "./ajax/ckEditorFileUpload.php"
});
</script>

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

<script>
// From calender wise data load
document.getElementById('scheduleDatePicker').addEventListener('change', function() {
    var selectedDate = this.value;

    fetch('./ajax/fetch_schedule_by_date.php?date=' + selectedDate + '&work_id=<?= $_GET['employee_id'] ?>')
        .then(res => res.text())
        .then(data => {
            document.getElementById('dateScheduleContainer').innerHTML = data;
        });
});
</script>
<script>
$(document).ready(function() {
    $(".accordion").on("click", ".heading", function() {

        $(this).toggleClass("active").next().slideToggle();

        $(".contents").not($(this).next()).slideUp(300);

        $(this).siblings().removeClass("active");
    });
});
</script>
<script>
window.addEventListener('load', function() {
    var pendingTab = document.getElementById('pending');
    if (pendingTab) {
        pendingTab.classList.add('in');
    }
});
</script>

<script>
let taskIndex = 1;

document.querySelector('.add-task-btn').addEventListener('click', function() {
    const taskContainer = document.getElementById('taskContainer');

    const newTask = document.createElement('div');
    newTask.classList.add('card', 'p-3', 'task-item', 'mb-2');
    newTask.setAttribute('data-index', taskIndex);

    const textareaId = `details_${taskIndex}`;

    newTask.innerHTML = `
            <div class="d-flex justify-content-between align-items-center mb-2">
                <span class="badge badge-success">Task ${taskIndex + 1}</span>
                <button type="button" class="btn btn-danger btn-sm delete-task">Delete</button>
            </div>
            <div class="row">
                <div class="col-md-12 mb-1 mb-sm-0">
                    <label>Enter Title:</label>
                    <input type="text" class="form-control form-control-sm mb-2" placeholder="Enter Title *" name="task[${taskIndex}][title]" required>
                </div>
                <div class="col-sm-12 mb-1 mb-sm-0">
                    <label>Enter Details:</label>
                    <textarea id="${textareaId}" class="form-control form-control-sm mb-2 ckeditor" placeholder="Enter work details" name="task[${taskIndex}][details]" style="min-height:100px;"></textarea>
                </div>
            </div>
        `;

    taskContainer.appendChild(newTask);

    // Init CKEditor ONLY for the new textarea
    if (typeof CKEDITOR !== 'undefined') {
        setTimeout(() => {
            CKEDITOR.replace(textareaId, {
                height: 100,
                filebrowserUploadUrl: "./ajax/ckEditorFileUpload.php"
            });
        }, 100); // Give time for DOM to settle
    }

    taskIndex++;
});

// Delete task and reindex
document.addEventListener('click', function(e) {
    if (e.target.classList.contains('delete-task')) {
        const taskBlock = e.target.closest('.task-item');
        const textarea = taskBlock.querySelector('textarea');

        // Destroy CKEditor before removing
        if (CKEDITOR.instances[textarea.id]) {
            CKEDITOR.instances[textarea.id].destroy(true);
        }

        taskBlock.remove();
        reindexTasks();
    }
});

function reindexTasks() {
    const tasks = document.querySelectorAll('.task-item');

    tasks.forEach((task, index) => {
        task.setAttribute('data-index', index);

        // Update badge
        const badge = task.querySelector('.badge');
        badge.textContent = `Task ${index + 1}`;

        // Update input name
        const input = task.querySelector('input');
        input.setAttribute('name', `task[${index}][title]`);

        // Update textarea name and ID
        const textarea = task.querySelector('textarea');

        // Destroy old CKEditor instance
        if (CKEDITOR.instances[textarea.id]) {
            CKEDITOR.instances[textarea.id].destroy(true);
        }

        const newId = `details_${index}`;
        textarea.setAttribute('id', newId);
        textarea.setAttribute('name', `task[${index}][details]`);

        // Re-init CKEditor for new ID
        if (typeof CKEDITOR !== 'undefined') {
            setTimeout(() => {
                CKEDITOR.replace(newId, {
                    height: 100,
                    filebrowserUploadUrl: "./ajax/ckEditorFileUpload.php"
                });
            }, 100);
        }
    });

    // Update taskIndex so next added task is correct
    taskIndex = tasks.length;
}
</script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const modalEl = document.getElementById('remarkModal');
    const submitBtn = document.getElementById('submitRemarkBtn');

    // Initialize Bootstrap modal
    const remarkModal = new bootstrap.Modal(modalEl);

    // Open modal + load remarks
    document.querySelectorAll('.openRemarkModal').forEach(btn => {
        btn.addEventListener('click', function() {
            const ws_id = this.getAttribute('data-id');
            console.log('🟢 Opening modal for ws_id:', ws_id);

            document.getElementById('remark_ws_id').value = ws_id;

            // Load existing data
            fetch('./ajax/get_admin_remark.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded'
                    },
                    body: 'ws_id=' + encodeURIComponent(ws_id)
                })
                .then(res => res.json())
                .then(data => {
                    console.log('📥 Loaded data from get_admin_remark.php:', data);
                    document.getElementById('remarkText').textContent = data.workRemark ||
                        'No employee remark.';
                    document.getElementById('ws_adminRemark').value = data.adminRemark ||
                        '';
                    document.getElementById('ws_workPercent').value = data.workPercent ||
                        '';
                    remarkModal.show(); // show the modal
                })
                .catch(err => {
                    console.error('❌ Error fetching remark:', err);
                    document.getElementById('remarkText').textContent =
                        'Error loading remark.';
                    remarkModal.show();
                });
        });
    });

    // Submit remark
    submitBtn.addEventListener('click', function() {
        const ws_id = document.getElementById('remark_ws_id').value.trim();
        const adminRemark = document.getElementById('ws_adminRemark').value.trim();
        const workPercent = document.getElementById('ws_workPercent').value.trim();

        console.log('Attempting to submit:', {
            ws_id,
            adminRemark,
            workPercent
        });

        if (!ws_id || !adminRemark) {
            console.warn('⚠️ Missing required fields!');
            showNotification('Please fill all required fields.', '#dc3545');
            return;
        }

        fetch('./ajax/submit_work_remark.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                body: `ws_id=${encodeURIComponent(ws_id)}&ws_adminRemark=${encodeURIComponent(adminRemark)}&ws_workPercent=${encodeURIComponent(workPercent)}`
            })
            .then(res => res.text())
            .then(responseText => {
                console.log('📤 Server response from submit_work_remark.php:', responseText);

                if (responseText.trim().includes('success')) {
                    showNotification('✅ Remark and progress updated.', '#28a745');
                    remarkModal.hide(); // properly hide the modal
                    document.getElementById('remarkForm').reset();
                } else {
                    showNotification('❌ Failed to update data.', '#dc3545');
                }
            })
            .catch(err => {
                console.error('💥 Fetch error:', err);
                showNotification('❌ Failed to submit remark.', '#dc3545');
            });
    });
});
</script>
<!-- Notification Script -->
<script>
function showNotification(message, color = '#28a745') {
    const notification = document.getElementById('notification');
    notification.innerText = message;
    notification.style.background = color;
    notification.style.display = 'block';
    setTimeout(() => {
        notification.style.display = 'none';
        if (color === '#28a745') {
            window.location = '<?php echo $url; ?>';
        }
    }, 2000);
}
</script>
<?php include('./include/js.php'); ?>



<?php
if (isset($_POST['new_work'])) {
    $workDate = $_POST['workDate'];
    $startTime = $_POST['startTime'];
    $endTime = $_POST['endTime'];
    $tasks = $_POST['task'];

    $ws_for = $_GET["employee_id"];
    $ws_status = "";
    $ws_recycle = 1;
    $uid = $_SESSION['uid'];
    $currentTime = date('Y-m-d H:i:s'); // Ensure $currentTime is defined

    $ins_sql = "INSERT INTO `work_schedule` 
        (ws_for, ws_date, ws_startTime, ws_endTime, ws_status, ws_up_by, ws_uploadDT, ws_recycle) 
        VALUES ('$ws_for', '$workDate', '$startTime', '$endTime', '$ws_status', '$uid', '$currentTime', '$ws_recycle')";

    if (mysqli_query($con, $ins_sql)) {
        $last_id = mysqli_insert_id($con);
        if (!empty($last_id)) {
            foreach ($tasks as $index => $task) {
                $title = $task['title'];
                $details = $task['details'];
                $wl_status = "";
                $wl_recycle = 1;

                $task_entry_sql = mysqli_query($con, "INSERT INTO `work_list` 
                    (wl_ws_id, wl_title, wl_des, wl_status, wl_uploadDT, wl_recycle) 
                    VALUES ('$last_id', '$title', '$details', '$wl_status', '$currentTime', '$wl_recycle')");
            }
            ?>
<script>
showNotification('Work schedule and tasks saved successfully!', '#28a745');
</script>
<?php
        } else {
            ?>
<script>
showNotification('Error: Failed to get last inserted ID.', '#dc3545');
</script>
<?php
        }
    } else {
        ?>
<script>
showNotification('Error: Failed to insert work schedule.', '#dc3545');
</script>
<?php
    }
}
?>


<?php
if (isset($_POST['edit_schedule'])) {    
    $ws_date = $_POST['ws_date'];
    $ws_stime = $_POST['ws_stime'];
    $ws_etime = $_POST['ws_etime'];

    if (isset($_GET['employee_id'])) {
        $edit_id = $_GET['edit_id'];
        $update_sql = "UPDATE `work_schedule` SET ws_date = '$ws_date', ws_startTime = '$ws_stime', ws_endTime = '$ws_etime' WHERE ws_id = '$edit_id'";

        if (mysqli_query($con, $update_sql)) {
            echo "<script>showNotification('Schedule updated successfully!', '#28a745');</script>";
        } else {
            echo "<script>showNotification('Update failed! Please try again.', '#dc3545');</script>";
        }
    }
}
?>

<?php
if (isset($_POST['edit_wl_schedule'])) {    
    $title = $_POST['title'];
    $details = $_POST['details'];

    if (isset($_GET['employee_id'])) {
        $edit_wl_id = $_GET['edit_wl_id'];
        $update_sql = "UPDATE `work_list` SET wl_title = '$title', wl_des = '$details' WHERE wl_id = '$edit_wl_id'";

        if (mysqli_query($con, $update_sql)) {
            echo "<script>showNotification('Work List updated successfully!', '#28a745');</script>";
        } else {
            echo "<script>showNotification('Update failed! Please try again.', '#dc3545');</script>";
        }
    }
}
?>

<?php
// Accordion head delete button onClick: delete schedule time and assigned tasks
if (isset($_GET["del_id"])) {
    $delete_id = $_GET["del_id"];

    $delete_sql = "DELETE FROM work_schedule WHERE ws_id = '$delete_id'";
    $del_sql = "DELETE FROM work_list WHERE wl_ws_id = '$delete_id'";

    if (mysqli_query($con, $delete_sql) && mysqli_query($con, $del_sql)) {
        echo "<script>showNotification('Schedule & tasks deleted successfully!', '#28a745');</script>";
    } else {
        echo "<script>showNotification('OOPS! Something went wrong.', '#dc3545');</script>";
    }
}
?>
<?php
if (isset($_GET["del_wl_id"])) {
    $delete_id = $_GET["del_wl_id"];
    $del_sql = "DELETE FROM work_list WHERE wl_id = '$delete_id'";

    if (mysqli_query($con, $del_sql)) {
        echo "<script>showNotification('Task deleted successfully!', '#28a745');</script>";
    } else {
        echo "<script>showNotification('OOPS! Task deletion failed.', '#dc3545');</script>";
    }
}
?>