<?php 
session_start();
include "../../config/db.php";

if (isset($_POST['start'])) {
    $start = (int) $_POST['start'];
    $AndWhere = '';

    if (!empty($_POST['FirstFilterValue']) && empty($_POST['SecondFilterValue']) && empty($_POST['ThirdFilterValue'])) {
        $First = mysqli_real_escape_string($con, $_POST['FirstFilterValue']);
        $AndWhere = "AND uname='$First'";
    } elseif (empty($_POST['FirstFilterValue']) && !empty($_POST['SecondFilterValue']) && empty($_POST['ThirdFilterValue'])) {
        $Second = mysqli_real_escape_string($con, $_POST['SecondFilterValue']);
        $AndWhere = "AND uphone='$Second'";
    } elseif (empty($_POST['FirstFilterValue']) && empty($_POST['SecondFilterValue']) && !empty($_POST['ThirdFilterValue'])) {
        $Third = mysqli_real_escape_string($con, $_POST['ThirdFilterValue']);
        $AndWhere = "AND uref_code='$Third'";
    } elseif (!empty($_POST['FirstFilterValue']) && !empty($_POST['SecondFilterValue']) && !empty($_POST['ThirdFilterValue'])) {
        $First = mysqli_real_escape_string($con, $_POST['FirstFilterValue']);
        $Second = mysqli_real_escape_string($con, $_POST['SecondFilterValue']);
        $AndWhere = "AND uname='$First' AND uphone='$Second' AND uref_code='$Third'";
    }

    $sql = "SELECT * FROM users WHERE admin_ref = '{$_SESSION["uref"]}' AND utype = 'employee' AND emp_status = '1' AND udisplay !='disable' $AndWhere ORDER BY uid DESC LIMIT $start, 10";
    $res = mysqli_query($con, $sql);

    if (($total_rows = mysqli_num_rows($res)) > 0) {
        while ($rows = mysqli_fetch_assoc($res)) {
?>
<li class='clearfix'
    style='float:none;list-style:none;margin:10px 0;background:#f8f9fa;border-radius:7px;padding:10px;'>
    <div class='row justify-content-center'>
        <div class='col-md-2 text-center'>
            <?php
            $placeholder = "../assets/img/admin/user.svg";

            // Image file name from DB
            $imgFile = trim($rows["ulogo"] ?? "");

            // Absolute server path of the uploaded file
            $serverFilePath = realpath(__DIR__ . "/../../uploads/employee/" . $imgFile);

            // Browser path
            $browserFilePath = "../uploads/employee/" . $imgFile;

            // Check valid image
            if (!empty($imgFile) && $serverFilePath && file_exists($serverFilePath)) {
                $employeeImg = $browserFilePath;
            } else {
                $employeeImg = $placeholder;
            }
            ?>

            <img src="<?php echo $employeeImg; ?>"
                style="width:auto;height:100px;object-fit:contain;border-radius:8px;background:#fff;"
                alt="Employee Image">

        </div>

        <div class='col-md-5'>
            <a href='employee-profile.php?see_id=<?php echo $rows["uid"]; ?>'
                class='fw-bold text-dark text-decoration-none'>
                <i class='fa fa-user-circle text-warning me-1'></i><?php echo $rows["uname"]; ?>
                [<?= $rows["uref_code"]?>]
            </a><br>
            <span class='small text-muted'><b>Designation:</b>
                <?php
                $find_sql = mysqli_query($con, "SELECT d_name FROM designation WHERE d_id = '$rows[utypeorg]' ");
                $find_row = mysqli_fetch_assoc($find_sql);
                echo $find_row ? $find_row["d_name"] : '-';
                ?>
            </span><br>
            <a href='tel:<?php echo $rows["uphone"]; ?>' class='small text-dark text-decoration-none'>
                <i class='fa fa-phone fa-rotate-90'></i> <?php echo $rows["uphone"]; ?>
            </a><br>
            <a href='mailto:<?php echo $rows["umail"]; ?>' class='small text-dark text-decoration-none'>
                <i class='fa fa-envelope'></i> <?php echo $rows["umail"]; ?>
            </a>
        </div>

        <div class='col-md-2'>
            <div class='mb-2'>
                <select class="form-control status-dropdown" data-emp-id="<?php echo $rows["uid"]; ?>">
                    <option value="1" <?php echo ($rows["emp_status"] == 1) ? 'selected' : ''; ?>>Active</option>
                    <option value="0" <?php echo ($rows["emp_status"] == 0) ? 'selected' : ''; ?>>Inactive</option>
                </select>
            </div>
            <a href='employee-doc.php?employee_id=<?php echo $rows["uid"]; ?>'
                class='btn btn-warning btn-sm w-100 mb-1 text-white'><i class="fa fa-file"></i> Documents</a>
            <a href='employee-notice.php?employee_id=<?php echo $rows["uid"]; ?>'
                class='btn btn-primary btn-sm w-100 mb-1'><i class="fa fa-bell"></i> Notice</a>
        </div>

        <div class='col-md-3'>
            <a href='employee-work.php?employee_id=<?php echo $rows["uid"]; ?>'
                class='btn btn-dark btn-sm w-100 mb-1'><i class="fa fa-tasks"></i> Work Task</a>
            <a href='employee-salary.php?employee_id=<?php echo $rows["uid"]; ?>'
                class='btn btn-success btn-sm w-100 mb-1'><i class="fa fa-money"></i> Salary</a>
            <div class="d-flex">
                <a href='employee-profile.php?edit_id=<?php echo $rows["uid"]; ?>' class='my-2 btn btn-info btn-sm'
                    title='Click to Edit'><i class='fa fa-pencil-square text-white' aria-hidden='true'></i>
                </a>
                <br>
                <a href='employees.php?del_id=<?php echo $rows["uid"]; ?>' class='delete m-2 btn btn-danger btn-sm'
                    title='Click to Delete'><i class='fa fa-trash' aria-hidden='true'></i> </a>
                <br>
                <a href='employee-fingerprint.php?employee_id=<?php echo $rows["uid"]; ?>'
                    class='m-2 btn btn-primary btn-sm' title='Click to Delete'><i class='fa fa-fingerprint'
                        aria-hidden='true'></i> </a>
                <?php
                $employeeId = $rows['uid']; // Replace with the actual employee ID
                $salaryStatus = isSalaryPaid($employeeId, $con);

                if ($salaryStatus === "pending") {
                    $ee = "Pending";
                    ?>
                <div class="">
                    <a href='' class='blinking-text btn btn-sm btn-warning w-100 my-2' style='color:#fff;' title=''>
                        <?php echo $ee; ?>
                    </a>
                </div>
                <?php
                } else {
                    $ee = "Paid";
                    ?>
                <div class="">
                    <a href='' class='btn btn-info w-100 my-2' style='color:#fff;' title=''>
                        <?php echo $ee; ?>
                    </a>
                </div>
                <?php
                }
                ?>
            </div>
        </div>
    </div>
</li>
<?php
        }
    } else {
        echo "No more record found";
    }
}
?>



<script>
$(document).ready(function() {
    $('.status-dropdown').on('change', function() {
        var empId = $(this).data('emp-id');
        var newStatus = $(this).val();

        $.ajax({
            url: './ajax/update_status.php',
            type: 'POST',
            data: {
                empId: empId,
                newStatus: newStatus
            },
            success: function(response) {
                console.log(response);
            },
            error: function(error) {
                console.error(error);
            }
        });
    });
});
</script>

<?php
// Function to get the joining date of the employee
function getEmployeeJoiningDate($employeeId, $con) {
    $query = "SELECT emp_join_date FROM users WHERE uid = '$employeeId'";
    $run = mysqli_query($con, $query);
    $row = mysqli_fetch_assoc($run);

    if ($row) {
        $join_date = $row["emp_join_date"]; // Assume this is in 'Y-m-d' format, e.g., '2023-05-18'

        // Create a DateTime object from the join date
        $date = new DateTime($join_date);

        // Extract day, month, and year without leading zeros
        $day = $date->format('j');   // Day without leading zeros (1 to 31)
        $month = $date->format('n'); // Month without leading zeros (1 to 12)
        $year = $date->format('Y');

        return [
            'join_day' => $day,
            'join_month' => $month,
            'join_year' => $year
        ];
    } else {
        die("Error in preparing the statement: " . mysqli_error($con));
    }
}

// Function to get the latest salary payment date
function getLatestPaymentDate($employeeId, $con) {
    $query2 = "SELECT salary_month, salary_year FROM employee_salary WHERE salary_for = '$employeeId' ORDER BY emp_salary_id DESC LIMIT 1";
    $run2 = mysqli_query($con, $query2);

    if ($run2) {
        $row2 = mysqli_fetch_assoc($run2);

        if ($row2) {
            $salary_month = $row2["salary_month"];
            $salary_year = $row2["salary_year"];

            return [
                'salary_month' => $salary_month,
                'salary_year' => $salary_year
            ];
        } else {
            return null; // No salary records found
        }
    } else {
        die("Error in executing the query: " . mysqli_error($con));
    }
}

// Function to check if salary is paid
function isSalaryPaid($employeeId, $con) {
    $employeeJoiningDate = getEmployeeJoiningDate($employeeId, $con);
    if (is_array($employeeJoiningDate)){
        $emp_join_day = $employeeJoiningDate['join_day'];
        $emp_join_month = $employeeJoiningDate['join_month'];
        $emp_join_year = $employeeJoiningDate['join_year'];
    } else {
        return "Error: Unable to fetch employee joining date.";
    }

    $latestPaymentDate = getLatestPaymentDate($employeeId, $con);
    if (is_array($latestPaymentDate)){
        $last_salary_month = $latestPaymentDate['salary_month'];
        $last_salary_year = $latestPaymentDate['salary_year'];
    } else {
        return "pending"; // No payment records found, so pending
    }

    $current_day = (int) date('j');
    $current_month = (int) date('n');
    $current_year = (int) date('Y');

    $months_diff = (($current_year - $last_salary_year) * 12) + ($current_month - $last_salary_month);

    if ($months_diff > 1) {
        return "pending"; // There are pending months
    }

    return "paid"; // Salary is up to date
}

?>