<?php include('./include/header.php'); ?>
<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>
    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>

        <div class="container-fluid p-4" id="body-content">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="mb-0"><i class="fa fa-users me-2 text-primary"></i> Employee Management</h5>
                <div class="d-flex gap-2">
                    <a href="employee-profile.php?add_employee" class="btn btn-success btn-sm">
                        <i class="fa fa-user-plus me-1"></i> Add Employee
                    </a>

                    <a href="ajax/employees_export_csv.php" class="btn btn-outline-success btn-sm d-none">
                        <i class="fa fa-file-csv me-1"></i> Download CSV
                    </a>

                    <a href="ajax/employees_export_pdf.php" target="_blank" class="btn btn-outline-danger btn-sm">
                        <i class="fa fa-file-pdf me-1"></i> Download PDF
                    </a>
                </div>

            </div>

            <div class="card shadow-sm border-0 mb-4">
                <div class="card-body">
                    <h6 class="card-title mb-3 text-secondary">
                        <i class="fa fa-filter me-1 text-muted"></i> Filter Employees
                    </h6>

                    <div class="row g-3 align-items-end">
                        <!-- Name Filter -->
                        <div class="col-md-4">
                            <label for="FirstFilterValue" class="form-label fw-semibold">Select Name</label>
                            <input type="text" list="First" class="form-control form-control-sm" id="FirstFilterValue"
                                placeholder="Search by name">
                            <datalist id="First">
                                <?php 
                                    $sql = "SELECT uname FROM users WHERE utype = 'employee' AND emp_status = '1' AND udisplay !='disable' AND admin_ref = '{$_SESSION["uref"]}' ORDER BY uname ASC";
                                    $res = mysqli_query($con,$sql);
                                    while ($row = mysqli_fetch_assoc($res)) {
                                        echo '<option value="'.$row['uname'].'">';
                                    }
                                ?>
                            </datalist>
                        </div>

                        <!-- Phone Filter -->
                        <div class="col-md-4">
                            <label for="SecondFilterValue" class="form-label fw-semibold">Phone</label>
                            <input type="text" list="Second" class="form-control form-control-sm" id="SecondFilterValue"
                                placeholder="Search by phone">
                            <datalist id="Second">
                                <?php
                                    $sql = "SELECT uphone FROM users WHERE utype = 'employee' AND emp_status = '1' AND udisplay !='disable' AND admin_ref = '{$_SESSION["uref"]}' ORDER BY uid DESC"; 
                                    $res = mysqli_query($con,$sql);
                                    while ($row = mysqli_fetch_assoc($res)) {
                                        echo '<option value="'.$row['uphone'].'">';
                                    }
                                ?>
                            </datalist>
                        </div>

                        <!-- Id Filter -->
                        <div class="col-md-2">
                            <label for="ThirdFilterValue" class="form-label fw-semibold">Id</label>
                            <input type="text" list="Third" class="form-control form-control-sm" id="ThirdFilterValue"
                                placeholder="Search by ID">
                            <datalist id="Third">
                                <?php
                                    $sql = "SELECT uref_code FROM users WHERE utype = 'employee' AND emp_status = '1' AND udisplay !='disable' AND admin_ref = '{$_SESSION["uref"]}' ORDER BY uid DESC"; 
                                    $res = mysqli_query($con,$sql);
                                    while ($row = mysqli_fetch_assoc($res)) {
                                        echo '<option value="'.$row['uref_code'].'">';
                                    }
                                ?>
                            </datalist>
                        </div>

                        <!-- Search Button -->
                        <div class="col-md-2">
                            <button type="button" id="filter" class="btn btn-sm btn-primary w-100">
                                <i class="fa fa-search me-1"></i> Search
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card shadow-sm border-0 mb-5">
                <div class="row">
                    <!--loader -->
                    <div class="col-12" id='loader' style="display:none;">
                        <ul style="list-style: none; padding-left: 0;">
                            <?php 
                            for ($count = 0; $count < 4; $count++) {
                                echo '<li>
                                    <div class="ph-item">
                                    <div class="ph-row">
                                    <div class="ph-col-12 big"></div>
                                    <div class="ph-col-12"></div>
                                    <div class="ph-col-12"></div>
                                    <div class="ph-col-12"></div>
                                    </div></div>
                                    </li>';
                            }
                            ?>
                        </ul>
                    </div>
                    <!-- loader -->
                    <?php
                        if(isset($_GET['rec_id'])){
                            $sql = "SELECT * FROM users  WHERE utype = 'employee' AND emp_status = '0' AND udisplay ='disable' AND admin_ref = '{$_SESSION["uref"]}' ORDER BY uid DESC ";

                            $res = mysqli_query($con, $sql);

                            if ($total_rows = mysqli_num_rows($res) > 0) {
                                $c = 1;
                            ?>
                    <div class="col-md-12">
                        <div class="d-flex justify-content-end">
                            <a href="employees.php" class="btn-sm btn btn-outline-success"> Active </a>
                        </div>
                        <?php 
                                while ($rows = mysqli_fetch_assoc($res)) {?>
                        <li class='clearfix'
                            style='float:none;list-style:none;margin:10px 0;background:#f8f9fa;border-radius:7px;padding:10px;'>
                            <div class='row justify-content-center'>
                                <div class='col-md-2 text-center'>
                                    <?php 
                                    // Define placeholder image path
                                    $placeholder = "../assets/img/admin/user.svg";

                                    // Get actual image path
                                    $employeeImg = !empty($rows["ulogo"]) && file_exists($rows["ulogo"]) ? $rows["ulogo"] : $placeholder;
                                    ?>
                                    <img src="<?php echo $employeeImg; ?>"
                                        style="width:auto;height:100px;object-fit:contain;border-radius:8px;background:#fff;"
                                        alt="Employee Image">
                                </div>

                                <div class='col-md-5'>
                                    <a href='employee-profile.php?see_id=<?php echo $rows["uid"]; ?>'
                                        class='fw-bold text-dark text-decoration-none'>
                                        <i class='fa fa-user-circle text-warning me-1'></i><?php echo $rows["uname"]; ?>
                                    </a><br>
                                    <span class='small text-muted'><b>Designation:</b>
                                        <?php
                                        $find_sql = mysqli_query($con, "SELECT d_name FROM designation WHERE d_id = '$rows[utypeorg]' ");
                                        $find_row = mysqli_fetch_assoc($find_sql);
                                        echo $find_row ? $find_row["d_name"] : '-';
                                        ?>
                                    </span><br>
                                    <a href='tel:<?php echo $rows["uphone"]; ?>'
                                        class='small text-dark text-decoration-none'>
                                        <i class='fa fa-phone fa-rotate-90'></i> <?php echo $rows["uphone"]; ?>
                                    </a><br>
                                    <a href='mailto:<?php echo $rows["umail"]; ?>'
                                        class='small text-dark text-decoration-none'>
                                        <i class='fa fa-envelope'></i> <?php echo $rows["umail"]; ?>
                                    </a>
                                </div>

                                <div class='col-md-2'>
                                    <div class='mb-2'>
                                        <select class="form-control status-dropdown"
                                            data-emp-id="<?php echo $rows["uid"]; ?>">
                                            <option value="1"
                                                <?php echo ($rows["emp_status"] == 1) ? 'selected' : ''; ?>>Active
                                            </option>
                                            <option value="0"
                                                <?php echo ($rows["emp_status"] == 0) ? 'selected' : ''; ?>>Inactive
                                            </option>
                                        </select>
                                    </div>
                                    <a href='employee-doc.php?doc_id=<?php echo $rows["uid"]; ?>'
                                        class='btn btn-warning btn-sm w-100 mb-1 text-white'><i class="fa fa-file"></i>
                                        Documents</a>
                                    <a href='employee-notice.php?notice_id=<?php echo $rows["uid"]; ?>'
                                        class='btn btn-primary btn-sm w-100 mb-1'><i class="fa fa-bell"></i> Notice</a>
                                </div>

                                <div class='col-md-3'>
                                    <a href='employee-work.php?work_id=<?php echo $rows["uid"]; ?>'
                                        class='btn btn-dark btn-sm w-100 mb-1'><i class="fa fa-tasks"></i> Work Task</a>
                                    <a href='employee-salary.php?employee_id=<?php echo $rows["uid"]; ?>'
                                        class='btn btn-success btn-sm w-100 mb-1'><i class="fa fa-money"></i> Salary</a>
                                    <div class="d-flex">
                                        <a href='employee-profile.php?edit_id=<?php echo $rows["uid"]; ?>'
                                            class='my-2 btn btn-info btn-sm' title='Click to Edit'><i
                                                class='fa fa-pencil-square text-white' aria-hidden='true'></i>
                                        </a>
                                        <br>
                                        <a href='employees.php?res_id=<?php echo $rows["uid"]; ?>'
                                            class='m-2 btn btn-warning btn-sm' title='Click to recycle'><i
                                                class='fa fa-recycle text-white' aria-hidden='true'></i> </a>
                                    </div>
                                </div>
                            </div>
                        </li>
                        <?php  $c++;
                                } ?>
                    </div>
                    <?php
                                } else {echo "<div class='col-md-12 p-3'>
                                    <div class='d-flex justify-content-end'>
                            <a href='employees.php' class='btn-sm btn btn-outline-success'> Active </a>
                        </div>
                        No employees.</div>";}
                            }else{
                            ?>
                    <div class="col-12" id="full-table">
                        <div class="d-flex justify-content-end p-3 pb-0">
                            <a href="employees.php?rec_id" class="btn-sm btn btn-outline-primary"> Recycle </a>
                        </div>
                        <ul class="timeline" id="full-table-data" style="padding: 10px;">
                            </>
                        </ul>
                    </div>
                    <div class="col-12" id="filter-table" style="display: none; padding: 10px;">
                        <ul class="timeline" id="filter-table-data"></ul>
                    </div>

                    <div class="col-12">
                        <div class="text-center mb-3">
                            <button id="loadMoreBtn" class="btn btn-sm btn-outline-primary">Load More</button>
                            <div id="noMoreMsg" class="text-muted mt-2" style="display:none;">No more record found</div>
                        </div>
                    </div>
                    <?php } ?>
                </div>
            </div>
        </div>

        <?php include('./include/footer.php'); ?>
    </div>
</div>

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

<script>
$(document).ready(function() {
    let load_flag = 0;
    let load_filter_flag = 0;
    let isFiltered = false;
    let FirstFilterValue = '';
    let SecondFilterValue = '';
    let ThirdFilterValue = '';

    // Flags to stop further loads
    let hasMore = true;
    let hasMoreFilter = true;

    // Initial load
    loadMore(load_flag);

    // Helper to detect "No more" reliably (works with plain text or wrapped HTML)
    function isNoMore(text) {
        if (!text) return true;
        return /no more record found/i.test(text); // case-insensitive contains
    }

    // FILTER button click
    $("#filter").click(function() {
        FirstFilterValue = $('#FirstFilterValue').val().trim();
        SecondFilterValue = $('#SecondFilterValue').val().trim();
        ThirdFilterValue = $('#ThirdFilterValue').val().trim();
        load_filter_flag = 0;
        isFiltered = true;
        hasMoreFilter = true; // reset filtered flag
        $("#noMoreMsg").hide();
        $("#loadMoreBtn").show();

        if (FirstFilterValue || SecondFilterValue || ThirdFilterValue) {
            $("#loader").show();

            $.ajax({
                url: 'ajax/employees-ajax.php',
                type: 'POST',
                data: {
                    FirstFilterValue,
                    SecondFilterValue,
                    ThirdFilterValue,
                    start: load_filter_flag
                },
                success: function(result) {
                    const trimmed = $.trim(result);

                    // show/hide correct containers
                    $('#full-table-data').hide();
                    $('#filter-table').show();
                    $('#filter-table-data').html(trimmed);

                    if (isNoMore(trimmed)) {
                        hasMoreFilter = false;
                        $("#noMoreMsg").show();
                        $("#loadMoreBtn").hide();
                    } else {
                        load_filter_flag += 10;
                        hasMoreFilter = true;
                    }
                },
                error: function() {
                    console.error('AJAX error on filter load.');
                },
                complete: function() {
                    $("#loader").hide();
                }
            });
        } else {
            alert("Please select at least one filter.");
            $('#full-table-data').show();
            $('#filter-table-data').hide();
            isFiltered = false;
        }
    });

    // LOAD MORE button click
    $("#loadMoreBtn").click(function() {
        if (isFiltered) {
            if (!hasMoreFilter) return; // stop if no more
            loadMoreFilter(load_filter_flag);
        } else {
            if (!hasMore) return; // stop if no more
            loadMore(load_flag);
        }
    });

    // LOAD MORE (unfiltered)
    function loadMore(start) {
        if (!hasMore) return;
        $("#loader").show();

        $.ajax({
            url: 'ajax/employees-ajax.php',
            type: 'POST',
            data: {
                start
            },
            success: function(result) {
                const trimmed = $.trim(result);
                if (isNoMore(trimmed) || trimmed === '') {
                    hasMore = false;
                    $("#noMoreMsg").show();
                    $("#loadMoreBtn").hide();
                } else {
                    // append returned items and ensure container visible
                    $('#full-table-data').append(trimmed).show();
                    load_flag += 10;
                    $("#noMoreMsg").hide();
                    $("#loadMoreBtn").show();
                }
            },
            error: function() {
                console.error('AJAX error on loadMore.');
            },
            complete: function() {
                $("#loader").hide();
            }
        });
    }

    // LOAD MORE (filtered)
    function loadMoreFilter(start) {
        if (!hasMoreFilter) return;
        $("#loader").show();

        $.ajax({
            url: 'ajax/employees-ajax.php',
            type: 'POST',
            data: {
                FirstFilterValue,
                SecondFilterValue,
                ThirdFilterValue,
                start
            },
            success: function(result) {
                const trimmed = $.trim(result);
                if (isNoMore(trimmed) || trimmed === '') {
                    hasMoreFilter = false;
                    $("#noMoreMsg").show();
                    $("#loadMoreBtn").hide();
                } else {
                    $('#filter-table-data').append(trimmed);
                    load_filter_flag += 10;
                    $("#noMoreMsg").hide();
                    $("#loadMoreBtn").show();
                }
            },
            error: function() {
                console.error('AJAX error on loadMoreFilter.');
            },
            complete: function() {
                $("#loader").hide();
            }
        });
    }
});
</script>


<script>
$(document).ready(function() {
    $('.status-dropdown').on('change', function() {
        var empId = $(this).data('emp-id');
        var newStatus = $(this).val();

        $.ajax({
            url: 'ajax/update_status.php',
            type: 'POST',
            data: {
                empId: empId,
                newStatus: newStatus
            },
            success: function(response) {
                console.log(response);
            },
            error: function(error) {
                console.error(error);
            }
        });
    });
});
</script>

<?php include('./include/js.php'); ?>


<?php
    if ( isset($_GET["del_id"]) ) {

    $disable_sql = "UPDATE users SET udisplay='disable' AND emp_status = '0' WHERE uid = '$_GET[del_id]'";

        if ( mysqli_query($con, $disable_sql) ) {
            ?>
<script>
window.location = "employees.php";
</script>
<?php
        } else {
            ?>
<script>
alert('OOPS !!!!');
setTimeout(() => {
    window.location = 'employees.php';
}, 1200);
</script>
<?php
        }

    }
?>
<?php
    if ( isset($_GET["res_id"]) ) {

    $active_sql = "UPDATE users SET udisplay='' AND emp_status = '1' WHERE uid = '$_GET[res_id]'";

        if ( mysqli_query($con, $active_sql) ) {
            ?>
<script>
window.location = "employees.php";
</script>
<?php
        } else {
            ?>
<script>
alert('OOPS !!!!');
setTimeout(() => {
    window.location = 'employees.php';
}, 1200);
</script>
<?php
        }

    }
?>