<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
header('Content-Type: application/json');

include "../config/db.php";

/* AUTH */
if (!isset($_SESSION['uid'])) {
    echo json_encode(["error" => "NO_SESSION"]);
    exit;
}

if ($_SESSION['utype'] !== 'basic_lvl_admin') {
    echo json_encode(["error" => "NOT_ADMIN"]);
    exit;
}

/* INPUT */
$emp_id = (int)($_GET['employee_id'] ?? 0);
$from   = $_GET['from'] ?? date('Y-m-d');
$to     = $_GET['to'] ?? date('Y-m-d');

if (!$emp_id) {
    echo json_encode(["error" => "INVALID_EMP_ID"]);
    exit;
}

/* QUERY */
$sql = "SELECT latitude, longitude, speed, created_at, UNIX_TIMESTAMP(created_at) as ts FROM emp_location_track WHERE emp_id = '$emp_id' AND DATE(created_at) BETWEEN '$from' AND '$to' ORDER BY created_at ASC ";

$q = mysqli_query($con, $sql);

if (!$q) {
    echo json_encode(["error" => mysqli_error($con)]);
    exit;
}

$data = [];
while ($row = mysqli_fetch_assoc($q)) {
    $data[] = $row;
}

/* ALWAYS RETURN JSON */
echo json_encode($data);