<?php
if (session_status() === PHP_SESSION_NONE) session_start();

// Regenerate session ID every 10 minutes to prevent fixation
if (!isset($_SESSION['created'])) {
    $_SESSION['created'] = time();
} elseif (time() - $_SESSION['created'] > 600) { // 10 min
    session_regenerate_id(true);
    $_SESSION['created'] = time();
}

include "../config/db.php";
include "../config/constants.php";

// SECURITY: Ensure user is logged in
if (empty($_SESSION['uid']) || empty($_SESSION['uref']) || empty($_SESSION['utype'])) {
    session_unset();
    session_destroy();
    header("Location: ../logout.php?error=session_expired");
    exit();
}

// SECURITY: Restrict admin access
if ($_SESSION['utype'] !== 'basic_lvl_admin') {
    header("Location: ../logout.php?error=unauthorized");
    exit();
}

// Optional: set HTTP headers for added protection
header("X-Frame-Options: SAMEORIGIN"); 
header("X-Content-Type-Options: nosniff");
header("X-XSS-Protection: 1; mode=block");
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>HRM || Admin</title>

    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- FontAwesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

    <!-- Custom Styles -->
    <link href="../assets/css/admin.css" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
    <link href="../assets/css/dashboard.css" rel="stylesheet">
    <link href="../assets/css/responsive.css" rel="stylesheet">

    <!-- Map tracking -->
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

    <?php include("include/css.php"); ?>
</head>

<body>