<style>
/* ===============================
   REPORT TABS (CUSTOM STYLE)
================================ */

.report-tabs {
    display: flex;
    gap: 8px;
    list-style: none;
    padding: 0;
    margin: 0;
}

.report-tabs li {
    display: inline-block;
}

.tab-btn {
    border: none;
    background: #f8f9fa;
    color: #555;
    padding: 5px 5px;
    border-radius: 5px;
    font-size: 14px;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 8px;
    cursor: pointer;
    transition: all 0.25s ease;
    border: 1px solid transparent;
}

.tab-btn i {
    font-size: 15px;
    opacity: 0.8;
}

.tab-btn:hover {
    background: #eef2ff;
    color: #4338ca;
}

.tab-btn.active {
    background: #ffffff;
    color: #4338ca;
    border: 1px solid #e5e7eb;
    border-bottom: 2px solid #ffffff;
    box-shadow: 0 -2px 8px rgba(67, 56, 202, 0.08);
}

.tab-btn.active i {
    opacity: 1;
}
</style>

<ul class="report-tabs mt-4">
    <li>
        <button type="button" class="tab-btn active" data-type="attendance" onclick="switchTab(this)">
            <i class="fa fa-calendar-check"></i>
            <span>Attendance</span>
        </button>
    </li>
    <li>
        <button type="button" class="tab-btn" data-type="salary" onclick="switchTab(this)">
            <i class="fa fa-wallet"></i>
            <span>Salary</span>
        </button>
    </li>
    <li>
        <button type="button" class="tab-btn" onclick="openLocationReport()">
            <i class="fa fa-map-marker-alt"></i>
            <span>Location</span>
        </button>
    </li>
    <li>
        <button type="button" class="tab-btn" data-type="work" onclick="switchTab(this)">
            <i class="fa fa-tasks"></i>
            <span>Work Schedule</span>
        </button>
    </li>
</ul>