<?php
// Detect current page name (without extension)
$currentPage = basename($_SERVER['PHP_SELF'], '.php');

// Define readable page names
$pageTitles = [
    'dashboard' => 'Dashboard',
    'employees' => 'Employees',
    'employee-profile' => 'Employee Profile',
    'departments' => 'Departments',
    'work-distribution' => 'Work Distribution',
    'attendance' => 'Attendance',
    'leaves' => 'Leaves',
    'payroll' => 'Payroll',
    'performance' => 'Performance',
    'reports' => 'Reports',
    'notifications' => 'Notifications',
    'settings' => 'Settings',
    'audit-logs' => 'Audit Logs',
    'tasks' => 'Tasks',
    'profile' => 'My Profile',
    'index' => 'Dashboard'
];

// Get readable page title
$pageTitle = $pageTitles[$currentPage] ?? ucfirst($currentPage);

// Detect whether we’re in admin or employee section
$scriptPath = $_SERVER['SCRIPT_NAME'];
if (strpos($scriptPath, './admin/') !== false) {
    $dashboardUrl = './admin/index.php';
} else {
    $dashboardUrl = './index.php';
}
?>

<!-- Top Navbar -->
<nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm px-3 sticky-top">
    <button class="btn btn-outline-dark d-lg-none me-2" type="button" data-bs-toggle="offcanvas"
        data-bs-target="#offcanvasSidebar" aria-controls="offcanvasSidebar">
        <i class="fa fa-bars"></i>
    </button>

    <!-- Collapsible Sidebar Toggle for Desktop -->
    <button class="btn btn-outline-dark d-none d-lg-inline-block me-3 desktop-toggler" id="sidebarToggle">
        <i class="fa fa-bars"></i>
    </button>

    <a class="navbar-brand fw-bold" href="<?= htmlspecialchars($dashboardUrl) ?>">
        <?= htmlspecialchars($pageTitle); ?>
    </a>

    <div class="ms-auto d-flex align-items-center">
        <div class="dropdown me-3 position-relative">
            <a href="#" class="text-dark" id="notificationDropdown" data-bs-toggle="dropdown">
                <i class="fa-regular fa-bell fs-5"></i>
                <span class="badge bg-danger rounded-pill position-absolute top-0 start-100 translate-middle">3</span>
            </a>
            <ul class="dropdown-menu dropdown-menu-end">
                <li><a class="dropdown-item" href="#">New Leave Request</a></li>
                <li><a class="dropdown-item" href="#">Payroll Processed</a></li>
                <li><a class="dropdown-item" href="#">Attendance Report Ready</a></li>
            </ul>
        </div>

        <div class="dropdown">
            <a href="#" class="d-flex align-items-center text-dark text-decoration-none" data-bs-toggle="dropdown">
                <img src="../assets/img/employees/default.jpeg" alt="Profile" width="32" height="32"
                    class="rounded-circle me-2">
                <strong>Admin</strong>
            </a>
            <ul class="dropdown-menu dropdown-menu-end text-small">
                <li><a class="dropdown-item" href="./profile.php">Profile</a></li>
                <li><a class="dropdown-item" href="../logout.php">Logout</a></li>
            </ul>
        </div>
    </div>
</nav>