<?php include('./include/header.php'); ?>
<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>
    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>

        <div class="container-fluid p-4" id="body-content">
            <!-- Dashboard Quick Links -->
            <div class="row g-3 mb-4">
                <div class="col-6 col-md-3">
                    <a href="./employees.php" class="text-decoration-none">
                        <div class="card shadow-sm border-0 text-center p-3">
                            <i class="fa fa-users fa-2x text-primary mb-2"></i>
                            <h6>Employees</h6>
                        </div>
                    </a>
                </div>
                <div class="col-6 col-md-3">
                    <a href="./attendance.php" class="text-decoration-none">
                        <div class="card shadow-sm border-0 text-center p-3">
                            <i class="fa fa-fingerprint fa-2x text-success mb-2"></i>
                            <h6>Attendance</h6>
                        </div>
                    </a>
                </div>
                <div class="col-6 col-md-3">
                    <a href="./payroll.php" class="text-decoration-none">
                        <div class="card shadow-sm border-0 text-center p-3">
                            <i class="fa fa-money-bill fa-2x text-warning mb-2"></i>
                            <h6>Payroll</h6>
                        </div>
                    </a>
                </div>
                <div class="col-6 col-md-3">
                    <a href="./reports.php" class="text-decoration-none">
                        <div class="card shadow-sm border-0 text-center p-3">
                            <i class="fa fa-chart-line fa-2x text-danger mb-2"></i>
                            <h6>Reports</h6>
                        </div>
                    </a>
                </div>
            </div>

            <!-- Attendance and Notifications Section -->
            <div class="row g-4">
                <!-- Today's Attendance -->
                <div class="col-lg-8">
                    <div class="card shadow-sm border-0">
                        <div
                            class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                            <h6 class="mb-0">Today's Employee Attendance</h6>
                            <a href="./attendance.php" class="text-white small text-decoration-none">View All</a>
                        </div>
                        <div class="card-body p-0">
                            <div class="table-responsive">
                                <table class="table table-hover mb-0 align-middle">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Employee</th>
                                            <th>Department</th>
                                            <th>Status</th>
                                            <th>Check-In</th>
                                            <th>Check-Out</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                            $date = $_GET['date'] ?? date('Y-m-d');
                                            $dept = $_GET['department'] ?? '';

                                            $q = "SELECT * FROM users 
                                                WHERE admin_ref='{$_SESSION['uref']}' 
                                                AND utype='employee' AND emp_status='1' 
                                                AND udisplay!='disable'";

                                            if (!empty($dept)) $q .= " AND utypeorg='$dept'";
                                            $q .= " ORDER BY uname ASC";

                                            $employees = mysqli_query($con, $q);

                                            $list = [];

                                            // fetch & push with priority value
                                            while ($emp = mysqli_fetch_assoc($employees)) {

                                                $att = mysqli_fetch_assoc(mysqli_query(
                                                    $con,
                                                    "SELECT * FROM attendance 
                                                    WHERE user_id='{$emp['uid']}' AND date='$date'"
                                                ));

                                                $desg = '-';
                                                $dg = mysqli_query($con,"SELECT d_name FROM designation WHERE d_id='{$emp['utypeorg']}'");
                                                if ($dg_row = mysqli_fetch_assoc($dg)) $desg = $dg_row['d_name'];

                                                $status = $att['status'] ?? 'Not Marked';

                                                // priority assignment
                                                $priority = match($status){
                                                    'Not Marked' => 1,
                                                    'Half Day' => 2,
                                                    default => 3
                                                };

                                                $list[] = [
                                                    "name"=>$emp['uname'],
                                                    "desg"=>$desg,
                                                    "status"=>$status,
                                                    "in"=>$att['check_in'] ?? '-',
                                                    "out"=>$att['check_out'] ?? '-',
                                                    "priority"=>$priority
                                                ];
                                            }

                                            // sort by priority
                                            usort($list, function($a,$b){
                                                return $a['priority'] <=> $b['priority'];
                                            });

                                            // limit 7 results
                                            $list = array_slice($list,0,10);

                                            foreach($list as $row){

                                                $badge = match($row['status']){
                                                    'Present'=>'success',
                                                    'Late'=>'warning',
                                                    'Half Day'=>'info',
                                                    'Absent'=>'danger',
                                                    'Not Marked'=>'secondary',
                                                    default=>'secondary'
                                                };

                                                echo "
                                                <tr>
                                                    <td>{$row['name']}</td>
                                                    <td>{$row['desg']}</td>
                                                    <td><span class='badge bg-{$badge}'>{$row['status']}</span></td>
                                                    <td>{$row['in']}</td>
                                                    <td>{$row['out']}</td>
                                                </tr>";
                                            }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Recent Notifications -->
                <?php
                function timeAgo($time){
                    $timestamp = strtotime($time);
                    $diff = time() - $timestamp;

                    if($diff < 60) return "Just now";
                    $mins = round($diff/60);
                    if($mins < 60) return $mins . " min ago";
                    $hours = round($diff/3600);
                    if($hours < 24) return $hours . " hr ago";
                    $days = round($diff/86400);
                    if($days == 1) return "Yesterday";
                    if($days < 7) return $days . " days ago";
                    return date("d M Y", $timestamp);
                }
                ?>

                <div class="col-lg-4">
                    <div class="card shadow-sm border-0">
                        <div
                            class="card-header bg-secondary text-white d-flex justify-content-between align-items-center">
                            <h6 class="mb-0">Recent Notifications</h6>
                            <a href="./notice.php" class="text-white small text-decoration-none">View All</a>
                        </div>

                        <div class="card-body">
                            <?php
                            $uid  = $_SESSION['uid'];
                            $uref = $_SESSION['uref'];

                            $sql = "(SELECT l.leave_id AS id, 
                                        CONCAT(u.uname,' - Leave ', l.status) AS msg, 
                                        l.applied_on AS time, 
                                        'Leave' AS type
                                FROM leaves l
                                JOIN users u ON l.user_id = u.uid
                                WHERE l.user_id IN (SELECT uid FROM users WHERE admin_ref='$uref')
                            )
                            UNION
                            (   
                                SELECT r.id,
                                    CONCAT(u.uname,' - Resignation ', r.status) AS msg,
                                    r.updated_at AS time,
                                    'Resignation' AS type
                                FROM resignations r
                                JOIN users u ON r.user_id = u.uid
                                WHERE r.org_id='$uid'
                            )
                            ORDER BY time DESC LIMIT 5";


                            $notify = mysqli_query($con, $sql);

                            if (mysqli_num_rows($notify) > 0) {
                                while ($n = mysqli_fetch_assoc($notify)) {

                                    $icon = match($n['type']) {
                                        'Notice'      => 'fa-bullhorn text-primary',
                                        'Leave'       => 'fa-calendar-check text-success',
                                        'Resignation' => 'fa-flag text-danger',
                                        default       => 'fa-info-circle text-secondary'
                                    };

                                    echo "
                                    <div class='mb-3 border-bottom pb-2'>
                                        <p class='mb-1 text-dark'>
                                            <i class='fa $icon me-1'></i> {$n['msg']}
                                        </p>
                                        <small class='text-muted'>
                                            <i class='fa fa-clock me-1'></i>".timeAgo($n['time'])."
                                        </small>
                                    </div>";
                                }
                            } else {
                                echo "<p class='text-muted mb-0'>No notifications yet.</p>";
                            }
                            ?>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <?php include('./include/footer.php'); ?>
    </div>
</div>
<?php include('./include/js.php'); ?>