<?php
include("../config/db.php");
session_start();

if (!isset($_SESSION['uid'])) {
    header("Location: ../login.php");
    exit;
}

$id = intval($_GET['id'] ?? 0);
$action = $_GET['action'] ?? '';

if ($id && in_array($action, ['approve', 'reject'])) {
    $status = ($action === 'approve') ? 'Approved' : 'Rejected';
    $stmt = $con->prepare("UPDATE leaves SET status=? WHERE leave_id=?");
    $stmt->bind_param("si", $status, $id);
    if ($stmt->execute()) {
        header("Location: leaves.php?msg=Leave $status successfully");
    } else {
        header("Location: leaves.php?msg=Action failed");
    }
} else {
    header("Location: leaves.php");
}
exit;