<?php include('./include/header.php'); ?>
<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>
    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>

        <div class="container-fluid p-4" id="body-content">

            <h4 class="fw-bold mb-3">
                <i class="fa fa-cog text-primary me-2"></i> Leave Management Settings
            </h4>

            <div class="row">
                <!-- LEFT: Leave Quotas -->
                <div class="col-md-6">
                    <div class="card shadow-sm border-0 mb-4">
                        <div class="card-body">
                            <h5 class="fw-bold text-primary">Leave Quota Settings</h5>
                            <hr>

                            <form action="leave-settings-save.php" method="POST">

                                <div class="mb-3">
                                    <label class="form-label fw-bold">Leave Count Duration</label>
                                    <select class="form-select" name="leave_timeFrame">
                                        <option value="">Select From List</option>

                                        <option value="Monthly"
                                            <?= getSetting('leave_timeFrame') == 'Monthly' ? 'selected' : '' ?>>
                                            Monthly
                                        </option>

                                        <option value="Yrarly"
                                            <?= getSetting('leave_timeFrame') == 'Yrarly' ? 'selected' : '' ?>>
                                            Yrarly
                                        </option>
                                    </select>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label fw-bold">Casual Leave</label>
                                    <input type="number" class="form-control" name="casual_leave"
                                        value="<?= getSetting('casual_leave') ?>" placeholder="Enter CL ">
                                </div>

                                <div class="mb-3">
                                    <label class="form-label fw-bold">Sick Leave</label>
                                    <input type="number" class="form-control" name="sick_leave"
                                        value="<?= getSetting('sick_leave') ?>" placeholder="Enter SL ">
                                </div>

                                <button class="btn btn-success px-4" type="submit">
                                    <i class="fa fa-save me-1"></i> Save Settings
                                </button>

                            </form>
                        </div>
                    </div>
                </div>

                <!-- Weekly Off, Half Day, Working hours -->
                <div class="col-md-6">
                    <div class="card shadow-sm border-0 mb-4">
                        <div class="card-body">
                            <h5 class="fw-bold text-primary">Shift Management</h5>
                            <hr>
                            <form action="weekly-off-save.php" method="POST">

                                <div class="row g-2">

                                    <!-- WEEKLY OFF -->
                                    <div class="col-md-6 d-none">
                                        <label class="form-label fw-bold">Weekly Off Days</label>
                                        <div class="d-flex flex-wrap gap-2">

                                            <?php
                                            $days = ['Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday'];
                                            $selectedOff = explode(',', getSetting('weekly_off'));

                                            foreach ($days as $day) {
                                                $active = in_array($day, $selectedOff) ? "active" : "";
                                                $checked = in_array($day, $selectedOff) ? "checked" : "";

                                                echo "
                                                <input type='checkbox' class='btn-check' id='off-$day' name='weekly_off[]' value='$day' $checked>
                                                <label class='btn btn-outline-primary btn-sm $active' for='off-$day'>$day</label>
                                                ";
                                            }
                                            ?>
                                        </div>
                                    </div>

                                    <!-- HALF DAY -->
                                    <div class="col-md-6 d-none">
                                        <label class="form-label fw-bold">Half-Day On</label>
                                        <div class="d-flex flex-wrap gap-2">

                                            <?php
                                            $halfSelected = explode(',', getSetting('is_half_day'));

                                            // "No Half-Day" option
                                            $noActive = in_array("0", $halfSelected) ? "active" : "";
                                            $noChecked = in_array("0", $halfSelected) ? "checked" : "";

                                            // Days options
                                            foreach ($days as $day) {
                                                $active = in_array($day, $halfSelected) ? "active" : "";
                                                $checked = in_array($day, $halfSelected) ? "checked" : "";

                                                echo "
                                                <input type='checkbox' class='btn-check' id='half-$day' name='is_half_day[]' value='$day' $checked>
                                                <label class='btn btn-outline-warning btn-sm $active' for='half-$day'>$day</label>
                                                ";
                                            }

                                            echo "
                                            <input type='checkbox' class='btn-check' id='half-0' name='is_half_day[]' value='0' $noChecked>
                                            <label class='btn btn-outline-danger btn-sm $noActive' for='half-0'>No Half-Day</label>
                                            ";
                                            ?>
                                        </div>
                                    </div>

                                    <!-- SHIFT Management    -->
                                    <div class="col-md-12">
                                        <label class="form-label fw-bold">Work Shifts</label>

                                        <?php 
                                        // get saved shifts (stored as JSON)
                                        $shiftData = json_decode(getSetting('work_shifts'), true) ?? [
                                            ["start" => "09:00", "end" => "18:00"]
                                        ];
                                        ?>

                                        <div id="shiftContainer" class="d-flex flex-column gap-3">

                                            <?php foreach ($shiftData as $index => $shift): ?>
                                            <div class="row g-3 shift-row">
                                                <div class="col-md-5">
                                                    <label class="small">Start Time</label>
                                                    <input type="time" class="form-control form-control-sm"
                                                        name="shift_start[]" value="<?= $shift['start'] ?>">
                                                </div>

                                                <div class="col-md-5">
                                                    <label class="small">End Time</label>
                                                    <input type="time" class="form-control form-control-sm"
                                                        name="shift_end[]" value="<?= $shift['end'] ?>">
                                                </div>

                                                <div class="col-md-2 d-flex align-items-end">
                                                    <button type="button"
                                                        class="btn btn-danger btn-sm removeShift">Remove</button>
                                                </div>
                                            </div>
                                            <?php endforeach; ?>

                                        </div>

                                        <button type="button" id="addShiftBtn" class="btn btn-primary btn-sm mt-3">
                                            + Add Shift
                                        </button>
                                    </div>

                                </div>

                                <button class="btn btn-success mt-4 px-4">
                                    <i class="fa fa-save me-1"></i> Save Details
                                </button>

                            </form>
                        </div>
                    </div>
                </div>

                <!-- Holiday List -->
                <div class="col-md-12">
                    <div class="card shadow-sm border-0 mb-4">
                        <div class="card-body">

                            <h5 class="fw-bold text-primary">Manage Holiday</h5>
                            <hr>

                            <!-- Add Holiday Form -->
                            <form action="holiday-add.php" method="POST" class="mb-3">
                                <h6 class="fw-bold text-primary">Add Holiday</h6>
                                <div class="row g-2">
                                    <div class="col-md-5">
                                        <input type="text" name="holiday_name" class="form-control"
                                            placeholder="Holiday Name" required>
                                    </div>
                                    <div class="col-md-4">
                                        <input type="date" name="holiday_date" class="form-control" required>
                                    </div>
                                    <div class="col-md-3">
                                        <button class="btn btn-sm btn-primary mt-2 mt-lg-0">
                                            <i class="fa fa-plus me-1"></i> Add Holiday
                                        </button>
                                    </div>
                                </div>
                            </form>

                            <hr>

                            <!-- YEAR SELECT -->
                            <?php
                                $currentYear = date("Y");
                                $selectedYear = $_GET['year'] ?? $currentYear;

                                // Get year list from holiday_list table
                                $yearsQuery = $con->query("SELECT DISTINCT YEAR(holiday_date) AS y FROM holiday_list WHERE holiday_for = '$_SESSION[uid]' ORDER BY y DESC");
                            ?>

                            <div class="row mb-3">

                                <!-- YEAR SELECT -->
                                <div class="col-md-6 d-flex align-items-center">
                                    <h6 class="fw-bold text-primary mb-0 me-2">Holiday List :</h6>

                                    <form method="GET" id="yearForm" action="#yearForm" class="me-3">
                                        <select name="year" class="form-select form-select-sm"
                                            onchange="document.getElementById('yearForm').submit()">
                                            <?php 
                                            // Reset the year query pointer (important for reuse)
                                            $yearsQuery->data_seek(0);

                                            while ($yr = $yearsQuery->fetch_assoc()) {
                                                $y = $yr['y'];
                                                $sel = ($y == $selectedYear) ? "selected" : "";
                                                echo "<option value='$y' $sel>$y</option>";
                                            }
                                            ?>
                                        </select>
                                    </form>
                                </div>

                                <!-- TOTAL HOLIDAYS OF SELECTED YEAR -->
                                <div class="col-md-6 d-flex align-items-center justify-content-md-end mt-2 mt-md-0">
                                    <?php
                                        // Count holidays for selected year
                                        $countQ = $con->query("SELECT COUNT(*) AS total_holidays 
                                                            FROM holiday_list 
                                                            WHERE YEAR(holiday_date) = '$selectedYear'");
                                        $countData = $countQ->fetch_assoc();
                                        $totalHolidays = $countData['total_holidays'];
                                    ?>

                                    <h6 class="fw-bold text-dark mb-0">
                                        Total Holidays: <span class="text-primary"><?php echo $totalHolidays; ?></span>
                                    </h6>
                                </div>

                            </div>


                            <hr>

                            <!-- 2-item per row holiday display -->
                            <div class="row g-3">

                                <?php
                                $holidays = $con->query("
                                    SELECT * FROM holiday_list 
                                    WHERE YEAR(holiday_date) = '$selectedYear'
                                    ORDER BY holiday_date ASC
                                ");

                                if ($holidays->num_rows > 0) {
                                    while($h = $holidays->fetch_assoc()) {
                                        echo "
                                        <div class='col-md-6'>
                                            <div class='border rounded p-3 d-flex justify-content-between align-items-center shadow-sm'>
                                                <div>
                                                    <h6 class='fw-bold mb-0'>{$h['holiday_name']}</h6>
                                                    <small class='text-muted'>".$h['holiday_date']."</small>
                                                </div>
                                                <a href='holiday-delete.php?id={$h['id']}' class='btn btn-sm btn-danger'>
                                                    <i class='fa fa-trash'></i>
                                                </a>
                                            </div>
                                        </div>
                                        ";
                                    }
                                } else {
                                    echo "<div class='col-12 text-center text-muted'>No holidays found for $selectedYear</div>";
                                }
                                ?>

                            </div>

                        </div>
                    </div>
                </div>

            </div>

        </div>

        <?php include('./include/footer.php'); ?>
    </div>
</div>
<script>
document.getElementById('addShiftBtn').addEventListener('click', function() {
    const container = document.getElementById('shiftContainer');

    const newRow = document.createElement('div');
    newRow.classList.add('row', 'g-3', 'shift-row');

    newRow.innerHTML = `
        <div class="col-md-5">
            <label class="small">Start Time</label>
            <input type="time" class="form-control form-control-sm" name="shift_start[]">
        </div>

        <div class="col-md-5">
            <label class="small">End Time</label>
            <input type="time" class="form-control form-control-sm" name="shift_end[]">
        </div>

        <div class="col-md-2 d-flex align-items-end">
            <button type="button" class="btn btn-danger btn-sm removeShift">Remove</button>
        </div>
    `;

    container.appendChild(newRow);
});

// Remove Shift
document.addEventListener('click', function(e) {
    if (e.target.classList.contains('removeShift')) {
        e.target.closest('.shift-row').remove();
    }
});
</script>

<?php include('./include/js.php'); ?>