<?php include('./include/header.php'); ?>

<div class="container-fluid p-4">
    <div class="d-flex justify-content-between mb-3">
        <h5 class="fw-bold"><i class="fa fa-balance-scale text-primary me-2"></i>Leave Balances</h5>
    </div>

    <div class="card shadow-sm border-0">
        <div class="card-body table-responsive">
            <table class="table table-hover align-middle">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Employee</th>
                        <th>Casual Leave</th>
                        <th>Sick Leave</th>
                        <th>Last Updated</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $sql = "SELECT lb.*, u.name FROM leave_balance lb JOIN users u ON lb.user_id = u.id ORDER BY u.name ASC";
                    $res = $con->query($sql);
                    $i = 1;
                    while($row = $res->fetch_assoc()){
                        echo "<tr>
                            <td>{$i}</td>
                            <td>{$row['name']}</td>
                            <td>{$row['casual_leave']}</td>
                            <td>{$row['sick_leave']}</td>
                            <td>{$row['updated_at']}</td>
                            <td>
                                <button class='btn btn-sm btn-primary edit-btn' 
                                        data-id='{$row['id']}' 
                                        data-name='{$row['name']}'
                                        data-casual='{$row['casual_leave']}'
                                        data-sick='{$row['sick_leave']}'>
                                    <i class='fa fa-edit'></i> Edit
                                </button>
                            </td>
                        </tr>";
                        $i++;
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Edit Leave Modal -->
<div class="modal fade" id="editLeaveModal" tabindex="-1">
    <div class="modal-dialog">
        <form class="modal-content" method="POST" action="leave_balance_action.php">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title"><i class="fa fa-edit me-2"></i>Edit Leave Balance</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <input type="hidden" name="id" id="leave_id">
                <div class="mb-3">
                    <label>Employee Name</label>
                    <input type="text" id="emp_name" class="form-control" readonly>
                </div>
                <div class="mb-3">
                    <label>Casual Leave</label>
                    <input type="number" name="casual_leave" id="casual_leave" class="form-control" required>
                </div>
                <div class="mb-3">
                    <label>Sick Leave</label>
                    <input type="number" name="sick_leave" id="sick_leave" class="form-control" required>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-success" type="submit" name="update_balance">Save Changes</button>
            </div>
        </form>
    </div>
</div>

<script>
document.querySelectorAll('.edit-btn').forEach(btn => {
    btn.addEventListener('click', () => {
        document.getElementById('leave_id').value = btn.dataset.id;
        document.getElementById('emp_name').value = btn.dataset.name;
        document.getElementById('casual_leave').value = btn.dataset.casual;
        document.getElementById('sick_leave').value = btn.dataset.sick;
        new bootstrap.Modal(document.getElementById('editLeaveModal')).show();
    });
});
</script>

<?php include('./include/footer.php'); ?>