<?php
include('../include/config.php');
session_start();

$id = $_GET['id'];
$status = $_GET['status'];
$admin = $_SESSION['uid'];

// Fetch leave details
$leave = $con->query("SELECT * FROM leaves WHERE leave_id = $id")->fetch_assoc();
$user_id = $leave['user_id'];
$type = $leave['leave_type'];
$start = $leave['start_date'];
$end = $leave['end_date'];
$days = (strtotime($end) - strtotime($start)) / 86400 + 1; // inclusive

$remarks = $status == 'Approved' ? 'Approved by Admin' : 'Rejected by Admin';

// Update leave record
$sql = $con->prepare("UPDATE leaves SET status=?, approved_by=?, remarks=? WHERE leave_id=?");
$sql->bind_param("sisi", $status, $admin, $remarks, $id);
$sql->execute();

// Deduct from leave balance if approved
if ($status == 'Approved') {
    if ($type == 'Casual Leave') {
        $con->query("UPDATE leave_balance SET casual_leave = GREATEST(casual_leave - $days, 0) WHERE user_id=$user_id");
    } elseif ($type == 'Sick Leave') {
        $con->query("UPDATE leave_balance SET sick_leave = GREATEST(sick_leave - $days, 0) WHERE user_id=$user_id");
    }
}

echo "<script>alert('Leave {$status} successfully!');window.location='leaves.php';</script>";
?>