<?php include('./include/header.php'); ?>
<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>
    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>

        <div class="container-fluid p-4" id="body-content">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="fw-bold mb-0">
                    <i class="fa fa-plane-departure me-2 text-success"></i>Leave Requests
                </h5>

                <a href="leave-management.php" class="btn btn-primary btn-sm">
                    <i class="fa fa-cog me-1"></i> All Leaves
                </a>
            </div>

            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>Employee</th>
                                    <th>Type</th>
                                    <th>Duration</th>
                                    <th>Reason</th>
                                    <th>Status</th>
                                    <th>Applied On</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    // using applied_on 
                                    $sql = "SELECT l.*, u.uname 
                                            FROM leaves l
                                            JOIN users u ON l.user_id = u.uid
                                            WHERE u.utype = 'employee'
                                            ORDER BY l.applied_on DESC";
                                    $res = $con->query($sql);
                                    $i = 1;

                                    if ($res && $res->num_rows > 0) {
                                        while ($row = $res->fetch_assoc()) {
                                            $badge = match($row['status']) {
                                                'Approved' => 'success',
                                                'Rejected' => 'danger',
                                                default   => 'warning'
                                            };

                                            // show action buttons only when status is Pending (or your equivalent)
                                            $actions = '';
                                            if ($row['status'] === 'Pending') {
                                                $actions = "
                                                    <a href='leave-action.php?id={$row['leave_id']}&action=approve' class='btn btn-sm btn-success me-1'>
                                                        <i class='fa fa-check'></i>
                                                    </a>
                                                    <a href='leave-action.php?id={$row['leave_id']}&action=reject' class='btn btn-sm btn-danger'>
                                                        <i class='fa fa-times'></i>
                                                    </a>
                                                ";
                                            }

                                            echo "<tr>
                                                <td>{$i}</td>
                                                <td>{$row['uname']}</td>
                                                <td>{$row['leave_type']}</td>
                                                <td>{$row['start_date']} to {$row['end_date']}</td>
                                                <td>{$row['reason']}</td>
                                                <td><span class='badge bg-{$badge}'>{$row['status']}</span></td>
                                                <td>" . date('d M Y', strtotime($row['applied_on'])) . "</td>
                                                <td>{$actions}</td>
                                            </tr>";

                                            $i++;
                                        }
                                    } else {
                                        echo "<tr><td colspan='8' class='text-center text-muted'>No leave requests found.</td></tr>";
                                    }
                                ?>
                            </tbody>

                        </table>
                    </div>
                </div>
            </div>
        </div>

        <?php include('./include/footer.php'); ?>
    </div>
</div>
<?php include('./include/js.php'); ?>