<?php include('./include/header.php'); ?>
<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>
    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>

        <?php
        $employee_id = $_GET['employee_id'] ?? '';
        $from = $_GET['from'] ?? date('Y-m-d');
        $to   = $_GET['to'] ?? date('Y-m-d');

        $emp_sql = mysqli_query($con, "SELECT * FROM users WHERE uid = '$employee_id' ");
        if($emp_row = mysqli_fetch_assoc($emp_sql)){
            $emp_name = $emp_row["uname"];
        }
        ?>

        <div class="container-fluid p-4" id="body-content">

            <h5 class="mb-3">
                <i class="fa fa-map-marker-alt text-danger"></i>
                Location Report
            </h5>

            <div class="alert alert-light border">
                <b>Employee:</b> <?= $emp_name ?: 'All' ?> |
                <b>From:</b> <?= $from ?> |
                <b>To:</b> <?= $to ?>
                <a href="reports.php" class="btn btn-sm btn-outline-secondary float-end">
                    ← Back
                </a>
            </div>

            <div class="row">
                <!-- LEGEND -->
                <div class="col-md-3">
                    <div class="card shadow-sm">
                        <div class="card-header fw-bold">Employees</div>
                        <div class="card-body p-2" id="legendBox">
                            <div class="text-muted small">Click a color to highlight route</div>
                        </div>
                    </div>
                </div>

                <!-- MAP -->
                <div class="col-md-9">
                    <div id="map" style="height:520px;border-radius:10px;"></div>
                </div>
            </div>

        </div>

        <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>


        <script>
        /* ================= CONFIG ================= */
        var COLORS = [
            "#1f77b4", "#ff7f0e", "#2ca02c", "#d62728",
            "#9467bd", "#8c564b", "#e377c2", "#7f7f7f", "#17becf"
        ];

        var routeBounds = {};
        var routeLayers = {};
        var startMarkers = {};
        var endMarkers = {};
        var stopMarkers = {};
        var empColors = {};
        var map;

        /* ================= FETCH DATA ================= */
        var params = new URLSearchParams(window.location.search);

        fetch("ajax/location_report.php?" + params.toString())
            .then(function(res) {
                return res.json();
            })
            .then(drawMap);

        function drawMap(data) {

            if (!data.points || !data.points.length) {
                alert("No location data found");
                return;
            }

            map = L.map("map").setView(
                [data.points[0].latitude, data.points[0].longitude],
                13
            );

            L.tileLayer("https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png")
                .addTo(map);

            /* GROUP BY EMPLOYEE */
            var grouped = {};
            data.points.forEach(function(p) {
                if (!grouped[p.emp_id]) grouped[p.emp_id] = [];
                grouped[p.emp_id].push(p);
            });

            var empIndex = 0;
            var legendBox = document.getElementById("legendBox");

            Object.keys(grouped).forEach(function(empId) {

                var pts = grouped[empId];
                var empName = pts[0].emp_name || ("Employee " + empId);

                if (pts.length < 2) return;

                var color = COLORS[empIndex % COLORS.length];
                empColors[empId] = color;
                empIndex++;

                /* ROUTE */
                var coords = pts.map(function(p) {
                    return [+p.latitude, +p.longitude];
                });

                var poly = L.polyline(coords, {
                    color: color,
                    weight: 4,
                    opacity: 0.9
                }).addTo(map);

                routeLayers[empId] = poly;
                routeBounds[empId] = poly.getBounds();

                /* START */
                var start = pts[0];
                startMarkers[empId] = L.circleMarker(
                        [+start.latitude, +start.longitude], {
                            radius: 7,
                            color: "green",
                            fillOpacity: 1
                        }
                    )
                    .addTo(map)
                    .bindPopup("<b>" + empName + "</b><br>START<br>" + start.created_at);


                /* END */
                var end = pts[pts.length - 1];
                endMarkers[empId] = L.circleMarker(
                        [+end.latitude, +end.longitude], {
                            radius: 7,
                            color: "black",
                            fillOpacity: 1
                        }
                    )
                    .addTo(map)
                    .bindPopup("Employee " + empId + "<br>END<br>" + end.created_at);

                /* STOPS */
                stopMarkers[empId] = [];
                for (var i = 1; i < pts.length; i++) {
                    if (distance(pts[i - 1], pts[i]) <= 20) {
                        stopMarkers[empId].push(
                            L.circle(
                                [+pts[i].latitude, +pts[i].longitude], {
                                    radius: 20,
                                    color: "red",
                                    fillOpacity: 0.4
                                }
                            )
                            .addTo(map)
                        );
                    }
                }

                /* LEGEND ITEM */
                var item = document.createElement("div");
                item.style.cursor = "pointer";
                item.style.marginBottom = "6px";
                item.innerHTML =
                    "<span style='display:inline-block;width:14px;height:14px;background:" + color +
                    ";margin-right:8px;border-radius:3px'></span>" +
                    empName;

                item.onclick = function() {
                    highlightEmployee(empId);
                    focusEmployee(empId);
                };

                legendBox.appendChild(item);
            });

            map.fitBounds(Object.values(routeLayers)[0].getBounds());
        }

        /* ================= HIGHLIGHT ================= */
        function highlightEmployee(empId) {

            Object.keys(routeLayers).forEach(function(id) {

                var active = (id == empId);

                routeLayers[id].setStyle({
                    opacity: active ? 1 : 0.2,
                    weight: active ? 6 : 3
                });

                startMarkers[id].setStyle({
                    opacity: active ? 1 : 0.2
                });
                endMarkers[id].setStyle({
                    opacity: active ? 1 : 0.2
                });

                stopMarkers[id].forEach(function(m) {
                    m.setStyle({
                        opacity: active ? 1 : 0.2
                    });
                });
            });
        }

        /* ================= FOCUS EMPLLOYEE ================= */
        function focusEmployee(empId) {

            if (!routeBounds[empId]) return;

            map.fitBounds(routeBounds[empId], {
                padding: [40, 40],
                animate: true,
                duration: 0.8
            });
        }

        var empKeys = Object.keys(routeLayers);
        if (empKeys.length === 1) {
            focusEmployee(empKeys[0]);
        }


        /* ================= DISTANCE ================= */
        function distance(a, b) {
            var R = 6371000;
            var dLat = (b.latitude - a.latitude) * Math.PI / 180;
            var dLon = (b.longitude - a.longitude) * Math.PI / 180;

            var sinLat = Math.sin(dLat / 2);
            var sinLon = Math.sin(dLon / 2);

            var x =
                Math.pow(sinLat, 2) +
                Math.cos(a.latitude * Math.PI / 180) *
                Math.cos(b.latitude * Math.PI / 180) *
                Math.pow(sinLon, 2);

            return R * 2 * Math.atan2(Math.sqrt(x), Math.sqrt(1 - x));
        }
        </script>

        <?php include('./include/footer.php'); ?>
    </div>
</div>
<?php include('./include/js.php'); ?>