<?php include('./include/header.php'); ?>
<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>
    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>

        <div class="container-fluid p-4" id="body-content">

            <?php
            // CHECK MODES
            $isEdit = isset($_GET['edit']);
            $isView = isset($_GET['view']);
            $uid = $_SESSION['uid'];

            // Fetch edit data if needed
            $editData = null;
            if ($isEdit) {
                $eid = intval($_GET['edit']);
                $editData = mysqli_fetch_assoc(mysqli_query($con,
                    "SELECT * FROM notices WHERE id='$eid' AND notice_for='$uid'"));
            }
            ?>

            <div class="row g-4 mb-4">

                <!-- ADD / EDIT SECTION (Hides on View) -->
                <?php if (!$isEdit && !$isView) { ?>
                <div class="col-lg-12">

                    <div class="card shadow-sm border-0 mb-4">
                        <div class="card-body">

                            <h4 class="mb-2 badge bg-secondary" data-bs-toggle="collapse"
                                data-bs-target="#addNoticeCollapse" style="cursor:pointer;">
                                <?php echo isset($_GET['edit']) ? "Edit Notice" : "Add New Notice"; ?>
                            </h4>

                            <p class="small">
                                <i class="fa fa-hand-point-up"></i>
                                Tap here to add a new notice
                            </p>

                            <div class="collapse" id="addNoticeCollapse">

                                <form method="POST" action="">
                                    <input type="hidden" name="notice_id" value="<?php echo $editData['id'] ?? ''; ?>">

                                    <div class="mb-3">
                                        <label class="form-label">Notice Title</label>
                                        <input type="text" name="notice_title"
                                            value="<?php echo $editData['title'] ?? ''; ?>" class="form-control"
                                            required>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Notice Message</label>
                                        <textarea name="notice_msg" class="form-control" id="content" rows="3" required><?php
                                            echo $editData['message'] ?? '';
                                            ?></textarea>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Publish To</label>
                                        <select name="department_id" class="form-select" required>
                                            <option value="all">All Departments</option>
                                            <?php
                                            $sql = "SELECT * FROM designation ORDER BY d_id ASC";
                                            $run = mysqli_query($con, $sql);
                                            while ($row = mysqli_fetch_assoc($run)) {
                                                $selected = ($editData && $editData['department_id'] == $row["d_id"])
                                                    ? "selected" : "";
                                                echo '<option value="'.$row["d_id"].'" '.$selected.'>'.$row["d_name"].'</option>';
                                            }
                                            ?>
                                        </select>
                                    </div>

                                    <button type="submit" name="publish_notice" class="btn btn-info text-white">
                                        Publish Notice
                                    </button>
                                </form>

                            </div>
                        </div>
                    </div>

                </div>
                <?php } ?>

                <!-- VIEW SECTION -->
                <?php if ($isView) {
                    $vid = intval($_GET['view']);
                    $v = mysqli_fetch_assoc(
                        mysqli_query($con, "SELECT * FROM notices WHERE id='$vid' AND notice_for='$uid'")
                    );

                    if ($v) {
                        echo "
                        <div class='col-lg-12'>
                            <div class='card shadow-sm p-4'>
                                <h4>{$v['title']}</h4>
                                <div class='mt-3'>{$v['message']}</div>
                                <small class='text-muted d-block mt-2'>
                                    <i class='fa fa-clock'></i> {$v['created_at']}
                                </small>

                                <a href='notice.php' class='btn btn-warning mt-3'>Back</a>
                            </div>
                        </div>
                        ";
                    }
                } ?>

                <!-- EDIT SECTION (only Edit Form, no add or list) -->
                <?php if ($isEdit && $editData) { ?>
                <div class="col-lg-12">

                    <div class="card shadow-sm border-0 mb-4">
                        <div class="card-body">

                            <h4 class="mb-3 badge bg-secondary">Edit Notice</h4>

                            <form method="POST" action="">
                                <input type="hidden" name="notice_id" value="<?php echo $editData['id']; ?>">

                                <div class="mb-3">
                                    <label class="form-label">Notice Title</label>
                                    <input type="text" name="notice_title" value="<?php echo $editData['title']; ?>"
                                        class="form-control" required>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Notice Message</label>
                                    <textarea name="notice_msg" id="content" class="form-control" rows="3"
                                        required><?php echo $editData['message']; ?></textarea>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Publish To</label>
                                    <select name="department_id" class="form-select" required>
                                        <option value="all">All Departments</option>
                                        <?php
                                        $dd = mysqli_query($con, "SELECT * FROM designation ORDER BY d_id ASC");
                                        while ($d = mysqli_fetch_assoc($dd)) {
                                            $sel = $editData['department_id'] == $d["d_id"] ? "selected" : "";
                                            echo "<option value='{$d['d_id']}' $sel>{$d['d_name']}</option>";
                                        }
                                        ?>
                                    </select>
                                </div>

                                <button type="submit" name="update_notice" class="btn btn-info text-white">
                                    Update Notice
                                </button>

                                <a href="notice.php" class="btn btn-warning m-2">
                                    Cancel
                                </a>

                            </form>

                        </div>
                    </div>

                </div>
                <?php } ?>

                <!-- NOTICE LIST -->
                <?php if (!$isEdit && !$isView) { ?>

                <?php
                // Pagination settings
                $limit = 10;
                $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
                $page = max($page, 1);
                $offset = ($page - 1) * $limit;

                // total rows
                $total_q = mysqli_query($con,"SELECT COUNT(*) as total FROM notices WHERE notice_for='$uid'");
                $total = mysqli_fetch_assoc($total_q)['total'];
                $totalPages = ceil($total / $limit);

                // fetch records
                $notice_q = mysqli_query($con,
                    "SELECT * FROM notices WHERE notice_for='$uid' ORDER BY id DESC LIMIT $limit OFFSET $offset"
                );
                ?>

                <div class="col-lg-12">
                    <div class="card shadow-sm border-0">
                        <div
                            class="card-header bg-secondary text-white d-flex justify-content-between align-items-center">
                            <h6 class="mb-0">Recent Notices</h6>
                            <span class="badge bg-light text-dark">Total: <?php echo $total; ?></span>
                        </div>

                        <div class="card-body">

                            <?php if (mysqli_num_rows($notice_q) > 0) { ?>

                            <?php while ($n = mysqli_fetch_assoc($notice_q)) {

                                if ($n['department_id'] == 'all') {
                                    $dept = "All Departments";
                                } else {
                                    $d = mysqli_fetch_assoc(
                                        mysqli_query($con,"SELECT d_name FROM designation WHERE d_id='{$n['department_id']}'")
                                    );
                                    $dept = $d['d_name'];
                                }
                            ?>

                            <!-- Single Notice -->
                            <div class='p-3 mb-3 border rounded shadow-sm'>
                                <div class='d-flex justify-content-between'>
                                    <h6 class='mb-1 text-dark fw-bold'><?php echo $n['title']; ?></h6>
                                    <span
                                        class="text-muted small"><?php echo date("d M Y", strtotime($n['created_at'])); ?></span>
                                </div>

                                <p class='small text-muted mb-1'>
                                    <i class='fa fa-building me-1'></i> <?php echo $dept; ?>
                                </p>

                                <div class='mt-2'>
                                    <a href='notice.php?edit=<?php echo $n['id']; ?>&page=<?php echo $page; ?>'
                                        class='btn btn-sm btn-outline-primary'>Edit</a>

                                    <a href='notice.php?view=<?php echo $n['id']; ?>&page=<?php echo $page; ?>'
                                        class='btn btn-sm btn-outline-dark'>View</a>

                                    <a href='notice.php?delete=<?php echo $n['id']; ?>&page=<?php echo $page; ?>'
                                        onclick='return confirm("Delete this notice?")'
                                        class='btn btn-sm btn-outline-danger'>Delete</a>
                                </div>
                            </div>

                            <?php } ?>

                            <?php } else { ?>
                            <p class='text-muted mb-0'>No notices yet.</p>
                            <?php } ?>

                        </div>


                        <!-- PAGINATION -->
                        <?php if($totalPages>1){ ?>
                        <div class="card-footer bg-light">
                            <nav>
                                <ul class="pagination justify-content-center m-0">

                                    <?php if($page > 1){ ?>
                                    <li class="page-item">
                                        <a class="page-link" href="?page=<?php echo $page-1; ?>">Prev</a>
                                    </li>
                                    <?php } ?>

                                    <?php for($i=1;$i<=$totalPages;$i++){ ?>
                                    <li class="page-item <?php if($i==$page) echo 'active'; ?>">
                                        <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                                    </li>
                                    <?php } ?>

                                    <?php if($page < $totalPages){ ?>
                                    <li class="page-item">
                                        <a class="page-link" href="?page=<?php echo $page+1; ?>">Next</a>
                                    </li>
                                    <?php } ?>

                                </ul>
                            </nav>
                        </div>
                        <?php } ?>
                    </div>
                </div>
                <?php } ?>

            </div>

        </div>

        <?php include('./include/footer.php'); ?>
    </div>
</div>

<script src="../assets/vendor/ckeditor.js"></script>
<script>
CKEDITOR.replace('content', {
    height: 300
});
</script>

<?php include('./include/js.php'); ?>

<?php
// ADD notice
if (isset($_POST['publish_notice'])) {

    $title = $_POST['notice_title'];
    $msg = $_POST['notice_msg'];
    $dept = $_POST['department_id'];
    $today = date("Y-m-d H:i:s");

    mysqli_query($con, "
        INSERT INTO notices (title, message, department_id, notice_for, created_at)
        VALUES ('$title', '$msg', '$dept', '$uid', '$today')
    ");

    echo "<script>location.href='notice.php?success=1';</script>";
    exit;
}

// UPDATE notice
if (isset($_POST['update_notice'])) {

    $id = intval($_POST['notice_id']);
    $title = $_POST['notice_title'];
    $msg = $_POST['notice_msg'];
    $dept = $_POST['department_id'];

    mysqli_query($con, "
        UPDATE notices SET title='$title', message='$msg', department_id='$dept'
        WHERE id='$id' AND notice_for='$uid'
    ");

    echo "<script>location.href='notice.php?updated=1';</script>";
    exit;
}

// DELETE notice
if(isset($_GET['delete'])){
    $did = intval($_GET['delete']);
    $page = $_GET['page'] ?? 1;

    mysqli_query($con,"DELETE FROM notices WHERE id='$did' AND notice_for='$uid'");
    echo "<script>location.href='notice.php?page=$page&deleted=1';</script>";
    exit;
}
?>