<?php include('./include/header.php'); ?>
<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>
    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>

        <div class="container-fluid p-4" id="body-content">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="fw-bold mb-0">
                    <i class="fa fa-money-bill-wave me-2 text-success"></i> Payroll & Salary Management
                </h5>
            </div>
            <div class="mb-3">
                <input type="text" id="searchSalary" class="form-control" placeholder="Search employee...">
            </div>

            <?php
            // Fetch employees and their salary info
            $res = $con->query("
                SELECT u.uid, u.uname, u.utypeorg, s.basic_salary, s.hra, s.da, s.ta, s.others, s.work_location, s.latitude, s.longitude
                FROM users u
                LEFT JOIN employee_salary_assigned s ON u.uid = s.user_id
                WHERE u.admin_ref = '{$_SESSION["uref"]}' AND u.utype = 'employee' AND u.emp_status = '1' AND u.udisplay !='disable'
                ORDER BY u.uname ASC
            ");

            echo "<div class='table-responsive'>
            <table class='table table-bordered align-middle'>
            <thead class='table-light'>
                <tr>
                    <th>#</th>
                    <th>Employee</th>
                    <th>Basic</th>
                    <th>Allowances</th>
                    <th>Total</th>
                    <th>Work Location</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>";

            $i = 1;
            while ($row = $res->fetch_assoc()) {
                $basic = $row['basic_salary'];
                $allowances = ($row['hra'] ?? 0) + ($row['da'] ?? 0) + ($row['ta'] ?? 0) + ($row['others'] ?? 0);
                $total = $basic + $allowances;
                $workLoc = $row['work_location'] === 'Office'
                    ? 'Office'
                    : (($row['work_location']) ? 'Other (' . $row['latitude'] . ', ' . $row['longitude'] . ')' : '-');

                // Fetch designation first
                $utypeorg = $row["utypeorg"];
                $find_sql = $con->query("SELECT d_name FROM designation WHERE d_id = '$utypeorg'");
                $find_row = $find_sql->fetch_assoc();
                $designation = $find_row ? $find_row["d_name"] : '-';

                // Now print the row normally
                echo "<tr>
                    <td>{$i}</td>
                    <td>
                        {$row['uname']}
                        <br>
                        <span class='small text-muted'>
                            <b>Designation:</b> {$designation}
                        </span>
                    </td>
                    <td>" . ($basic ? $basic : '-') . "</td>
                    <td>" . ($allowances ? $allowances : '-') . "</td>
                    <td><b>" . ($total ? $total : '-') . "</b></td>
                    <td>{$workLoc}</td>
                    <td>";


                if (empty($basic)) {
                    echo "<button class='btn btn-sm btn-outline-primary' 
                                data-bs-toggle='modal' 
                                data-bs-target='#addSalaryModal' 
                                data-id='{$row['uid']}' 
                                data-name='{$row['uname']}'>
                                <i class='fa fa-plus'></i> Add Salary
                            </button>";
                } else {
                    echo "<button class='btn btn-sm btn-outline-success' 
                                data-bs-toggle='modal' 
                                data-bs-target='#promotionModal' 
                                data-id='{$row['uid']}' 
                                data-name='{$row['uname']}'>
                                <i class='fa fa-arrow-up'></i> Promote / Increment
                            </button>";
                }

                echo "</td></tr>";
                $i++;
            }

            echo "</tbody></table></div>";
            ?>

            <hr class="my-4">
            <h6 class="fw-bold"><i class="fa fa-history text-success"></i> Promotion & Increment History</h6>
            <div class="mb-3">
                <input type="text" id="searchHistory" class="form-control" placeholder="Search employee...">
            </div>

            <div class="table-responsive">
                <table class="table table-bordered table-sm align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>Employee</th>
                            <th>Old Basic</th>
                            <th>New Basic</th>
                            <th>Old Total</th>
                            <th>New Total</th>
                            <th>Promotion Title</th>
                            <th>Remark</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $res2 = $con->query("SELECT h.*, u.uname, u.utypeorg FROM employee_salary_history h 
                                            LEFT JOIN users u ON h.user_id = u.uid WHERE u.admin_ref = '{$_SESSION["uref"]}' AND u.utype = 'employee' AND u.emp_status = '1' AND u.udisplay !='disable'
                                            ORDER BY h.changed_at DESC");
                        if ($res2->num_rows > 0) {
                            $i = 1;
                            while ($r = $res2->fetch_assoc()) {
                                $utypeorg = $r["utypeorg"];
                                $find_sql = $con->query("SELECT d_name FROM designation WHERE d_id = '$utypeorg'");
                                $find_row = $find_sql->fetch_assoc();
                                $designation = $find_row ? $find_row["d_name"] : '-';
                                echo "<tr>
                                    <td>{$i}</td>
                                    <td>{$r['uname']}<br>
                                        <span class='small text-muted'>
                                            <b>Designation:</b> {$designation}
                                        </span></td>
                                    <td>{$r['old_basic']}</td>
                                    <td>{$r['new_basic']}</td>
                                    <td>{$r['old_total']}</td>
                                    <td>{$r['new_total']}</td>
                                    <td>{$r['promotion_title']}</td>
                                    <td>{$r['remark']}</td>
                                    <td>{$r['changed_at']}</td>
                                </tr>";
                                $i++;
                            }
                        } else {
                            echo "<tr><td colspan='9' class='text-center text-muted'>No promotion records yet.</td></tr>";
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- ADD SALARY MODAL -->
        <div class="modal fade" id="addSalaryModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <form method="POST" action="salary_save.php" class="modal-content">
                    <div class="modal-header bg-primary text-white">
                        <h5 class="modal-title">Assign Salary to <span id="salaryEmpName"></span></h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="user_id" id="salaryEmpId">

                        <div class="row g-3">
                            <div class="col-md-4">
                                <label>Basic Salary</label>
                                <input type="number" name="basic_salary" class="form-control" required>
                            </div>
                            <div class="col-md-2">
                                <label>HRA</label>
                                <input type="number" name="hra" class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label>DA</label>
                                <input type="number" name="da" class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label>TA</label>
                                <input type="number" name="ta" class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label>Others</label>
                                <input type="number" name="others" class="form-control">
                            </div>

                            <div class="col-md-4">
                                <label>Work Location Type</label>
                                <select name="work_location" id="workType" class="form-select" required>
                                    <option value="office">Office</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>

                            <div class="col-md-4 latlong-box d-none">
                                <label>Latitude</label>
                                <input type="text" name="latitude" class="form-control">
                            </div>
                            <div class="col-md-4 latlong-box d-none">
                                <label>Longitude</label>
                                <input type="text" name="longitude" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-primary">Save Salary</button>
                    </div>
                </form>
            </div>
        </div>

        <!-- PROMOTION MODAL -->
        <div class="modal fade" id="promotionModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <form method="POST" action="promotion_save.php" class="modal-content">
                    <div class="modal-header bg-success text-white">
                        <h5 class="modal-title">Promotion / Increment for <span id="promoEmpName"></span></h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="user_id" id="promoEmpId">

                        <div class="row g-3">
                            <div class="col-md-4">
                                <label>Previous Basic Salary</label>
                                <input type="number" step="0.01" name="old_basic" id="oldBasic" class="form-control"
                                    readonly>
                            </div>
                            <div class="col-md-4">
                                <label>Increment %</label>
                                <input type="number" step="0.1" id="incrementPercent" class="form-control"
                                    placeholder="e.g. 10">
                            </div>
                            <div class="col-md-4">
                                <label>New Basic Salary</label>
                                <input type="number" step="0.01" name="new_basic" id="newBasic" class="form-control"
                                    required>
                            </div>

                            <div class="col-md-4">
                                <label>Promotion Title</label>
                                <input type="text" name="promotion_title" class="form-control"
                                    placeholder="e.g. Senior Developer">
                            </div>

                            <div class="col-md-8">
                                <label>Remarks / Notes</label>
                                <textarea name="remark" class="form-control" rows="2"
                                    placeholder="Enter remarks or reason"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-success">Save Promotion</button>
                    </div>
                </form>
            </div>
        </div>

        <?php include('./include/footer.php'); ?>
    </div>
</div>


<script>
const addSalaryModal = document.getElementById('addSalaryModal');
addSalaryModal.addEventListener('show.bs.modal', e => {
    const btn = e.relatedTarget;
    document.getElementById('salaryEmpName').textContent = btn.getAttribute('data-name');
    document.getElementById('salaryEmpId').value = btn.getAttribute('data-id');
});

document.getElementById('workType').addEventListener('change', function() {
    document.querySelectorAll('.latlong-box').forEach(box => {
        box.classList.toggle('d-none', this.value !== 'other');
    });
});

const promotionModal = document.getElementById('promotionModal');
promotionModal.addEventListener('show.bs.modal', e => {
    const btn = e.relatedTarget;
    document.getElementById('promoEmpName').textContent = btn.getAttribute('data-name');
    document.getElementById('promoEmpId').value = btn.getAttribute('data-id');

    fetch('get_basic_salary.php?uid=' + btn.getAttribute('data-id'))
        .then(res => res.json())
        .then(data => {
            document.getElementById('oldBasic').value = data.basic_salary || 0;
            document.getElementById('newBasic').value = data.basic_salary || 0;
        });
});

document.getElementById('incrementPercent').addEventListener('input', function() {
    const percent = parseFloat(this.value) || 0;
    const oldBasic = parseFloat(document.getElementById('oldBasic').value) || 0;
    const newBasic = oldBasic + (oldBasic * percent / 100);
    document.getElementById('newBasic').value = newBasic.toFixed(2);
});

// ====== SEARCH FILTER FOR SALARY TABLE ======
document.getElementById("searchSalary").addEventListener("keyup", function() {
    let value = this.value.toLowerCase();
    let rows = document.querySelectorAll("table tbody tr");

    rows.forEach(row => {
        let emp = row.children[1]?.textContent.toLowerCase() || "";
        row.style.display = emp.includes(value) ? "" : "none";
    });
});


// ====== SEARCH FILTER FOR PROMOTION HISTORY TABLE ======
document.getElementById("searchHistory").addEventListener("keyup", function() {
    let value = this.value.toLowerCase();
    let rows = document.querySelectorAll(".table-sm tbody tr");

    rows.forEach(row => {
        let emp = row.children[1]?.textContent.toLowerCase() || "";
        row.style.display = emp.includes(value) ? "" : "none";
    });
});
</script>


<?php include('./include/js.php'); ?>