<?php
include('./include/header.php');

$uid = $_SESSION['uid'];

$user = $con->query("SELECT * FROM users WHERE uid = '$uid'")->fetch_assoc();
?>
<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>
    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>

        <div class="container-fluid p-4" id="body-content">
            <h4 class="fw-bold mb-3">
                <i class="fa fa-user-circle me-2"></i> Admin Profile
            </h4>

            <div class="row">
                <div class="col-12 col-md-4 order-1 order-md-2">

                    <div class="card shadow-sm border-0">
                        <div class="card-body text-center">

                            <img src="<?= $user['ulogo'] ? '../uploads/logo/'.$user['ulogo'] : '../assets/default-user.png' ?>"
                                class="img-fluid rounded mb-3" width="120" height="120">

                            <h5 class="fw-bold"><?= $user['uname'] ?></h5>
                            <p class="text-muted small mb-1"><?= $user['umail'] ?></p>
                            <p class="text-muted small">Phone: <?= $user['uphone'] ?></p>

                            <hr>

                            <h6 class="fw-bold text-primary">Account Details</h6>
                            <p class="small mb-1">User ID: <?= $user['uid'] ?></p>
                            <p class="small mb-1">User Type: <?= $user['utype'] ?></p>
                            <p class="small mb-1">Created: <?= $user['ucreated'] ?></p>

                            <hr>

                            <h6 class="fw-bold text-primary">Location</h6>
                            <p class="small d-none">Lat: <?= $user['latitude'] ?: '-' ?></p>
                            <p class="small d-none">Long: <?= $user['longitude'] ?: '-' ?></p>

                            <?php if ($user['latitude'] && $user['longitude']) { ?>
                            <div id="locationMap" style="height: 250px; width: 100%; border-radius: 10px;" class="mt-3">
                            </div>
                            <?php } else { ?>
                            <p class="text-danger small">No location available.</p>
                            <?php } ?>

                            <hr>

                            <h6 class="fw-bold text-primary">Social Profiles</h6>
                            <div class="d-flex justify-content-center gap-3">
                                <?php if ($user['utwitter']) { ?>
                                <a href="<?= $user['utwitter'] ?>" target="_blank"><i class="fab fa-twitter"></i></a>
                                <?php } ?>
                                <?php if ($user['uinsta']) { ?>
                                <a href="<?= $user['uinsta'] ?>" target="_blank"><i class="fab fa-instagram"></i></a>
                                <?php } ?>
                                <?php if ($user['uyoutube']) { ?>
                                <a href="<?= $user['uyoutube'] ?>" target="_blank"><i class="fab fa-youtube"></i></a>
                                <?php } ?>
                                <?php if ($user['linkdin']) { ?>
                                <a href="<?= $user['linkdin'] ?>" target="_blank"><i class="fab fa-linkedin"></i></a>
                                <?php } ?>
                            </div>

                        </div>
                    </div>

                </div>

                <!-- ================= LEFT SIDE FORM (ON MOBILE BOTTOM) ================= -->
                <div class="col-12 col-md-8 order-2 order-md-1">

                    <form action="profile_update.php" method="POST" enctype="multipart/form-data">

                        <input type="hidden" name="uid" value="<?= $user['uid'] ?>">

                        <div class="card shadow-sm border-0">
                            <div class="card-body">

                                <h5 class="fw-bold text-primary mb-3">Edit Profile</h5>

                                <div class="row g-3">
                                    <!-- PHONE -->
                                    <div class="col-md-6">
                                        <label class="form-label">Phone</label>
                                        <input type="text" name="uphone" class="form-control"
                                            value="<?= $user['uphone'] ?>">
                                    </div>
                                    <!-- EMAIL -->
                                    <div class="col-md-6">
                                        <label class="form-label">Email</label>
                                        <input type="text" name="umail" class="form-control"
                                            value="<?= $user['umail'] ?>">
                                    </div>
                                </div>

                                <hr class="my-4">

                                <!-- SOCIAL -->
                                <h6 class="fw-bold text-primary mb-3">Social Links</h6>
                                <div class="row g-3">

                                    <div class="col-md-6">
                                        <label class="form-label">Twitter</label>
                                        <input type="text" name="utwitter" class="form-control"
                                            value="<?= $user['utwitter'] ?>">
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label">Instagram</label>
                                        <input type="text" name="uinsta" class="form-control"
                                            value="<?= $user['uinsta'] ?>">
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label">YouTube</label>
                                        <input type="text" name="uyoutube" class="form-control"
                                            value="<?= $user['uyoutube'] ?>">
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label">LinkedIn</label>
                                        <input type="text" name="linkdin" class="form-control"
                                            value="<?= $user['linkdin'] ?>">
                                    </div>

                                </div>

                                <hr class="my-4">

                                <!-- ADDRESS -->
                                <h6 class="fw-bold text-primary mb-3">Address</h6>
                                <div class="row g-3">

                                    <div class="col-md-6">
                                        <label class="form-label">Address 1</label>
                                        <input type="text" name="uaddress1" class="form-control"
                                            value="<?= $user['uaddress1'] ?>">
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label">Address 2</label>
                                        <input type="text" name="uaddress2" class="form-control"
                                            value="<?= $user['uaddress2'] ?>">
                                    </div>

                                    <div class="col-md-4 d-none">
                                        <label class="form-label">City</label>
                                        <input type="text" name="city" class="form-control"
                                            value="<?= $user['city'] ?>">
                                    </div>

                                    <div class="col-md-4 d-none">
                                        <label class="form-label">District</label>
                                        <input type="text" name="dist" class="form-control"
                                            value="<?= $user['dist'] ?>">
                                    </div>

                                    <div class="col-md-4 d-none">
                                        <label class="form-label">State</label>
                                        <input type="text" name="state" class="form-control"
                                            value="<?= $user['state'] ?>">
                                    </div>

                                    <div class="col-md-4">
                                        <label class="form-label">PIN</label>
                                        <input type="text" name="pin" class="form-control" value="<?= $user['pin'] ?>">
                                    </div>

                                    <div class="col-md-4">
                                        <label class="form-label">Latitude</label>
                                        <input type="text" name="latitude" class="form-control"
                                            value="<?= $user['latitude'] ?>">
                                    </div>

                                    <div class="col-md-4">
                                        <label class="form-label">Longitude</label>
                                        <input type="text" name="longitude" class="form-control"
                                            value="<?= $user['longitude'] ?>">
                                    </div>

                                </div>

                                <hr class="my-4">

                                <!-- ABOUT -->
                                <h6 class="fw-bold text-primary mb-3">About Section</h6>
                                <div class="row g-3">

                                    <div class="col-12">
                                        <label class="form-label">About</label>
                                        <textarea name="uabout" class="form-control"
                                            rows="3"><?= $user['uabout'] ?></textarea>
                                    </div>

                                    <div class="col-12">
                                        <label class="form-label">Vision</label>
                                        <textarea name="uvission" class="form-control"
                                            rows="3"><?= $user['uvission'] ?></textarea>
                                    </div>

                                </div>

                                <hr class="my-4">

                                <!-- BRANDING -->
                                <h6 class="fw-bold text-primary mb-3">Branding</h6>
                                <div class="row g-3">

                                    <div class="col-md-6">
                                        <label class="form-label">Website URL</label>
                                        <input type="text" name="uweburl" class="form-control"
                                            value="<?= $user['uweburl'] ?>">
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label">Facebook URL</label>
                                        <input type="text" name="ufburl" class="form-control"
                                            value="<?= $user['ufburl'] ?>">
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label">WhatsApp</label>
                                        <input type="text" name="uwhatsapp" class="form-control"
                                            value="<?= $user['uwhatsapp'] ?>">
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label">Logo Upload</label>
                                        <input type="file" name="ulogo" class="form-control">
                                    </div>

                                </div>

                                <hr class="my-4">

                                <div class="text-end">
                                    <button type="submit" class="btn btn-primary px-4">
                                        <i class="fa fa-save me-2"></i> Save Changes
                                    </button>
                                </div>

                            </div>
                        </div>

                    </form>

                </div>

            </div>
            <?php include('./include/footer.php'); ?>
        </div>
    </div>
    <link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
    <script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>

    <?php if ($user['latitude'] && $user['longitude']) { ?>
    <script>
    var lat = <?= $user['latitude'] ?>;
    var lng = <?= $user['longitude'] ?>;

    // Initialize map
    var map = L.map('locationMap').setView([lat, lng], 15);

    // Set map layer
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        maxZoom: 19,
    }).addTo(map);

    // Marker
    L.marker([lat, lng]).addTo(map)
        .bindPopup("User Location")
        .openPopup();
    </script>
    <?php } ?>

    <?php include('./include/js.php'); ?>