<?php
session_start();
include('../config/db.php');   // DB Connection File

// Get user ID
$uid = $_POST['uid'];

// Fetch old data
$old = $con->query("SELECT ulogo FROM users WHERE uid='$uid'")->fetch_assoc();

// ========================
// SANITIZE INPUTS
// ========================
$uphone    = $con->real_escape_string($_POST['uphone']);
$umail     = $con->real_escape_string($_POST['umail']);
$utwitter  = $con->real_escape_string($_POST['utwitter']);
$uinsta    = $con->real_escape_string($_POST['uinsta']);
$uyoutube  = $con->real_escape_string($_POST['uyoutube']);
$linkdin   = $con->real_escape_string($_POST['linkdin']);
$uaddress1 = $con->real_escape_string($_POST['uaddress1']);
$uaddress2 = $con->real_escape_string($_POST['uaddress2']);
$city      = $con->real_escape_string($_POST['city']);
$dist      = $con->real_escape_string($_POST['dist']);
$state     = $con->real_escape_string($_POST['state']);
$pin       = $con->real_escape_string($_POST['pin']);
$latitude  = $con->real_escape_string($_POST['latitude']);
$longitude = $con->real_escape_string($_POST['longitude']);
$uabout    = $con->real_escape_string($_POST['uabout']);
$uvission  = $con->real_escape_string($_POST['uvission']);
$uweburl   = $con->real_escape_string($_POST['uweburl']);
$ufburl    = $con->real_escape_string($_POST['ufburl']);
$uwhatsapp = $con->real_escape_string($_POST['uwhatsapp']);


// ==============================================
// HANDLE LOGO UPLOAD + COMPRESS TO WEBP
// ==============================================

$newLogoName = $old['ulogo'];  // default (if user does not upload new logo)

if (!empty($_FILES['ulogo']['name'])) {

    $fileTmp  = $_FILES['ulogo']['tmp_name'];
    $fileInfo = getimagesize($fileTmp);

    if ($fileInfo !== false) {

        $uploadPath = "../uploads/logo/";
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        // New filename
        $newLogoName = "logo_" . time() . "_" . rand(1000, 9999) . ".webp";
        $finalPath = $uploadPath . $newLogoName;

        // Get mime type for creating image resource
        $mime = $fileInfo['mime'];

        switch ($mime) {
            case 'image/jpeg':
                $image = imagecreatefromjpeg($fileTmp);
                break;
            case 'image/png':
                $image = imagecreatefrompng($fileTmp);
                imagepalettetotruecolor($image);
                imagealphablending($image, true);
                imagesavealpha($image, true);
                break;
            case 'image/webp':
                $image = imagecreatefromwebp($fileTmp);
                break;
            default:
                $image = false;
        }

        if ($image !== false) {
            // Compress to webp (0–100)
            imagewebp($image, $finalPath, 70);
            imagedestroy($image);

            // Delete old logo if exists
            if (!empty($old['ulogo']) && file_exists("../uploads/logo/" . $old['ulogo'])) {
                unlink("../uploads/logo/" . $old['ulogo']);
            }
        }
    }
}



// =====================================================
// UPDATE QUERY
// =====================================================
$update = $con->query("
    UPDATE users SET 
        uphone='$uphone',
        umail='$umail',
        utwitter='$utwitter',
        uinsta='$uinsta',
        uyoutube='$uyoutube',
        linkdin='$linkdin',
        uaddress1='$uaddress1',
        uaddress2='$uaddress2',
        city='$city',
        dist='$dist',
        state='$state',
        pin='$pin',
        latitude='$latitude',
        longitude='$longitude',
        uabout='$uabout',
        uvission='$uvission',
        uweburl='$uweburl',
        ufburl='$ufburl',
        uwhatsapp='$uwhatsapp',
        ulogo='$newLogoName'
    WHERE uid='$uid'
");

if ($update) {
    echo "<script>
        alert('Profile Updated Successfully!');
        window.location.href='profile.php';
    </script>";
} else {
    echo "<script>
        alert('Something went wrong!');
        window.location.href='profile.php';
    </script>";
}

?>