<?php include('./include/header.php'); ?>
<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>
    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>

        <div class="container-fluid p-4" id="body-content">
            <div class="card shadow-sm border-0 mb-4">
                <div class="card-body">
                    <h6 class="card-title mb-3 text-secondary">
                        <i class="fa fa-filter me-1 text-muted"></i> Employee Reports
                    </h6>

                    <div class="row g-3 align-items-end">

                        <?php include("include/report_filters.php"); ?>

                        <div id="reportResult" class="mt-3"></div>
                    </div>
                </div>
            </div>
        </div>

        <?php include('./include/footer.php'); ?>
    </div>
</div>

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

<script>
let currentReport = "attendance";
let locationMap = null;

function loadReport(type) {
    currentReport = type;

    const form = document.getElementById('reportFilterForm');
    const params = new URLSearchParams(new FormData(form));

    fetch(`ajax/${type}_report.php?` + params)
        .then(res => res.text())
        .then(html => {

            // destroy old map ONLY if it is a Leaflet map
            if (window.locationMap && typeof window.locationMap.remove === "function") {
                window.locationMap.remove();
                window.locationMap = null;
            }

            document.getElementById("reportResult").innerHTML = html;
        });
}

function switchTab(btn) {
    document.querySelectorAll(".tab-btn").forEach(t => t.classList.remove("active"));
    btn.classList.add("active");
    loadReport(btn.dataset.type);
}

window.addEventListener("DOMContentLoaded", () => {
    const firstTab = document.querySelector('.tab-btn[data-type="attendance"]');
    if (firstTab) {
        firstTab.classList.add("active");
        loadReport("attendance");
    }
});

document.getElementById("reportFilterForm")
    .addEventListener("change", () => loadReport(currentReport));
</script>

<script>
/* =========================
   HANDLE PRINT SLIP BUTTON
========================= */
$(document).on('click', '.print-btn', function() {

    const salaryId = $(this).data('id');
    const empName = $(this).data('empname');

    $('#printContent')
        .data('empname', empName)
        .html('<div class="text-center text-muted my-4">Loading…</div>');

    const modal = new bootstrap.Modal(document.getElementById('printModal'));
    modal.show();

    $.get('ajax/get-salary-slip.php', {
            id: salaryId
        })
        .done(function(data) {
            $('#printContent').html(data);
        })
        .fail(function() {
            $('#printContent').html(
                '<p class="text-danger text-center">Unable to load salary slip.</p>'
            );
        });
});

/* =========================
   PRINT ACTION
========================= */
$(document).on('click', '#printBtn', function() {

    const originalTitle = document.title;
    const employeeName = $('#printContent').data('empname') || 'Employee';

    // Try to extract month/year from slip
    const periodText = $('#printContent')
        .find('[data-slip-period]')
        .first()
        .text() || 'Salary Slip';

    document.title = `Pay Slip - ${employeeName} - ${periodText}`;

    const printHTML = document.getElementById('printContent').innerHTML;
    const originalHTML = document.body.innerHTML;

    document.body.innerHTML = printHTML;
    window.print();

    // Restore page
    document.body.innerHTML = originalHTML;
    document.title = originalTitle;
    location.reload();
});

function openLocationReport() {
    const form = document.getElementById("reportFilterForm");
    const params = new URLSearchParams(new FormData(form));
    window.location.href = "location_report.php?" + params.toString();
}
</script>

<?php include('./include/js.php'); ?>