<?php
session_start();
include "../config/db.php";

if (!isset($_GET['id'])) {
    die("Invalid Request");
}

$id = intval($_GET['id']);

$q = mysqli_query($con,"
    SELECT r.*, u.uname, u.umail
    FROM resignations r
    JOIN users u ON u.uid = r.user_id
    WHERE r.id = '$id'
");

if (!$row = mysqli_fetch_assoc($q)) {
    die("Record not found");
}

$fullText  = "<strong style='margin-top:10px;'>Reason:</strong>\n".$row['reason']."\n";
$fullText .= "<strong>Response:</strong>\n".($row['response_message'] ?: 'No response provided.')."\n\n";
$fullText .= "Approval & Declaration:\n";
$fullText .= "This document confirms that the resignation request submitted by ";
$fullText .= $row['uname']." has been ".$row['status'].".\n";
$fullText .= "This is a system-generated document and does not require physical verification.";

function splitTextByLength($text, $maxLength = 2030)
{
    $words = preg_split('/(\s+)/', $text, -1, PREG_SPLIT_DELIM_CAPTURE);
    $pages = [];
    $currentPage = '';

    foreach ($words as $word) {
        if (mb_strlen($currentPage . $word) <= $maxLength) {
            $currentPage .= $word;
        } else {
            $pages[] = trim($currentPage);
            $currentPage = $word;
        }
    }

    if (trim($currentPage) !== '') {
        $pages[] = trim($currentPage);
    }

    return $pages;
}

$chunks = splitTextByLength($fullText, 2020);
$totalPages = count($chunks);

?>


<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Resignation - <?php echo $row['uname']; ?></title>

    <style>
    @page {
        size: A4;
        margin: 0;
    }

    body {
        margin: 0;
        font-family: Arial, Helvetica, sans-serif;
        -webkit-print-color-adjust: exact;
        print-color-adjust: exact;
    }

    /* TEMPLATE BACKGROUND */
    body::before {
        content: "";
        position: fixed;
        top: 0;
        left: 0;
        width: 210mm;
        height: 297mm;
        background: url(../../HRM/assets/img/print/temp-night.webp) no-repeat center center;
        background-size: 100% 100%;
        z-index: -1;
    }

    /* CONTENT AREA */
    .content {
        padding: 140px 40px;
        box-sizing: border-box;
        page-break-after: always;
    }

    /* LAST PAGE */
    .content:last-child {
        page-break-after: auto;
    }

    h4 {
        text-align: center;
        margin: 40px 0 20px;
    }

    .label {
        font-weight: bold;
    }

    .block {
        margin-bottom: 20px;
        line-height: 1.6;
    }

    .box {
        margin-bottom: 30px;
        margin-top: 30px;
    }

    /* SIGNATURE AT END */
    .signature {
        margin-top: 80px;
        text-align: right;
    }

    .signature img {
        width: 160px;
        display: block;
        margin-left: auto;
    }
    </style>

</head>

<body>

    <?php foreach ($chunks as $pageIndex => $pageText): ?>

    <div class="content">

        <?php if ($pageIndex == 0): ?>
        <!-- SUMMARY ONLY ON FIRST PAGE -->
        <h4 style="margin-top:0;">Summary</h4>

        <div style="display:flex;">
            <div style="width:50%;">
                <div style="margin-bottom:0;" class="block"><span class="label">Name:</span> <?= $row['uname']; ?></div>
                <div style="margin-bottom:0;" class="block"><span class="label">Email:</span> <?= $row['umail']; ?>
                </div>
                <div style="margin-bottom:0;" class="block"><span class="label">Status:</span> <?= $row['status']; ?>
                </div>
            </div>

            <div style="width:50%;">
                <div style="margin-bottom:0;" class="block"><span class="label">Apply Date:</span>
                    <?= $row['resign_date']; ?></div>
                <div style="margin-bottom:0;" class="block"><span class="label">Last Working Day:</span>
                    <?= $row['last_working_day']; ?></div>
            </div>
        </div>
        <?php endif; ?>

        <!-- PAGE CONTENT -->
        <div class="box">
            <?= $pageText; ?>
        </div>

        <?php if ($pageIndex == $totalPages - 1): ?>
        <!-- SIGNATURE ONLY ON LAST PAGE -->
        <div class="signature">
            <img src="../../HRM/assets/img/print/syd-sig1.png">
            <div>_________________</div>
            <div>Authorized Signatory</div>
        </div>
        <?php endif; ?>

    </div>

    <?php endforeach; ?>

    <script>
    window.onload = function() {
        window.print();
    };
    window.onafterprint = function() {
        window.close();
    };
    </script>

</body>


</html>