<?php
include("./include/header.php");
$org_id = $_SESSION['uid'];

// ---------------- FILTERS ----------------
$where = "WHERE r.org_id='$org_id'";
$status = "";
$user = "";

if (isset($_GET['status']) && $_GET['status'] != '') {
    $status = $_GET['status'];
    $where .= " AND r.status='$status'";
}

if (isset($_GET['user']) && $_GET['user'] != '') {
    $user = $_GET['user'];
    $where .= " AND u.uname LIKE '%$user%'";
}

// ---------------- PAGINATION ----------------
$limit = 10;
$page = isset($_GET['page']) ? $_GET['page'] : 1;
$offset = ($page - 1) * $limit;

$totalQuery = mysqli_query($con,
    "SELECT r.id FROM resignations r 
     JOIN users u ON u.uid=r.user_id 
     $where"
);

$totalRows = mysqli_num_rows($totalQuery);
$totalPages = ceil($totalRows / $limit);

// Approve action
if (isset($_POST['approve'])) {
    $id  = intval($_POST['id']);
    $msg = mysqli_real_escape_string($con, $_POST['msg']);

    mysqli_query($con,
        "UPDATE resignations SET 
            status='Approved',
            response_message='$msg',
            updated_at=NOW()
         WHERE id='$id' AND org_id='$org_id'"
    );
    ?>
<script>
window.location = 'resignation.php';
</script>
<?php
}

// Reject action
if (isset($_POST['reject'])) {
    $id  = intval($_POST['id']);
    $msg = mysqli_real_escape_string($con, $_POST['msg']);

    mysqli_query($con,
        "UPDATE resignations SET 
            status='Rejected',
            response_message='$msg',
            updated_at=NOW()
         WHERE id='$id' AND org_id='$org_id'"
    );
    ?>
<script>
window.location = 'resignation.php';
</script>
<?php
}

// MAIN QUERY
$q = mysqli_query($con,
    "SELECT r.*,u.uname FROM resignations r
     JOIN users u ON u.uid=r.user_id
     $where
     ORDER BY r.id DESC
     LIMIT $offset,$limit"
);
?>

<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>
    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>

        <div class="container-fluid p-4" id="body-content">
            <h4 class="mb-4">Resignation Requests</h4>

            <!-- FILTER FORM -->
            <form class="row g-2 mb-3">
                <div class="col-md-3">
                    <input type="text" name="user" class="form-control form-control-sm" placeholder="Search by User"
                        value="<?= $user ?>">
                </div>

                <div class="col-md-3">
                    <select name="status" class="form-select form-select-sm">
                        <option value="">All Status</option>
                        <option <?= $status=='Pending'?'selected':'' ?>>Pending</option>
                        <option <?= $status=='Approved'?'selected':'' ?>>Approved</option>
                        <option <?= $status=='Rejected'?'selected':'' ?>>Rejected</option>
                    </select>
                </div>

                <div class="col-md-2">
                    <button class="btn btn-primary btn-sm w-100">Filter</button>
                </div>
            </form>

            <table class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>User</th>
                        <th>Apply Date</th>
                        <th>LWD</th>
                        <th>Reason</th>
                        <th>Status</th>
                        <th>Response</th>
                        <th>Action</th>
                    </tr>
                </thead>

                <tbody>
                    <?php
                    $modalHtml = ""; // store modals here

                    while ($r = mysqli_fetch_assoc($q)) {

                        echo "
                        <tr>
                            <td>{$r['uname']}</td>
                            <td>{$r['resign_date']}</td>
                            <td>{$r['last_working_day']}</td>
                            <td>{$r['reason']}</td>";

                        if ($r['status'] == "Pending")
                            echo "<td><span class='badge bg-warning text-dark'>Pending</span></td>";
                        elseif ($r['status'] == "Approved")
                            echo "<td><span class='badge bg-success'>Approved</span></td>";
                        else
                            echo "<td><span class='badge bg-danger'>Rejected</span></td>";

                        echo "
                            <td>{$r['response_message']}</td>
                            <td>
                                <button class='btn btn-sm btn-dark'
                                    data-bs-toggle='modal'
                                    data-bs-target='#view{$r['id']}'>
                                    View
                                </button>
                                <a href='resignation-download.php?id=$r[id]'
                                class='btn btn-sm btn-primary'
                                target='_blank'>
                                Download
                                </a>
                            </td>
                        </tr>";

                        // modal stored separately
                        $modalHtml .= "
                        <div class='modal fade' id='view{$r['id']}'>
                            <div class='modal-dialog'>
                                <form method='POST' class='modal-content'>
                                    <div class='modal-header'>
                                        <h5>Resignation Response</h5>
                                    </div>
                                    <div class='modal-body'>
                                        <textarea name='msg' id='response' class='form-control ckeditor'
                                            placeholder='Write response'></textarea>
                                        <input type='hidden' name='id' value='{$r['id']}'>
                                    </div>
                                    <div class='modal-footer'>
                                        <button name='approve' class='btn btn-success'>Approve</button>
                                        <button name='reject' class='btn btn-danger'>Reject</button>
                                        <button class='btn btn-secondary' data-bs-dismiss='modal'>Close</button>
                                    </div>
                                </form>
                            </div>
                        </div>";
                    }
                    ?>
                </tbody>
            </table>

            <!-- pagination -->
            <nav>
                <ul class="pagination">
                    <?php
                    for ($i=1; $i <= $totalPages; $i++) {
                        $active = ($i==$page) ? "active" : "";
                        echo "<li class='page-item $active'>
                                <a class='page-link'
                                href='?page=$i&status=$status&user=$user'>$i</a>
                            </li>";
                    }
                    ?>
                </ul>
            </nav>

        </div>

        <?php include('./include/footer.php'); ?>
    </div>
</div>

<?php
// DRAW ALL MODALS OUTSIDE TABLE
echo $modalHtml;
?>
<script src="../assets/vendor/ckeditor.js"></script>
<script>
CKEDITOR.replace('response');
</script>

<?php include('./include/js.php'); ?>