<?php include('./include/header.php'); ?>
<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>
    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>

        <div class="container-fluid p-4" id="body-content">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="fw-bold mb-0"><i class="fa fa-money-bill me-2 text-success"></i>Employee Salary Management
                </h5>
                <a href="salary_add.php" class="btn btn-sm btn-primary"><i class="fa fa-plus"></i> Add Salary</a>
            </div>

            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>Employee</th>
                                    <th>Basic</th>
                                    <th>HRA</th>
                                    <th>DA</th>
                                    <th>TA</th>
                                    <th>Total</th>
                                    <th>Updated</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $sql = "SELECT s.*, u.uname FROM salary_structure s 
                                            JOIN users u ON s.user_id = u.uid
                                            ORDER BY s.last_updated DESC";
                                    $res = $con->query($sql);
                                    $i = 1;

                                    if ($res->num_rows > 0) {
                                    while ($row = $res->fetch_assoc()) {
                                        echo "<tr>
                                        <td>{$i}</td>
                                        <td>{$row['uname']}</td>
                                        <td>{$row['basic_salary']}</td>
                                        <td>{$row['hra']}</td>
                                        <td>{$row['da']}</td>
                                        <td>{$row['ta']}</td>
                                        <td><b>{$row['total_salary']}</b></td>
                                        <td>" . date('d M Y', strtotime($row['last_updated'])) . "</td>
                                        <td>
                                            <a href='salary_edit.php?id={$row['salary_id']}' class='btn btn-sm btn-warning'>
                                            <i class='fa fa-edit'></i>
                                            </a>
                                            <a href='promotion_add.php?uid={$row['user_id']}' class='btn btn-sm btn-success'>
                                            <i class='fa fa-arrow-up'></i>
                                            </a>
                                        </td>
                                        </tr>";
                                        $i++;
                                    }
                                    } else {
                                    echo "<tr><td colspan='9' class='text-center text-muted'>No salary records found.</td></tr>";
                                    }
                                    ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <?php include('./include/footer.php'); ?>
    </div>
</div>
<?php include('./include/js.php'); ?>