<?php
session_start();
include('../config/db.php');

$uid = $_SESSION['uid']; // store the user ID

// Save helper
function saveSetting($key, $value, $uid) {
    global $con;

    $key   = $con->real_escape_string($key);
    $value = $con->real_escape_string($value);
    $uid   = (int)$uid;

    // ✅ prevents duplicate key error
    $con->query("
        INSERT INTO leave_settings (setting_key, setting_value, setting_for)
        VALUES ('$key', '$value', '$uid')
        ON DUPLICATE KEY UPDATE
            setting_value = VALUES(setting_value),
            setting_for   = VALUES(setting_for)
    ");
}

// ===============================
// ✅ WEEKLY OFF
// ===============================
$weekly_off = isset($_POST['weekly_off']) ? implode(',', $_POST['weekly_off']) : '';
saveSetting("weekly_off", $weekly_off, $uid);

// ===============================
// ✅ HALF DAY
// ===============================
$half_day = isset($_POST['is_half_day']) ? implode(',', $_POST['is_half_day']) : '0';
saveSetting("is_half_day", $half_day, $uid);

// ===============================
// ✅ WORK SHIFTS (MULTIPLE)
// ===============================
$shift_start = $_POST['shift_start'] ?? [];
$shift_end   = $_POST['shift_end'] ?? [];

$shifts = [];

for ($i = 0; $i < count($shift_start); $i++) {
    if (!empty($shift_start[$i]) && !empty($shift_end[$i])) {
        $shifts[] = [
            "start" => $shift_start[$i],
            "end"   => $shift_end[$i]
        ];
    }
}

saveSetting("work_shifts", json_encode($shifts), $uid);

// ===============================
// ✅ REDIRECT
// ===============================
header("Location: leave-management.php?msg=weekly_saved");
exit;