<?php
$fullDateTime = $row["ws_date"];
$dateOnly = date("d-m-Y", strtotime($fullDateTime));

$stime = date("h:i:s A", strtotime($row["ws_startTime"]));
$etime = date("h:i:s A", strtotime($row["ws_endTime"]));

// DateTime comparison
$currentDateTime = new DateTime();
$sessionStartDateTime = new DateTime($fullDateTime . ' ' . $row["ws_startTime"]);
$sessionEndDateTime = new DateTime($fullDateTime . ' ' . $row["ws_endTime"]);

$wl_sql = mysqli_query($con, "SELECT * FROM work_list WHERE wl_ws_id = '{$row['ws_id']}'");
$total = 0;
$completed = 0;

while ($wl_r = mysqli_fetch_assoc($wl_sql)) {
    $total++;
    if ($wl_r['wl_status'] == 1) $completed++;
}

if ($total == 0) {
    $workStatus = "Incomplete";
} elseif ($completed == $total) {
    $workStatus = "Completed";
} elseif ($completed > 0) {
    $workStatus = "Partially Completed";
} else {
    $workStatus = "Incomplete";
}

if ($currentDateTime < $sessionStartDateTime) {
    $status = "Upcoming";
} elseif ($currentDateTime >= $sessionStartDateTime && $currentDateTime <= $sessionEndDateTime) {
    $status = "Ongoing";
} else {
    $status = $workStatus;
}
?>

<div class="accordion mb-3">
    <div class="heading">
        <div class="row align-items-center">
            <div class="col-10">
                <h5 class="m-0">
                    <?= $dateOnly . ' (' . $stime . ' - ' . $etime . ')' ?>
                    <span class="badge badge-primary"><?= $status ?></span>
                    <?php if(!empty($row["ws_workPercent"])){ ?>
                    <span class="badge badge-primary">Work Percent: <?= $row["ws_workPercent"] ?>%</span>
                    <?php } ?>
                </h5>
            </div>
            <div class="col-2">
                <div class="d-flex justify-content-end">
                    <a href="<?= $url; ?>&edit_id=<?= $row["ws_id"]; ?>" class="btn btn-success btn-sm me-2"
                        title="Click to Edit">
                        <i class="fa fa-pencil-square" aria-hidden="true"></i>
                    </a>
                    <a href="<?= $url; ?>&del_id=<?= $row["ws_id"]; ?>" class="delete btn btn-danger btn-sm"
                        title="Click to Delete">
                        <i class="fa fa-trash" aria-hidden="true"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="contents">
        <div class="d-flex justify-content-end mb-2">
            <button type="button" class="btn btn-primary btn-sm openRemarkModal" data-bs-toggle="modal"
                data-bs-target="#remarkModal" data-id="<?= $row['ws_id']; ?>">
                Submit Remark
            </button>
        </div>

        <?php
        $wl_sql = mysqli_query($con, "SELECT * FROM work_list WHERE wl_ws_id = '{$row['ws_id']}'");
        $a = 1;
        while ($wl_row = mysqli_fetch_assoc($wl_sql)) {
        ?>
        <div class="row justify-content-between">
            <div class="col-10">
                <h5>
                    <strong><?= $a . ') '; ?></strong> <?= $wl_row["wl_title"]; ?>
                    <?php if ($wl_row["wl_status"] == '1') { ?>
                    <span class="badge badge-success">Completed</span>
                    <?php } else { ?>
                    <span class="badge badge-warning">Pending</span>
                    <?php } ?>
                </h5>
            </div>
            <div class="col-2">
                <div class="d-flex justify-content-end">
                    <a href="<?= $url; ?>&edit_wl_id=<?= $wl_row["wl_id"]; ?>" class="my-2 btn btn-success btn-sm">
                        <i class="fa fa-pencil-square" aria-hidden="true"></i>
                    </a>
                    <a href="<?= $url; ?>&del_wl_id=<?= $wl_row["wl_id"]; ?>" class="delete m-2 btn btn-danger btn-sm">
                        <i class="fa fa-trash" aria-hidden="true"></i>
                    </a>
                </div>
            </div>
        </div>
        <div class="mb-2" id="imageDisplay"><?= $wl_row["wl_des"]; ?></div>
        <hr>
        <?php
            $a++;
        }
        ?>
    </div>
</div>