import sys
import face_recognition

img1 = face_recognition.load_image_file(sys.argv[1])
img2 = face_recognition.load_image_file(sys.argv[2])

enc1 = face_recognition.face_encodings(img1)
enc2 = face_recognition.face_encodings(img2)

if not enc1 or not enc2:
    print("FAIL")
    sys.exit()

match = face_recognition.compare_faces([enc1[0]], enc2[0], tolerance=0.45)
print("MATCH" if match[0] else "FAIL")
