<?php
require_once "../config/db.php";
require_once "../config/functions.php";

$action = $_POST['action'] ?? '';

if ($action == 'save_token') {
    session_start();
    $uid = $_SESSION['uid'];
    $token = $_POST['token'];

    $stmt = $con->prepare("UPDATE users SET fcm_token = ? WHERE id = ?");
    $stmt->bind_param("si", $token, $uid);
    $stmt->execute();
    echo "Token saved";
    exit;
}

if ($action == 'send_notification') {
    $token = $_POST['token'];
    $title = $_POST['title'];
    $body = $_POST['body'];

    $serverKey = "YOUR_SERVER_KEY"; // Firebase server key
    $data = [
        "to" => $token,
        "notification" => [
            "title" => $title,
            "body" => $body,
            "icon" => "/assets/img/icons/notification.png"
        ]
    ];

    $headers = [
        "Authorization: key=$serverKey",
        "Content-Type: application/json"
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/fcm/send");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    $result = curl_exec($ch);
    curl_close($ch);

    echo $result;
}
?>