<?php
include_once("db.php");
include_once("constants.php");

// ======================================================
// BASIC HELPERS
// ======================================================

function redirect($url) {
    echo "<script>window.location.href='$url';</script>";
    exit;
}

function clean($value) {
    global $con;
    return mysqli_real_escape_string($con, trim(strip_tags($value)));
}

function showAlert($msg, $type = 'danger') {
    echo "<div class='alert alert-$type text-center small'>$msg</div>";
}

// ======================================================
// USER FUNCTIONS
// ======================================================

function getUserByPhone($phone) {
    global $con;
    $stmt = $con->prepare("SELECT * FROM users WHERE uphone = ?");
    $stmt->bind_param("s", $phone);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result->fetch_assoc();
}

function verifyPassword($inputPass, $dbPass) {
    return $inputPass == $dbPass;
}

function logAction($user_id, $action, $details = '') {
    global $con;
    $ip = $_SERVER['REMOTE_ADDR'];

    $stmt = $con->prepare("INSERT INTO audit_log (user_id, action, details, ip_address) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("isss", $user_id, $action, $details, $ip);
    $stmt->execute();
}

// ======================================================
// SECURITY HELPERS
// ======================================================

function secureSessionStart() {
    session_start();
    if (!isset($_SESSION['initiated'])) {
        session_regenerate_id(true);
        $_SESSION['initiated'] = true;
    }

    // Session timeout check
    if (isset($_SESSION['LAST_ACTIVITY']) && (time() - $_SESSION['LAST_ACTIVITY'] > SESSION_TIMEOUT)) {
        session_unset();
        session_destroy();
        header("Location: ../auth/login.php?session=expired");
        exit;
    }
    $_SESSION['LAST_ACTIVITY'] = time();
}

// ======================================================
// END OF FILE
// ======================================================


// ======================================================
// Admin functions
// ======================================================


?>