<?php
session_start();
include "../../config/db.php";

if (!isset($_SESSION['uid'])) {
    exit;
}

$uid = $_SESSION['uid'];
$where = "a.user_id = $uid";

if (!empty($_GET['from']) && !empty($_GET['to'])) {
    $from = $_GET['from'];
    $to   = $_GET['to'];
    $where .= " AND a.date BETWEEN '$from' AND '$to'";
}

$q = mysqli_query($con,"
    SELECT 
        a.date,
        a.check_in,
        a.check_out,
        a.status,
        a.overtime_minutes
    FROM attendance a
    WHERE $where
    ORDER BY a.date DESC
");

$filename = "my_attendance_" . date("Ymd_His") . ".csv";

header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename='.$filename);
header('Pragma: no-cache');
header('Expires: 0');

$output = fopen('php://output', 'w');

// Header row
fputcsv($output, ['Date', 'Check In', 'Check Out', 'Status', 'OT (min)']);

while ($row = mysqli_fetch_assoc($q)) {
    fputcsv($output, [
        $row['date'],
        $row['check_in'] ?: '-',
        $row['check_out'] ?: '-',
        $row['status'],
        $row['overtime_minutes']
    ]);
}

fclose($output);
exit;
