<?php
session_start();
include "../../config/db.php";

if (!isset($_SESSION['uid'])) {
    die("Unauthorized");
}

$uid = $_SESSION['uid'];

/* =========================
   FETCH USER
========================= */
$userQ = mysqli_query($con,"
    SELECT uname, emp_shift
    FROM users
    WHERE uid = '$uid'
");
$user = mysqli_fetch_assoc($userQ);

/* =========================
   FILTER
========================= */
$where = "a.user_id = $uid";

$fromText = $toText = '';

if (!empty($_GET['from']) && !empty($_GET['to'])) {
    $from = $_GET['from'];
    $to   = $_GET['to'];
    $fromText = date("d M Y", strtotime($from));
    $toText   = date("d M Y", strtotime($to));
    $where .= " AND a.date BETWEEN '$from' AND '$to'";
}

/* =========================
   ATTENDANCE
========================= */
$q = mysqli_query($con,"
    SELECT *
    FROM attendance a
    WHERE $where
    ORDER BY a.date ASC
");
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Attendance Report</title>

    <style>
    body {
        margin: 0;
        font-family: Arial, Helvetica, sans-serif;
        -webkit-print-color-adjust: exact;
        print-color-adjust: exact;
    }

    .report-wrapper {
        min-height: 94.55vh;
        background-image: url('../../assets/img/print/temp-night.webp') !important;
        background-repeat: no-repeat !important;
        background-size: 100% 100% !important;
        background-position: center !important;
        padding: 30px !important;
    }

    .report-box {
        max-width: 900px !important;
        margin: 0 auto !important;
        padding: 80px 0 20px 0 !important;
    }

    h3 {
        text-align: center;
        margin-bottom: 5px;
    }

    .sub-title {
        text-align: center;
        margin-bottom: 20px;
        font-size: 14px;
    }

    .table {
        width: 100%;
        border-collapse: collapse;
        font-size: 13px;
    }

    .table th,
    .table td {
        border: 1px solid #aaa;
        padding: 6px;
    }

    .table th {
        background: #f2f2f2;
    }

    .signature {
        position: fixed;
        bottom: 80px !important;
        right: 80px !important;
        text-align: center !important;
    }

    .signature img {
        width: 150px !important;
    }

    @media print {
        body {
            margin: 0;
        }
    }

    @page {
        size: A4;
        margin: 0;
    }
    </style>
</head>

<body>

    <div class="report-wrapper">
        <div class="report-box">

            <h3>Attendance Report</h3>
            <div class="sub-title">
                <?= htmlspecialchars($user['uname']) ?><br>
                <?= $fromText && $toText ? "$fromText to $toText" : "All Records" ?>
            </div>

            <table class="table">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Check In</th>
                        <th>Check Out</th>
                        <th>Status</th>
                        <th>OT (min)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($r = mysqli_fetch_assoc($q)): ?>
                    <tr>
                        <td><?= date("d-m-Y", strtotime($r['date'])) ?></td>
                        <td><?= $r['check_in'] ?: '-' ?></td>
                        <td><?= $r['check_out'] ?: '-' ?></td>
                        <td><?= $r['status'] ?></td>
                        <td><?= $r['overtime_minutes'] ?: 0 ?></td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>

            <!-- SIGNATURE -->
            <div class="signature">
                <img src="../../assets/img/print/syd-sig.webp">
                <div>_________________</div>
                <div>Authorised Signatory</div>
            </div>

        </div>
    </div>

    <script>
    window.onload = function() {
        window.print();
    };
    </script>

</body>

</html>