<?php
include "../../config/db.php";

$date = mysqli_real_escape_string($con, $_GET['date']);
$work_id = mysqli_real_escape_string($con, $_GET['work_id']);

$schedules = mysqli_query($con, "
    SELECT * FROM work_schedule 
    WHERE DATE(ws_date) = '$date' AND ws_for = '$work_id'
    ORDER BY ws_id DESC
");

if (mysqli_num_rows($schedules) == 0) {
    echo "<div class='alert alert-info text-center p-3 mt-3'>
            <i class='fa-solid fa-calendar-xmark me-2'></i>
            No work schedules found for <strong>" . date('d M Y', strtotime($date)) . "</strong>.
          </div>";
    exit;
}

$count = 1;
while ($row = mysqli_fetch_assoc($schedules)) {

    // Format date/time
    $fullDateTime = $row["ws_date"];
    $dateOnly = date("d M Y", strtotime($fullDateTime));
    $stime = date("h:i A", strtotime($row["ws_startTime"]));
    $etime = date("h:i A", strtotime($row["ws_endTime"]));

    // Compare current vs session time
    $currentDateTime = new DateTime();
    $sessionStart = new DateTime($fullDateTime . ' ' . $row["ws_startTime"]);
    $sessionEnd = new DateTime($fullDateTime . ' ' . $row["ws_endTime"]);

    // Get work list progress
    $wl_sql = mysqli_query($con, "SELECT * FROM work_list WHERE wl_ws_id = '{$row['ws_id']}'");
    $total = $completed = 0;
    while ($wl_r = mysqli_fetch_assoc($wl_sql)) {
        $total++;
        if ($wl_r['wl_status'] == 1) $completed++;
    }

    // Determine status + badge color
    if ($currentDateTime < $sessionStart) {
        $status = ["Upcoming", "secondary"];
    } elseif ($currentDateTime >= $sessionStart && $currentDateTime <= $sessionEnd) {
        $status = ["Ongoing", "info"];
    } else {
        if ($total == 0) {
            $status = ["Incomplete", "danger"];
        } elseif ($completed == $total) {
            $status = ["Completed", "success"];
        } elseif ($completed > 0) {
            $status = ["Partially Completed", "warning"];
        } else {
            $status = ["Incomplete", "danger"];
        }
    }
?>
<div class="accordion mb-3 overflow-hidden">
    <div class="heading text-white p-2 rounded-3 d-flex justify-content-between align-items-center shadow-sm"
        style="cursor:pointer;">
        <div class="d-flex align-items-center">
            <h5 class="mb-0 fw-semibold">
                <i class="fa-solid fa-calendar-day me-1"></i> <?= $dateOnly ?>
            </h5> &nbsp; &nbsp;
            <small class=""><i class="fa-solid fa-clock me-1"></i> (<?= $stime ?> - <?= $etime ?>)</small>
        </div>
        <div class="text-end">
            <span class="badge bg-<?= $status[1] ?>"><?= $status[0] ?></span>
            <?php if (!empty($row["ws_workPercent"])): ?>
            <span class="badge ms-1">Work: <?= $row["ws_workPercent"] ?>%</span>
            <?php endif; ?>
        </div>
    </div>

    <div class="contents p-3" style="display:none;">
        <!-- Remarks Section -->
        <div class="card p-3 mb-3 bg-white border">
            <p class="mb-1"><strong>Admin Remark:</strong>
                <?= !empty($row["ws_adminRemark"]) ? nl2br(htmlspecialchars($row["ws_adminRemark"])) : "<em>No admin remark.</em>" ?>
            </p>
            <p class="mb-0"><strong>Work Remark:</strong>
                <?= !empty($row["ws_workRemark"]) ? nl2br(htmlspecialchars($row["ws_workRemark"])) : "<em>No work remark.</em>" ?>
            </p>
        </div>

        <!-- Work List Section -->
        <?php
            $wl_sql = mysqli_query($con, "SELECT * FROM work_list WHERE wl_ws_id = '{$row['ws_id']}'");
            if (mysqli_num_rows($wl_sql) == 0) {
                echo "<div class='alert alert-light border text-center'>No tasks available for this schedule.</div>";
            } else {
                $i = 1;
                while ($wl_row = mysqli_fetch_assoc($wl_sql)) {
                    $statusBadge = $wl_row["wl_status"] == '1'
                        ? "<span class='badge bg-success ms-2'>Completed</span>"
                        : "<span class='badge bg-warning text-dark ms-2'>Pending</span>";
                    ?>
        <div class="card p-3 mb-2" style="background:#f7fbff;">
            <div class="d-flex justify-content-between align-items-center">
                <h6 class="mb-0 fw-bold">
                    <?= $i++ . ') ' . htmlspecialchars($wl_row["wl_title"]) ?> <?= $statusBadge ?>
                </h6>
            </div>
            <p class="mt-2 mb-0 text-muted"><?= $wl_row["wl_des"] ?></p>
        </div>
        <?php
                }
            }
            ?>
    </div>
</div>
<?php
    $count++;
}
?>

<!-- Accordion Toggle JS -->
<script>
// $(document).ready(function() {
//     $('.accordion .heading').off('click').on('click', function() {
//         const content = $(this).next('.contents');
//         $('.accordion .contents').not(content).slideUp(200);
//         $('.accordion .heading').not(this).removeClass('active');
//         $(this).toggleClass('active');
//         content.slideToggle(200);
//     });
// });
</script>