<?php
session_start();
include "../../config/db.php";

if (!isset($_SESSION['uid'])) {
    http_response_code(401);
    exit("UNAUTHORIZED");
}

$uid = (int)$_SESSION['uid'];

$q = $con->prepare("SELECT face_image FROM face_recog WHERE emp_id = ?");
$q->bind_param("i", $uid);
$q->execute();
$res = $q->get_result();

if ($res->num_rows === 0) {
    exit("NO_FACE");
}

$row = $res->fetch_assoc();

/*
  face_image in DB example:
  uploads/faces/emp_123.jpg
*/

$path = $row['face_image'];

/* Ensure correct prefix only once */
if (!str_starts_with($path, "HRM/")) {
    $path = "HRM/" . ltrim($path, "/");
}

echo $path;