<?php
session_start();
include "../../config/db.php";

if (!isset($_SESSION['uid'])) {
    die("Unauthorized");
}

$uid = $_SESSION['uid'];

/* =========================
   USER INFO
========================= */
$userQ = mysqli_query($con,"
    SELECT uname
    FROM users
    WHERE uid = '$uid'
");
$user = mysqli_fetch_assoc($userQ);

/* =========================
   FILTER
========================= */
$where = "user_id = $uid";

$fromText = $toText = '';

if (!empty($_GET['from']) && !empty($_GET['to'])) {
    $from = $_GET['from'];
    $to   = $_GET['to'];
    $fromText = date("d M Y", strtotime($from));
    $toText   = date("d M Y", strtotime($to));
    $where .= " AND start_date >= '$from' AND end_date <= '$to'";
}

/* =========================
   LEAVE DATA
========================= */
$q = mysqli_query($con,"
    SELECT *
    FROM leaves
    WHERE $where
    ORDER BY applied_on DESC
");
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Leave Report</title>

    <style>
    body {
        margin: 0;
        font-family: Arial, Helvetica, sans-serif;
        -webkit-print-color-adjust: exact;
        print-color-adjust: exact;
    }

    .report-wrapper {
        min-height: 94.55vh;
        background-image: url('../../assets/img/print/temp-night.webp') !important;
        background-repeat: no-repeat !important;
        background-size: 100% 100% !important;
        background-position: center !important;
        padding: 30px !important;
    }

    .report-box {
        max-width: 900px !important;
        margin: 0 auto !important;
        padding: 80px 0 20px 0 !important;
    }

    h3 {
        text-align: center;
        margin-bottom: 5px;
    }

    .sub-title {
        text-align: center;
        margin-bottom: 20px;
        font-size: 14px;
    }

    .table {
        width: 100%;
        border-collapse: collapse;
        font-size: 13px;
    }

    .table th,
    .table td {
        border: 1px solid #aaa;
        padding: 6px;
    }

    .table th {
        background: #f2f2f2;
    }

    .status-approved {
        color: green;
        font-weight: bold;
    }

    .status-rejected {
        color: red;
        font-weight: bold;
    }

    .status-pending {
        color: orange;
        font-weight: bold;
    }

    .signature {
        position: fixed;
        bottom: 80px;
        right: 80px;
        text-align: center;
    }

    .signature img {
        width: 150px;
    }

    @media print {
        body {
            margin: 0;
        }
    }

    @page {
        size: A4;
        margin: 0;
    }
    </style>
</head>

<body>

    <div class="report-wrapper">
        <div class="report-box">

            <h3>Leave Report</h3>
            <div class="sub-title">
                <?= htmlspecialchars($user['uname']) ?><br>
                <?= $fromText && $toText ? "$fromText to $toText" : "All Records" ?>
            </div>

            <table class="table">
                <thead>
                    <tr>
                        <th>Leave Type</th>
                        <th>From</th>
                        <th>To</th>
                        <th>Status</th>
                        <th>Applied On</th>
                        <th>Remarks</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($r = mysqli_fetch_assoc($q)): ?>
                    <tr>
                        <td><?= $r['leave_type'] ?></td>
                        <td><?= date("d-m-Y", strtotime($r['start_date'])) ?></td>
                        <td><?= date("d-m-Y", strtotime($r['end_date'])) ?></td>
                        <td class="status-<?= strtolower($r['status']) ?>">
                            <?= $r['status'] ?>
                        </td>
                        <td><?= date("d-m-Y", strtotime($r['applied_on'])) ?></td>
                        <td><?= $r['remarks'] ?: '-' ?></td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>

            <!-- SIGNATURE -->
            <div class="signature">
                <img src="../../assets/img/print/syd-sig.webp">
                <div>_________________</div>
                <div>Authorised Signatory</div>
            </div>

        </div>
    </div>

    <script>
    window.onload = function() {
        window.print();
    };
    </script>

</body>

</html>