<?php
session_start();
include "../../config/db.php";

if (!isset($_SESSION['uid'])) {
    exit;
}

$uid = $_SESSION['uid'];

/* =========================
   FILTER
========================= */
$where = "ws_for = '$uid'";

if (!empty($_GET['from']) && !empty($_GET['to'])) {
    $from = $_GET['from'];
    $to   = $_GET['to'];
    $where .= " AND ws_date BETWEEN '$from' AND '$to'";
}

/* =========================
   WORK SCHEDULE
========================= */
$q = mysqli_query($con,"
    SELECT *
    FROM work_schedule
    WHERE $where
    ORDER BY ws_date DESC
");

if (mysqli_num_rows($q) == 0) {
    echo "<div class='alert alert-light text-center'>No work records found.</div>";
    exit;
}
?>

<div class="d-flex justify-content-end gap-2 mb-3">
    <a href="ajax/work_export_csv.php?<?= http_build_query($_GET) ?>" class="btn btn-success btn-sm">
        <i class="fa fa-file-csv"></i> CSV
    </a>

    <a href="ajax/work_export_pdf.php?<?= http_build_query($_GET) ?>" target="_blank" class="btn btn-danger btn-sm">
        <i class="fa fa-file-pdf"></i> PDF
    </a>
</div>
<?php while ($ws = mysqli_fetch_assoc($q)): ?>

<div class="card mb-3 shadow-sm">
    <div class="card-body">
        <!-- HEADER -->
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <strong>Date:</strong> <?= date("d M Y", strtotime($ws['ws_date'])) ?>
                <strong class="d-none">Status:</strong>
                <span class="d-none badge bg-<?= $ws['ws_status'] == 1 ? 'success' : 'warning' ?>">
                    <i class="fa <?= $ws['ws_status'] == 1 ? 'fa-check-circle' : 'fa-clock' ?>"></i>
                    <?= $ws['ws_status'] == 1 ? 'Completed' : 'Pending' ?>
                </span>

            </div>

            <div class="text-muted small">
                <?= $ws['ws_workPercent'] ? $ws['ws_workPercent'].'%' : '' ?>
            </div>
        </div>

        <!-- WORK LIST -->
        <div class="mt-1">
            <strong>Work Items:</strong>

            <ul class="list-group list-group-flush mt-2">
                <?php
                $wl = mysqli_query($con,"
                    SELECT
                        wl_title,
                        wl_des,
                        wl_status,
                        wl_statusUpdateDT
                    FROM work_list
                    WHERE wl_ws_id = '{$ws['ws_id']}'
                      AND wl_recycle = '1'
                    ORDER BY wl_uploadDT ASC
                ");

                if (mysqli_num_rows($wl) == 0):
                ?>
                <li class="list-group-item text-muted">
                    No work items added.
                </li>
                <?php
                else:
                    while ($w = mysqli_fetch_assoc($wl)):
                ?>
                <li class="list-group-item">
                    <div class="d-flex justify-content-between">
                        <div>
                            <strong><?= htmlspecialchars($w['wl_title']) ?></strong>
                            <?php if (!empty($w['wl_des'])): ?>
                            <div class="text-muted small">
                                <?= $w['wl_des'] ?>
                            </div>
                            <?php endif; ?>
                        </div>

                        <div class="text-end">
                            <span class="badge bg-<?= $w['wl_status'] == 1 ? 'success' : 'warning' ?>">
                                <i class="fa <?= $w['wl_status'] == 1 ? 'fa-check-circle' : 'fa-clock' ?>"></i>
                                <?= $w['wl_status'] == 1 ? 'Completed' : 'Pending' ?>
                            </span>

                            <div class="small text-muted">
                                <?= $w['wl_statusUpdateDT']
                                        ? date("d M Y H:i", strtotime($w['wl_statusUpdateDT']))
                                        : ''
                                    ?>
                            </div>
                        </div>
                    </div>
                </li>
                <?php
                    endwhile;
                endif;
                ?>
            </ul>
        </div>

    </div>
</div>

<?php endwhile; ?>